/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Identity;
import Ice.Logger;
import IceInternal.BasicStream;
import IceInternal.TraceLevels;
import IceUtil.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public final class TraceUtil {
    public static void traceHeader(String string, BasicStream basicStream, Logger logger, TraceLevels traceLevels) {
        if (traceLevels.protocol >= 1) {
            int n = basicStream.pos();
            basicStream.pos(0);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            printStream.print(string);
            TraceUtil.printHeader(printStream, basicStream);
            logger.trace(traceLevels.protocolCat, ((Object)byteArrayOutputStream).toString());
            basicStream.pos(n);
        }
    }

    public static void traceRequest(String string, BasicStream basicStream, Logger logger, TraceLevels traceLevels) {
        if (traceLevels.protocol >= 1) {
            int n = basicStream.pos();
            basicStream.pos(0);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            printStream.print(string);
            TraceUtil.printHeader(printStream, basicStream);
            int n2 = basicStream.readInt();
            printStream.print("\nrequest id = " + n2);
            if (n2 == 0) {
                printStream.print(" (oneway)");
            }
            TraceUtil.printRequestHeader(printStream, basicStream);
            logger.trace(traceLevels.protocolCat, ((Object)byteArrayOutputStream).toString());
            basicStream.pos(n);
        }
    }

    public static void traceBatchRequest(String string, BasicStream basicStream, Logger logger, TraceLevels traceLevels) {
        if (traceLevels.protocol >= 1) {
            int n = basicStream.pos();
            basicStream.pos(0);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            printStream.print(string);
            TraceUtil.printHeader(printStream, basicStream);
            int n2 = basicStream.readInt();
            printStream.print("\nnumber of requests = " + n2);
            for (int i = 0; i < n2; ++i) {
                printStream.print("\nrequest #" + i + ':');
                TraceUtil.printRequestHeader(printStream, basicStream);
                basicStream.skipEncaps();
            }
            logger.trace(traceLevels.protocolCat, ((Object)byteArrayOutputStream).toString());
            basicStream.pos(n);
        }
    }

    public static void traceReply(String string, BasicStream basicStream, Logger logger, TraceLevels traceLevels) {
        if (traceLevels.protocol >= 1) {
            int n = basicStream.pos();
            basicStream.pos(0);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            printStream.print(string);
            TraceUtil.printHeader(printStream, basicStream);
            int n2 = basicStream.readInt();
            printStream.print("\nrequest id = " + n2);
            byte by = basicStream.readByte();
            printStream.print("\nreply status = " + by + ' ');
            switch (by) {
                case 0: {
                    printStream.print("(ok)");
                    break;
                }
                case 1: {
                    printStream.print("(user exception)");
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    switch (by) {
                        case 2: {
                            printStream.print("(object not exist)");
                            break;
                        }
                        case 3: {
                            printStream.print("(facet not exist)");
                            break;
                        }
                        case 4: {
                            printStream.print("(operation not exist)");
                            break;
                        }
                    }
                    TraceUtil.printIdentityFacetOperation(printStream, basicStream);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    switch (by) {
                        case 7: {
                            printStream.print("(unknown exception)");
                            break;
                        }
                        case 5: {
                            printStream.print("(unknown local exception)");
                            break;
                        }
                        case 6: {
                            printStream.print("(unknown user exception)");
                            break;
                        }
                    }
                    String string2 = basicStream.readString();
                    printStream.print("\nunknown = " + string2);
                    break;
                }
                default: {
                    printStream.print("(unknown)");
                }
            }
            logger.trace(traceLevels.protocolCat, ((Object)byteArrayOutputStream).toString());
            basicStream.pos(n);
        }
    }

    public static void dumpStream(BasicStream basicStream) {
        int n = basicStream.pos();
        basicStream.pos(0);
        byte[] byArray = basicStream.readBlob(basicStream.size());
        TraceUtil.dumpOctets(byArray);
        basicStream.pos(n);
    }

    public static void dumpOctets(byte[] byArray) {
        for (int i = 0; i < byArray.length; i += 8) {
            int n = i;
            while (n - i < 8) {
                if (n < byArray.length) {
                    int n2 = byArray[n];
                    if (n2 < 0) {
                        n2 += 256;
                    }
                    String string = n2 < 10 ? "  " + n2 : (n2 < 100 ? " " + n2 : "" + n2);
                    System.out.print(string + " ");
                } else {
                    System.out.print("    ");
                }
                ++n;
            }
            System.out.print('\"');
            for (n = i; n < byArray.length && n - i < 8; ++n) {
                if (byArray[n] >= 32 && byArray[n] < 127) {
                    System.out.print((char)byArray[n]);
                    continue;
                }
                System.out.print('.');
            }
            System.out.println('\"');
        }
    }

    private static void printIdentityFacetOperation(PrintStream printStream, BasicStream basicStream) {
        Identity identity = new Identity();
        identity.__read(basicStream);
        printStream.print("\nidentity = " + basicStream.instance().identityToString(identity));
        String[] stringArray = basicStream.readStringSeq();
        printStream.print("\nfacet = ");
        if (stringArray.length > 0) {
            printStream.print(StringUtil.escapeString(stringArray[0], ""));
        }
        String string = basicStream.readString();
        printStream.print("\noperation = " + string);
    }

    private static void printRequestHeader(PrintStream printStream, BasicStream basicStream) {
        TraceUtil.printIdentityFacetOperation(printStream, basicStream);
        byte by = basicStream.readByte();
        printStream.print("\nmode = " + by + ' ');
        switch (by) {
            case 0: {
                printStream.print("(normal)");
                break;
            }
            case 1: {
                printStream.print("(nonmutating)");
                break;
            }
            case 2: {
                printStream.print("(idempotent)");
                break;
            }
            default: {
                printStream.print("(unknown)");
            }
        }
        int n = basicStream.readSize();
        printStream.print("\ncontext = ");
        while (n-- > 0) {
            String string = basicStream.readString();
            String string2 = basicStream.readString();
            printStream.print(string + '/' + string2);
            if (n <= 0) continue;
            printStream.print(", ");
        }
    }

    private static void printHeader(PrintStream printStream, BasicStream basicStream) {
        byte by = basicStream.readByte();
        by = basicStream.readByte();
        by = basicStream.readByte();
        by = basicStream.readByte();
        byte by2 = basicStream.readByte();
        byte by3 = basicStream.readByte();
        byte by4 = basicStream.readByte();
        byte by5 = basicStream.readByte();
        byte by6 = basicStream.readByte();
        printStream.print("\nmessage type = " + by6 + ' ');
        switch (by6) {
            case 0: {
                printStream.print("(request)");
                break;
            }
            case 1: {
                printStream.print("(batch request)");
                break;
            }
            case 2: {
                printStream.print("(reply)");
                break;
            }
            case 4: {
                printStream.print("(close connection)");
                break;
            }
            case 3: {
                printStream.print("(validate connection)");
                break;
            }
            default: {
                printStream.print("(unknown)");
            }
        }
        byte by7 = basicStream.readByte();
        printStream.print("\ncompression status = " + by7 + ' ');
        switch (by7) {
            case 0: {
                printStream.print("(not compressed; do not compress response, if any)");
                break;
            }
            case 1: {
                printStream.print("(not compressed; compress response, if any)");
                break;
            }
            case 2: {
                printStream.print("(compressed; compress response, if any)");
                break;
            }
            default: {
                printStream.print("(unknown)");
            }
        }
        int n = basicStream.readInt();
        printStream.print("\nmessage size = " + n);
    }
}

