/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include "types.h"
#include "debug.h"

#if MEMDEBUG
int option_count = 0;
int string_count = 0;
#endif

#if DEBUG

void debugOptions(Option *option) {
	printf("\nDebugging option stack (0x%08X)\n", (unsigned int)option);

	while (option != NULL) {
		printf("Key:   %s\n"
		       "Value: %s\n",
		       option->key, option->value);
		option = option->next;
	}

	printf("Finished option stack\n\n");
}

void debugString(String *str) {
	int i = 0;

	printf("STRING: ");
	while (i < str->length)
		printf("%02X ", str->string[i++]);

	printf("\n");
}

#endif
