/*
 *
 * This file is part of Tulip (www.tulip-software.org)
 *
 * Authors: David Auber and the Tulip development Team
 * from LaBRI, University of Bordeaux 1 and Inria Bordeaux - Sud Ouest
 *
 * Tulip is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 *
 * Tulip is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 */
///@cond DOXYGEN_HIDDEN


#ifndef JSON_TOKENS_H
#define JSON_TOKENS_H

#include <string>

const std::string GraphToken = "graph";
const std::string GraphIDToken = "graphID";
const std::string NodesIDsToken = "nodesIDs";
const std::string NodesNumberToken = "nodesNumber";
const std::string EdgesToken = "edges";
const std::string EdgesNumberToken = "edgesNumber";
const std::string EdgesValuesToken = "edgesValues";
const std::string NodesValuesToken = "nodes";
const std::string AttributesToken = "attributes";
const std::string EdgesIDsToken = "edgesIDs";
const std::string EdgeDefaultToken = "edgeDefault";
const std::string NodeDefaultToken = "nodeDefault";
const std::string PropertiesToken = "properties";
const std::string TypeToken = "type";
const std::string SubgraphsToken = "subgraphs";

#endif //JSON_TOKENS_H
///@endcond