/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_REPOSITORYLVI_H
#define _SC_REPOSITORYLVI_H

// sc
#include "ScLvi.h"
#include "Project.h"
#include "commands/ScCmdData.h"
class ProjectFoldersWidget;
class RepositoryModel;
class CmdEvent;
class Project;
class ScCmd;

namespace svn
{
  class Error;
}

// qt
class QPopupMenu;


/**
 * QListViewItem representing repository folders
 */
class RepositoryLvi : public ScLvi
{
  typedef ScLvi super;

public:
   /**
   * root constructor
   */
  RepositoryLvi( QListViewItem* parent, RepositoryModel* rmodel, Project* prj,
    const Project::Item& wcItem );

  /**
   * child constructor
   */
  RepositoryLvi( RepositoryLvi* parent, RepositoryModel* rmodel, Project* prj,
    QString repPath );
  ~RepositoryLvi();

  static void setupActions( ProjectFoldersWidget* parent );
  static QPopupMenu* getMenu();

  // qlistviewitem
  QString text( int column ) const;
  int compare( QListViewItem* i, int col, bool ascending ) const;
  void paintFocus( QPainter * p, const QColorGroup & cg, const QRect & r );
  void paintCell( QPainter *p, const QColorGroup & cg, int column, int width, int alignment );
  bool acceptDrop( const QMimeSource* mime ) const;
  void dropped( QDropEvent* e );

  // ScLvi
  void onItem();
  void pressed( bool refresh );
  void renamed( const QString& text );
  void contextMenuRequest( const QPoint& pos, int col );
  long getSortPos() const;
  QDragObject* dragObject();

  bool isRoot() const;

  QString getRepositoryUrl() const;
  Project* getProject() const;
  const Project::Item& getProjectItem() const;
  void setProjectItem( const Project::Item& );

  virtual QString getUrl() const;

  void enableActions();
  void disableActions();

  void checkout();
  void switchx();
  /**
   * run diff between this items URL and the given \b lvi.
   * If \b lvi is 0 use this items URL for both diff URLs.
   *
   * \param lvi second diff URL or 0.
   */
  void diff( RepositoryLvi* lvi );
  void log();
  void branch();
  void tag();

  ScLviAccept(RepositoryLvi);

private:
  void init( const QString& text );

protected:
  RepositoryModel* _rpModel;

  Project*         _prj;
  Project::Item    _item;

  bool             _root;
};

typedef SimpleCmdData<RepositoryLvi*> RepositoryLviCmdData;

template<typename T> inline RepositoryLvi* RpLvi_cast(T *p)
{
  return dynamic_cast<RepositoryLvi*>(p);
}

#endif // _SC_REPOSITORYLVI_H
