#include <cmath>
#include <limits>
#include <vector>
#include <Eigen/Dense>


namespace StOpt
{
  /// \brief test equality of two vector<ArrayXi>
  bool vectorArrayXiEq(std::vector<Eigen::ArrayXi> const& a, std::vector<Eigen::ArrayXi> const& b) {
    assert(a.size() == b.size());
    for(size_t i = 0 ; i < a.size() ; ++i)
      {
        assert(a[i].size() == b[i].size());
        for (int j = 0 ; j < a[i].size() ; j++)
	  {
            if(abs(a[i][j] - b[i][j]) > std::numeric_limits<double>::epsilon()) return false;
	  }
      }
    return true;
  }
}
