/*
  daemon -- functions for running as daemon
  Copyright (C) 2003  Pedro Zorzenon Neto <pzn@autsens.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _DAEMON_H
#define _DAEMON_H

#define DAEMON_PIDPREFIX "/var/run/"
#define DAEMON_PIDSUFFIX ".pid"

void daemon_fork (void); /* forks, terminate parent, child continues */
void daemon_pid (char * name); /* creates /var/run/NAME.pid file */
void daemon_drop (int uid, int gid); /* drop root privileges */
void daemon_tty (void); /* detaches from controlling tty */
void daemon_null (void); /* redirect stdin, stdout, stderr to /dev/null */

/* inspired by the movie Forest Gump */
void run_daemon_run (char * name, int uid, int gid); /* executes _fork,
							_pid, _drop, _tty
							and _null */
/* if you do not want run_daemon_run to drop privileges, call it
 * with uid=-1 and gid=-1 */

#endif
