1.1 Live Coding

# Live Coding

Uno de los aspectos más excitantes de Sonic Pi es la posibilidad de
escribir y modificar código en vivo para hacer música, así como lo
harías al tocar una guitarra. Esto significa que con algo de práctica
podrás usar Sonic Pi en escena y tocar con él. 

## Libera tu mente

Antes de entrar en los detalles de cómo funciona Sonic Pi en el resto de 
este tutorial, me gustaría darte una experiencia de lo que es codificar
en vivo.
No te preocupes si no entiendes mucho (o nada) de esto. Sólo intenta
permanecer sentado y disfrutar...

## Un Bucle Vivo

Comencemos copiando el siguiente código en un buffer vacío arriba:

```
live_loop :flibble do
  sample :bd_haus, rate: 1
  sleep 0.5
end
```

Ahora presiona el botón "Ejecutar" y escucharás una batería tocada
rápidamente. Si en cualquier momento deseas parar el sonido, sólo 
debes presional el botón "Parar". Pero no lo pares, aún...En vez de ello
sigue los siguientes pasos:

1. Asegúrate que el sonido de batería sigue sonando.
2. Cambia el valor "sleep" desde "0.5" a algo más alto como "1".
3. Presiona de nuevo el botón "Ejecutar".
4. ¿Notas cómo cambió la velocidad de la batería?.
5. Finalmente, *recuerda este momento*, esta es la primera vez
   que has codificado en tiempo real con Sonic Pi y muy probablemente
   no será tu última...

Ok, eso fue lo suficientemente sencillo. Añadamos algo a la mezcla.
Encima de `sample :bd_haus` añade la línea `sample :ambi_choir, rate: 0.3`.
Tu código debería mirarse, así:

```
live_loop :flibble do
  sample :ambi_choir, rate: 0.3
  sample :bd_haus, rate: 1
  sleep 1
end
```
Ahora juega, cambia valores. ¿qué pasa cuando usas valores altos, bajos
o negativos? Mira lo que pasa cuando cambias el valor `rate:`
por `:ambi_choir` ajustalo mìnimamente (digamos a 0.29). ¿Qué pasa si 
pones un valor muy bajo para `sleep` ? Mira si puedes hacerlo sonar tan
ràpido que tu computadora se paraliza con un error (si eso sucede, simplemente
elige un valor más alto para `sleep` y presiona `Ejecutar` de nuevo).

Prueba a comentar una de las líneas del ejemplo, añadiendo un `#` al
comienzo: 

```
live_loop :flibble do
  sample :ambi_choir, rate: 0.3
#  sample :bd_haus, rate: 1
  sleep 1
end

```

¿Notas que el numeral hace que la computadora ignore esa línea?
Esto se llama 'comentar'. En sonic Pi podemos usar comentarios para 
quitar y añadir cosas a la mezcla.

Finalmente, te dejo con algo divertido con lo que jugar. Toma el siguiente
código y cópialo en un buffer vacío. Por el momento no intentes
comprender demasiado más que notar que hay dos bucles - lo que significa
que hay dos eventos al mismo tiempo - experimenta y juega. Te dejo algunas
sugerencias:

* Prueba cambiando el valor de `rate:` para escuchar cambios en el sample.
* Prueba cambiando los tiempos de `sleep` y presta atención a cómo
  ambos bucles dan vueltas a diferentes valores.
* Prueba quitando el numeral de la línea de ejemplo y disfruta el sonidos
  de la guitarra en reversa.
* Prueba cambiando cualquiera de los valores azules `mix:` a números entre
  `0` (no en la mezcla) y `1` (totalmente en la mezcla).

Recuerda que debes presionar 'Ejecutar' para escuchar el cambio en el próximo
bucle. Si termina siendo un relajo, no te preocupes - dale a 'Parar', borra el
código del buffer y pega una copia fresca para volver a comenzar. Cometiendo
errores es como aprenderás más rápidamente.


```
live_loop :guit do
  with_fx :echo, mix: 0.3, phase: 0.25 do
    sample :guit_em9, rate: 0.5
  end
#  sample :guit_em9, rate: -0.5
  sleep 8
end

live_loop :boom do
  with_fx :reverb, room: 1 do
    sample :bd_boom, amp: 10, rate: 1
  end
  sleep 8
end
```

Ahora, sigue tocando y experimentando hasta que tu curiosidad acerca
de todo esto se dispare y comiences a preguntarte ¿qué más puedes
hacer? Ya estás listo para leer el resto del tutorial.

Así que: ¿qué estás esperando?
