/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 * Copyright (C) 2007-2009  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/**
 * @defgroup SmlElements SyncML Elements
 * @ingroup PublicLowLevelAPI
 * @brief The public part
 * 
 */
/*@{*/

#ifndef _SML_ELEMENTS_H_
#define _SML_ELEMENTS_H_

SmlLocation *smlLocationNew			(const char *locURI, const char *locName, SmlError **error);
SmlLocation	*smlLocationRef			(SmlLocation *loc);
void 		smlLocationUnref		(SmlLocation *loc);

const char	*smlLocationGetURI		(SmlLocation *loc);
const char	*smlLocationGetName		(SmlLocation *loc);
void		smlLocationSetName(SmlLocation *loc, const char *name);
void		smlLocationCopy			(SmlLocation *source, SmlLocation *target);
SmlLocation	*smlLocationClone		(SmlLocation *source, SmlError **error);
SmlBool		smlLocationCompare		(SmlLocation *objectroot, SmlLocation *object, SmlLocation *urlroot, SmlLocation *url);
SmlBool		smlLocationIsRelative	(SmlLocation *location);

SmlCred *smlCredNewFromString(const char *type, const char *format, const char *data, SmlError **error);
SmlCred *smlCredNewAuth(SmlAuthType type, const char *username, const char *password, SmlError **error);
SmlCred *smlCredNew(SmlAuthType type, SmlFormatType format, const char *data, const char*username, SmlError **error);
void smlCredRef(SmlCred *cred);
void smlCredUnref(SmlCred *cred);
void smlCredFree(SmlCred *cred) LIBSYNCML_DEPRECATED; /* expire date: 20090120 */

SmlAnchor *smlAnchorNew(const char *last, const char *next, SmlError **error);
void smlAnchorFree(SmlAnchor *anchor);

SmlItem *smlItemNew(unsigned int size, SmlError **error);
SmlItem *smlItemNewForData(const char *data, unsigned int size, SmlError **error);
SmlItem *smlItemRef(SmlItem *item);
void smlItemUnref(SmlItem *item);
SmlBool smlItemAddData(SmlItem *item, const char *data, unsigned int size, SmlError **error);
SmlBool smlItemCheck(SmlItem *item);
SmlBool smlItemHasData(SmlItem *item);
SmlBool smlItemGetData(SmlItem *item, char **data, unsigned int *size, SmlError **error);
SmlBool smlItemStealData(SmlItem *item, char **data, unsigned int *size, SmlError **error);

void smlItemSetSource(SmlItem *item, SmlLocation *source);
SmlLocation *smlItemGetSource(SmlItem *item);
void smlItemSetTarget(SmlItem *item, SmlLocation *target);
SmlLocation *smlItemGetTarget(SmlItem *item);
void smlItemSetSourceParent(SmlItem *item, SmlLocation *sourceParent);
SmlLocation *smlItemGetSourceParent(SmlItem *item);
void smlItemSetTargetParent(SmlItem *item, SmlLocation *targeParent);
SmlLocation *smlItemGetTargetParent(SmlItem *item);
void smlItemSetRaw(SmlItem *item, SmlBool raw);

void smlHeaderFree(SmlHeader *header);

SmlChal *smlChalNew(SmlAuthType type, SmlError **error);
SmlChal *smlChalNewFromBinary(SmlAuthType type, const char *nonce, size_t length, SmlError **error);
SmlChal *smlChalNewFromBase64(SmlAuthType type, const char *nonce, SmlError **error);
void smlChalRef(SmlChal *chal);
void smlChalUnref(SmlChal *chal);
void smlChalFree(SmlChal *chal) LIBSYNCML_DEPRECATED; /* expire date: 20090417 */

SmlMapItem *smlMapItemNew(const char *uid, const char *newuid, SmlError **error);
SmlMapItem *smlMapItemRef(SmlMapItem *item);
void smlMapItemUnref(SmlMapItem *item);

#endif //_SML_ELEMENTS_H_

/*@}*/
