#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Cats Hidden in Places:
# - Cats Hidden in Paris
# - Cats Hidden in Italy
# send your bug reports to contact@dotslashplay.it
###

script_version=20231220.5

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID_PARIS='cats-hidden-in-paris'
GAME_NAME_PARIS='Cats Hidden in Paris'

GAME_ID_ITALY='cats-hidden-in-italy'
GAME_NAME_ITALY='Cats Hidden in Italy'

# Archives

## Cats Hidden in Paris

ARCHIVE_BASE_PARIS_0_NAME='setup_cats_hidden_in_paris_1.0_gog_dlc_fix6_(69829).exe'
ARCHIVE_BASE_PARIS_0_MD5='6b55ff57a52f1edd2990133737c870cd'
ARCHIVE_BASE_PARIS_0_TYPE='innosetup'
ARCHIVE_BASE_PARIS_0_SIZE='106572'
ARCHIVE_BASE_PARIS_0_VERSION='1.0-gog69829'
ARCHIVE_BASE_PARIS_0_URL='https://www.gog.com/game/cats_hidden_in_paris'

## Cats Hidden in Italy

ARCHIVE_BASE_ITALY_0_NAME='setup_cats_hidden_in_italy_1.0_gog_savefix_proper_(69657).exe'
ARCHIVE_BASE_ITALY_0_MD5='7564fdad50e6e655cb16bca17db30058'
ARCHIVE_BASE_ITALY_0_TYPE='innosetup'
ARCHIVE_BASE_ITALY_0_SIZE='102010'
ARCHIVE_BASE_ITALY_0_VERSION='1.0-gog69657'
ARCHIVE_BASE_ITALY_0_URL='https://www.gog.com/game/cats_hidden_in_italy'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
modules'
CONTENT_GAME0_BIN_FILES_PARIS='
cats hidden in paris.exe'
CONTENT_GAME0_BIN_FILES_ITALY='
cats hidden in italy.exe'
CONTENT_GAME_DATA_FILES='
sounds'
CONTENT_GAME0_DATA_FILES_PARIS='
cats hidden in paris.dat'
CONTENT_GAME0_DATA_FILES_ITALY='
cats hidden in italy.dat'

WINE_PERSISTENT_DIRECTORIES_PARIS='
users/${USER}/AppData/Roaming/Cats Hidden in Paris'
WINE_PERSISTENT_DIRECTORIES_ITALY='
users/${USER}/AppData/Roaming/Cats Hidden in Italy'

APP_MAIN_EXE_PARIS='cats hidden in paris.exe'
APP_MAIN_EXE_ITALY='cats hidden in italy.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID_PARIS="${GAME_ID_PARIS}-data"
PKG_DATA_ID_ITALY="${GAME_ID_ITALY}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS_PARIS="$PKG_DATA_ID_PARIS"
PKG_BIN_DEPS_ITALY="$PKG_DATA_ID_ITALY"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
