/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.CloseableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class CloserUtil {
    public static void close(Object obj) {
        if (obj != null) {
            CloserUtil.close(Arrays.asList(obj));
        }
    }

    public static void close(List<? extends Object> objs) {
        for (Object object : objs) {
            if (object instanceof Closeable) {
                try {
                    ((Closeable)object).close();
                }
                catch (IOException ioe) {}
                continue;
            }
            if (object instanceof CloseableIterator) {
                ((CloseableIterator)object).close();
                continue;
            }
            try {
                Method m = object.getClass().getMethod("close", new Class[0]);
                m.invoke(object, new Object[0]);
            }
            catch (Exception exception) {}
        }
    }
}

