/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSecHeader {
    protected String actor = null;
    protected boolean mustunderstand = true;
    protected boolean doDebug = false;
    private Element securityHeader = null;

    public WSSecHeader() {
    }

    public WSSecHeader(String actor) {
        this(actor, true);
    }

    public WSSecHeader(String act, boolean mu) {
        this.actor = act;
        this.mustunderstand = mu;
    }

    public void setActor(String act) {
        this.actor = act;
    }

    public void setMustUnderstand(boolean mu) {
        this.mustunderstand = mu;
    }

    public Element getSecurityHeader() {
        return this.securityHeader;
    }

    public boolean isEmpty(Document doc) {
        if (this.securityHeader == null) {
            this.securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(doc, doc.getDocumentElement(), this.actor, false);
            if (this.securityHeader == null) {
                return true;
            }
        }
        return this.securityHeader.getChildNodes().getLength() == 0;
    }

    public Element insertSecurityHeader(Document doc) {
        if (this.securityHeader != null) {
            return this.securityHeader;
        }
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        this.securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(doc, doc.getDocumentElement(), this.actor, true);
        String soapPrefix = WSSecurityUtil.setNamespace(this.securityHeader, soapConstants.getEnvelopeURI(), "soapenv");
        if (this.actor != null && this.actor.length() > 0) {
            this.securityHeader.setAttributeNS(soapConstants.getEnvelopeURI(), soapPrefix + ":" + soapConstants.getRoleAttributeQName().getLocalPart(), this.actor);
        }
        if (this.mustunderstand) {
            this.securityHeader.setAttributeNS(soapConstants.getEnvelopeURI(), soapPrefix + ":" + "mustUnderstand", soapConstants.getMustUnderstand());
        }
        return this.securityHeader;
    }

    public void removeSecurityHeader(Document doc) {
        if (this.securityHeader == null) {
            this.securityHeader = WSSecurityUtil.findWsseSecurityHeaderBlock(doc, doc.getDocumentElement(), this.actor, false);
            if (this.securityHeader == null) {
                return;
            }
        }
        Node parent = this.securityHeader.getParentNode();
        parent.removeChild(this.securityHeader);
    }
}

