#!perl

#
# Copyright 2014 Chris West (Faux)
#
# This file is part of strip-nondeterminism.
#
# strip-nondeterminism is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# strip-nondeterminism is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with strip-nondeterminism.  If not, see <http://www.gnu.org/licenses/>.
#

use File::Temp 'tempdir';
use Test::More tests => 3;
use File::StripNondeterminism;

my $dir = tempdir( CLEANUP => 1 );
my $path1 = "$dir/a.html";
my $path2 = "$dir/b.html";
my $original = <<'ORIGINAL';
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<!-- NewPage -->
<html lang="fr">
<head>
<!-- Generated by javadoc (1.8.0_20) on Mon Oct 27 21:31:13 GMT 2014 -->
<title>Generated Documentation (Untitled)</title>
<meta name="date" content="2014-10-27">
<script type="text/javascript">;
ORIGINAL

for my $path ($path1, $path2) {
	open(my $fh, '>', $path) or die("error opening $path");
	binmode $fh;
	print $fh $original;
	close $fh;
}

# Test 1: make sure normalizer was found
my $normalizer = File::StripNondeterminism::get_normalizer_for_file($path1);
isnt(undef, $normalizer);

# Test 2: normalize without a canonical time
$normalizer->($path1);

open(my $fh, '<', $path1) or die("error opening $path1");
binmode $fh;
is(do { local $/; <$fh> }, <<'EXPECTED');
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<!-- NewPage -->
<html>
<head>
<title>Generated Documentation (Untitled)</title>
<script type="text/javascript">;
EXPECTED
close $fh;

# Test 3: normalize with a canonical time
$File::StripNondeterminism::canonical_time = 1423159771;
$normalizer->($path2);

open($fh, '<', $path2) or die("error opening $path2");
binmode $fh;
is(do { local $/; <$fh> }, <<'EXPECTED');
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd">
<!-- NewPage -->
<html>
<head>
<title>Generated Documentation (Untitled)</title>
<meta name="date" content="2015-02-05">
<script type="text/javascript">;
EXPECTED
close $fh;
