/*
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (c) 2019 Andes Technology Corporation
 *
 * Authors:
 *   Zong Li <zong@andestech.com>
 *   Nylon Chen <nylon7@andestech.com>
 */

#ifndef _AE350_PLATFORM_H_
#define _AE350_PLATFORM_H_

#define AE350_HART_COUNT		4
#define AE350_HART_STACK_SIZE		8192

#define AE350_PLIC_ADDR			0xe4000000
#define AE350_PLIC_NUM_SOURCES		71

#define AE350_PLICSW_ADDR		0xe6400000

#define AE350_PLMT_ADDR			0xe6000000

#define AE350_L2C_ADDR			0xe0500000

#define AE350_UART_ADDR_OFFSET		0x20
#define AE350_UART_ADDR			(0xf0300000 + AE350_UART_ADDR_OFFSET)
#define AE350_UART_FREQUENCY		19660800
#define AE350_UART_BAUDRATE		38400
#define AE350_UART_REG_SHIFT		2
#define AE350_UART_REG_WIDTH		0

/* nds mcache_ctl register*/
#define CSR_MCACHECTL			0x7ca

#define V5_MCACHE_CTL_IC_EN_OFFSET      0
#define V5_MCACHE_CTL_DC_EN_OFFSET      1
#define V5_MCACHE_CTL_IC_ECCEN_OFFSET   2
#define V5_MCACHE_CTL_DC_ECCEN_OFFSET   4
#define V5_MCACHE_CTL_IC_RWECC_OFFSET   6
#define V5_MCACHE_CTL_DC_RWECC_OFFSET   7
#define V5_MCACHE_CTL_CCTL_SUEN_OFFSET  8

#define V5_MCACHE_CTL_IC_EN     (1UL << V5_MCACHE_CTL_IC_EN_OFFSET)
#define V5_MCACHE_CTL_DC_EN     (1UL << V5_MCACHE_CTL_DC_EN_OFFSET)
#define V5_MCACHE_CTL_IC_RWECC  (1UL << V5_MCACHE_CTL_IC_RWECC_OFFSET)
#define V5_MCACHE_CTL_DC_RWECC  (1UL << V5_MCACHE_CTL_DC_RWECC_OFFSET)
#define V5_MCACHE_CTL_CCTL_SUEN (1UL << V5_MCACHE_CTL_CCTL_SUEN_OFFSET)

#define V5_L2C_CTL_OFFSET           0x8
#define V5_L2C_CTL_ENABLE_OFFSET    0
#define V5_L2C_CTL_IPFDPT_OFFSET    3
#define V5_L2C_CTL_DPFDPT_OFFSET    5
#define V5_L2C_CTL_TRAMOCTL_OFFSET  8
#define V5_L2C_CTL_TRAMICTL_OFFSET  10
#define V5_L2C_CTL_DRAMOCTL_OFFSET  11
#define V5_L2C_CTL_DRAMICTL_OFFSET  13

#define V5_L2C_CTL_ENABLE_MASK      (1UL << V5_L2C_CTL_ENABLE_OFFSET)
#define V5_L2C_CTL_IPFDPT_MASK      (3UL << V5_L2C_CTL_IPFDPT_OFFSET)
#define V5_L2C_CTL_DPFDPT_MASK      (3UL << V5_L2C_CTL_DPFDPT_OFFSET)
#define V5_L2C_CTL_TRAMOCTL_MASK    (3UL << V5_L2C_CTL_TRAMOCTL_OFFSET)
#define V5_L2C_CTL_TRAMICTL_MASK    (1UL << V5_L2C_CTL_TRAMICTL_OFFSET)
#define V5_L2C_CTL_DRAMOCTL_MASK    (3UL << V5_L2C_CTL_DRAMOCTL_OFFSET)
#define V5_L2C_CTL_DRAMICTL_MASK    (1UL << V5_L2C_CTL_DRAMICTL_OFFSET)

#endif /* _AE350_PLATFORM_H_ */
