/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-music-player-context.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UNITY_WEBAPPS_MUSIC_PLAYER_CONTEXT_H
#define __UNITY_WEBAPPS_MUSIC_PLAYER_CONTEXT_H

typedef struct _UnityWebappsMusicPlayerContext UnityWebappsMusicPlayerContext;

typedef enum {
	UNITY_WEBAPPS_MUSIC_PLAYER_PLAYBACK_STATE_PLAYING,
	UNITY_WEBAPPS_MUSIC_PLAYER_PLAYBACK_STATE_PAUSED
} UnityWebappsMusicPlayerPlaybackState;

#include "unity-webapps-context.h"

typedef void (*UnityWebappsMusicPlayerCallback) (UnityWebappsContext *context, gpointer user_data);
typedef void (*UnityWebappsMusicPlayerPlaylistCallback) (UnityWebappsContext *context, const gchar *playlist_name, gpointer user_data);

void unity_webapps_music_player_init (UnityWebappsContext *context,
									  const gchar *title);

void unity_webapps_music_player_set_track (UnityWebappsContext *context,
										   const gchar *artist,
										   const gchar *album,
										   const gchar *title,
										   const gchar *icon_url);

void unity_webapps_music_player_on_play_pause_callback (UnityWebappsContext *context, UnityWebappsMusicPlayerCallback callback, gpointer user_data);
void unity_webapps_music_player_on_previous_callback (UnityWebappsContext *context, UnityWebappsMusicPlayerCallback callback, gpointer user_data);
void unity_webapps_music_player_on_next_callback (UnityWebappsContext *context, UnityWebappsMusicPlayerCallback callback, gpointer user_data);

UnityWebappsMusicPlayerPlaybackState unity_webapps_music_player_get_playback_state (UnityWebappsContext *context);
gboolean unity_webapps_music_player_get_can_go_previous (UnityWebappsContext *context);
gboolean unity_webapps_music_player_get_can_go_next (UnityWebappsContext *context);
gboolean unity_webapps_music_player_get_can_play (UnityWebappsContext *context);
gboolean unity_webapps_music_player_get_can_pause (UnityWebappsContext *context);

void unity_webapps_music_player_set_playback_state (UnityWebappsContext *context, UnityWebappsMusicPlayerPlaybackState state);
void unity_webapps_music_player_set_can_go_previous (UnityWebappsContext *context, gboolean can_go_previous);
void unity_webapps_music_player_set_can_go_next (UnityWebappsContext *context, gboolean can_go_next);
void unity_webapps_music_player_set_can_play (UnityWebappsContext *context, gboolean can_go_play);
void unity_webapps_music_player_set_can_pause (UnityWebappsContext *context, gboolean can_go_pause);

void unity_webapps_music_player_set_playlists (UnityWebappsContext *context, const gchar *const *playlists);
void unity_webapps_music_player_on_playlist_activated_callback (UnityWebappsContext *context, UnityWebappsMusicPlayerPlaylistCallback callback, gpointer user_data);

#endif
