; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s


define i32 @test1(i32 %X, i8 %A) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[SHIFT_UPGRD_1:%.*]] = zext i8 %A to i32
; CHECK-NEXT:    [[Y1:%.*]] = lshr i32 %X, [[SHIFT_UPGRD_1]]
; CHECK-NEXT:    [[Z:%.*]] = and i32 [[Y1]], 1
; CHECK-NEXT:    ret i32 [[Z]]
;
  %shift.upgrd.1 = zext i8 %A to i32
  ; can be logical shift.
  %Y = ashr i32 %X, %shift.upgrd.1
  %Z = and i32 %Y, 1
  ret i32 %Z
}

define i32 @test2(i8 %tmp) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[TMP3:%.*]] = zext i8 %tmp to i32
; CHECK-NEXT:    [[TMP4:%.*]] = add nuw nsw i32 [[TMP3]], 7
; CHECK-NEXT:    [[TMP51:%.*]] = lshr i32 [[TMP4]], 3
; CHECK-NEXT:    ret i32 [[TMP51]]
;
  %tmp3 = zext i8 %tmp to i32
  %tmp4 = add i32 %tmp3, 7
  %tmp5 = ashr i32 %tmp4, 3
  ret i32 %tmp5
}

define i64 @test3(i1 %X, i64 %Y, i1 %Cond) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    br i1 %Cond, label %T, label %F
; CHECK:       T:
; CHECK-NEXT:    [[X2:%.*]] = sext i1 %X to i64
; CHECK-NEXT:    br label %C
; CHECK:       F:
; CHECK-NEXT:    [[Y2:%.*]] = ashr i64 %Y, 63
; CHECK-NEXT:    br label %C
; CHECK:       C:
; CHECK-NEXT:    [[P:%.*]] = phi i64 [ [[X2]], %T ], [ [[Y2]], %F ]
; CHECK-NEXT:    ret i64 [[P]]
;
  br i1 %Cond, label %T, label %F
T:
  %X2 = sext i1 %X to i64
  br label %C
F:
  %Y2 = ashr i64 %Y, 63
  br label %C
C:
  %P = phi i64 [%X2, %T], [%Y2, %F]
  %S = ashr i64 %P, 12
  ret i64 %S
}

define i64 @test4(i1 %X, i64 %Y, i1 %Cond) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    br i1 %Cond, label %T, label %F
; CHECK:       T:
; CHECK-NEXT:    [[X2:%.*]] = sext i1 %X to i64
; CHECK-NEXT:    br label %C
; CHECK:       F:
; CHECK-NEXT:    [[Y2:%.*]] = ashr i64 %Y, 63
; CHECK-NEXT:    br label %C
; CHECK:       C:
; CHECK-NEXT:    [[P:%.*]] = phi i64 [ [[X2]], %T ], [ [[Y2]], %F ]
; CHECK-NEXT:    ret i64 [[P]]
;
  br i1 %Cond, label %T, label %F
T:
  %X2 = sext i1 %X to i64
  br label %C
F:
  %Y2 = ashr i64 %Y, 63
  br label %C
C:
  %P = phi i64 [%X2, %T], [%Y2, %F]
  %R = shl i64 %P, 12
  %S = ashr i64 %R, 12
  ret i64 %S
}

; rdar://7732987
define i32 @test5(i32 %Y) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    br i1 undef, label %A, label %C
; CHECK:       A:
; CHECK-NEXT:    br i1 undef, label %B, label %D
; CHECK:       B:
; CHECK-NEXT:    br label %D
; CHECK:       C:
; CHECK-NEXT:    br i1 undef, label %D, label %E
; CHECK:       D:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 0, %A ], [ 0, %B ], [ %Y, %C ]
; CHECK-NEXT:    [[S:%.*]] = ashr i32 [[P]], 16
; CHECK-NEXT:    ret i32 [[S]]
; CHECK:       E:
; CHECK-NEXT:    ret i32 0
;
  br i1 undef, label %A, label %C
A:
  br i1 undef, label %B, label %D
B:
  br label %D
C:
  br i1 undef, label %D, label %E
D:
  %P = phi i32 [0, %A], [0, %B], [%Y, %C]
  %S = ashr i32 %P, 16
  ret i32 %S
E:
  ret i32 0
}

; (X >>s C1) >>s C2 --> X >>s (C1 + C2)

define i32 @ashr_ashr(i32 %x) {
; CHECK-LABEL: @ashr_ashr(
; CHECK-NEXT:    [[SH2:%.*]] = ashr i32 %x, 12
; CHECK-NEXT:    ret i32 [[SH2]]
;
  %sh1 = ashr i32 %x, 5
  %sh2 = ashr i32 %sh1, 7
  ret i32 %sh2
}

; PR3851
; (X >>s C1) >>s C2 --> X >>s (Bitwidth - 1)

define i32 @ashr_overshift(i32 %x) {
; CHECK-LABEL: @ashr_overshift(
; CHECK-NEXT:    [[SH2:%.*]] = ashr i32 %x, 31
; CHECK-NEXT:    ret i32 [[SH2]]
;
  %sh1 = ashr i32 %x, 15
  %sh2 = ashr i32 %sh1, 17
  ret i32 %sh2
}

; (X >>s C1) >>s C2 --> X >>s (C1 + C2)

define <2 x i32> @ashr_ashr_splat_vec(<2 x i32> %x) {
; CHECK-LABEL: @ashr_ashr_splat_vec(
; CHECK-NEXT:    [[SH2:%.*]] = ashr <2 x i32> %x, <i32 12, i32 12>
; CHECK-NEXT:    ret <2 x i32> [[SH2]]
;
  %sh1 = ashr <2 x i32> %x, <i32 5, i32 5>
  %sh2 = ashr <2 x i32> %sh1, <i32 7, i32 7>
  ret <2 x i32> %sh2
}

; (X >>s C1) >>s C2 --> X >>s (Bitwidth - 1)

define <2 x i32> @ashr_overshift_splat_vec(<2 x i32> %x) {
; CHECK-LABEL: @ashr_overshift_splat_vec(
; CHECK-NEXT:    [[SH2:%.*]] = ashr <2 x i32> %x, <i32 31, i32 31>
; CHECK-NEXT:    ret <2 x i32> [[SH2]]
;
  %sh1 = ashr <2 x i32> %x, <i32 15, i32 15>
  %sh2 = ashr <2 x i32> %sh1, <i32 17, i32 17>
  ret <2 x i32> %sh2
}

