; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefix=SSE --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefix=SSE --check-prefix=SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=AVX --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=AVX --check-prefix=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefix=AVX512 --check-prefix=AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw | FileCheck %s --check-prefix=AVX512 --check-prefix=AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefix=AVX512 --check-prefix=AVX512VL

define <4 x float> @test_v4f32(<4 x float>* %src) {
; SSE2-LABEL: test_v4f32:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v4f32:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v4f32:
; AVX:       # BB#0:
; AVX-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_v4f32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX512-NEXT:    retq
  %1 = load <4 x float>, <4 x float>* %src, align 16, !nontemporal !1
  ret <4 x float> %1
}

define <4 x i32> @test_v4i32(<4 x i32>* %src) {
; SSE2-LABEL: test_v4i32:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v4i32:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v4i32:
; AVX:       # BB#0:
; AVX-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_v4i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX512-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %src, align 16, !nontemporal !1
  ret <4 x i32> %1
}

define <2 x double> @test_v2f64(<2 x double>* %src) {
; SSE2-LABEL: test_v2f64:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v2f64:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v2f64:
; AVX:       # BB#0:
; AVX-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_v2f64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX512-NEXT:    retq
  %1 = load <2 x double>, <2 x double>* %src, align 16, !nontemporal !1
  ret <2 x double> %1
}

define <2 x i64> @test_v2i64(<2 x i64>* %src) {
; SSE2-LABEL: test_v2i64:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v2i64:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v2i64:
; AVX:       # BB#0:
; AVX-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_v2i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX512-NEXT:    retq
  %1 = load <2 x i64>, <2 x i64>* %src, align 16, !nontemporal !1
  ret <2 x i64> %1
}

define <8 x i16> @test_v8i16(<8 x i16>* %src) {
; SSE2-LABEL: test_v8i16:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8i16:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v8i16:
; AVX:       # BB#0:
; AVX-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_v8i16:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX512-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %src, align 16, !nontemporal !1
  ret <8 x i16> %1
}

define <16 x i8> @test_v16i8(<16 x i8>* %src) {
; SSE2-LABEL: test_v16i8:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16i8:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: test_v16i8:
; AVX:       # BB#0:
; AVX-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_v16i8:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %xmm0
; AVX512-NEXT:    retq
  %1 = load <16 x i8>, <16 x i8>* %src, align 16, !nontemporal !1
  ret <16 x i8> %1
}

; And now YMM versions.

define <8 x float> @test_v8f32(<8 x float>* %src) {
; SSE2-LABEL: test_v8f32:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8f32:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v8f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v8f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v8f32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512-NEXT:    retq
  %1 = load <8 x float>, <8 x float>* %src, align 32, !nontemporal !1
  ret <8 x float> %1
}

define <8 x i32> @test_v8i32(<8 x i32>* %src) {
; SSE2-LABEL: test_v8i32:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8i32:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v8i32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v8i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test_v8i32:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: test_v8i32:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: test_v8i32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovaps (%rdi), %ymm0
; AVX512VL-NEXT:    retq
  %1 = load <8 x i32>, <8 x i32>* %src, align 32, !nontemporal !1
  ret <8 x i32> %1
}

define <4 x double> @test_v4f64(<4 x double>* %src) {
; SSE2-LABEL: test_v4f64:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v4f64:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v4f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v4f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v4f64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512-NEXT:    retq
  %1 = load <4 x double>, <4 x double>* %src, align 32, !nontemporal !1
  ret <4 x double> %1
}

define <4 x i64> @test_v4i64(<4 x i64>* %src) {
; SSE2-LABEL: test_v4i64:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v4i64:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v4i64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v4i64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v4i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512-NEXT:    retq
  %1 = load <4 x i64>, <4 x i64>* %src, align 32, !nontemporal !1
  ret <4 x i64> %1
}

define <16 x i16> @test_v16i16(<16 x i16>* %src) {
; SSE2-LABEL: test_v16i16:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16i16:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v16i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v16i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v16i16:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512-NEXT:    retq
  %1 = load <16 x i16>, <16 x i16>* %src, align 32, !nontemporal !1
  ret <16 x i16> %1
}

define <32 x i8> @test_v32i8(<32 x i8>* %src) {
; SSE2-LABEL: test_v32i8:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v32i8:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v32i8:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v32i8:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v32i8:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512-NEXT:    retq
  %1 = load <32 x i8>, <32 x i8>* %src, align 32, !nontemporal !1
  ret <32 x i8> %1
}

; And now ZMM versions.

define <16 x float> @test_v16f32(<16 x float>* %src) {
; SSE2-LABEL: test_v16f32:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16f32:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v16f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v16f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v16f32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <16 x float>, <16 x float>* %src, align 64, !nontemporal !1
  ret <16 x float> %1
}

define <16 x i32> @test_v16i32(<16 x i32>* %src) {
; SSE2-LABEL: test_v16i32:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v16i32:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v16i32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v16i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v16i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <16 x i32>, <16 x i32>* %src, align 64, !nontemporal !1
  ret <16 x i32> %1
}

define <8 x double> @test_v8f64(<8 x double>* %src) {
; SSE2-LABEL: test_v8f64:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8f64:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v8f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v8f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v8f64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <8 x double>, <8 x double>* %src, align 64, !nontemporal !1
  ret <8 x double> %1
}

define <8 x i64> @test_v8i64(<8 x i64>* %src) {
; SSE2-LABEL: test_v8i64:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v8i64:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v8i64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v8i64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_v8i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovntdqa (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <8 x i64>, <8 x i64>* %src, align 64, !nontemporal !1
  ret <8 x i64> %1
}

define <32 x i16> @test_v32i16(<32 x i16>* %src) {
; SSE2-LABEL: test_v32i16:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v32i16:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v32i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v32i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test_v32i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: test_v32i16:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vmovntdqa (%rdi), %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: test_v32i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512VL-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX512VL-NEXT:    retq
  %1 = load <32 x i16>, <32 x i16>* %src, align 64, !nontemporal !1
  ret <32 x i16> %1
}

define <64 x i8> @test_v64i8(<64 x i8>* %src) {
; SSE2-LABEL: test_v64i8:
; SSE2:       # BB#0:
; SSE2-NEXT:    movaps (%rdi), %xmm0
; SSE2-NEXT:    movaps 16(%rdi), %xmm1
; SSE2-NEXT:    movaps 32(%rdi), %xmm2
; SSE2-NEXT:    movaps 48(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_v64i8:
; SSE41:       # BB#0:
; SSE41-NEXT:    movntdqa (%rdi), %xmm0
; SSE41-NEXT:    movntdqa 16(%rdi), %xmm1
; SSE41-NEXT:    movntdqa 32(%rdi), %xmm2
; SSE41-NEXT:    movntdqa 48(%rdi), %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_v64i8:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm0
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_v64i8:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test_v64i8:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: test_v64i8:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vmovntdqa (%rdi), %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: test_v64i8:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovntdqa (%rdi), %ymm0
; AVX512VL-NEXT:    vmovntdqa 32(%rdi), %ymm1
; AVX512VL-NEXT:    retq
  %1 = load <64 x i8>, <64 x i8>* %src, align 64, !nontemporal !1
  ret <64 x i8> %1
}


; Check cases where the load would be folded.

define <4 x float> @test_arg_v4f32(<4 x float> %arg, <4 x float>* %src) {
; SSE-LABEL: test_arg_v4f32:
; SSE:       # BB#0:
; SSE-NEXT:    addps (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_arg_v4f32:
; AVX:       # BB#0:
; AVX-NEXT:    vaddps (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_arg_v4f32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vaddps (%rdi), %xmm0, %xmm0
; AVX512-NEXT:    retq
  %1 = load <4 x float>, <4 x float>* %src, align 16, !nontemporal !1
  %2 = fadd <4 x float> %arg, %1
  ret <4 x float> %2
}

define <4 x i32> @test_arg_v4i32(<4 x i32> %arg, <4 x i32>* %src) {
; SSE-LABEL: test_arg_v4i32:
; SSE:       # BB#0:
; SSE-NEXT:    paddd (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_arg_v4i32:
; AVX:       # BB#0:
; AVX-NEXT:    vpaddd (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_arg_v4i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpaddd (%rdi), %xmm0, %xmm0
; AVX512-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %src, align 16, !nontemporal !1
  %2 = add <4 x i32> %arg, %1
  ret <4 x i32> %2
}

define <2 x double> @test_arg_v2f64(<2 x double> %arg, <2 x double>* %src) {
; SSE-LABEL: test_arg_v2f64:
; SSE:       # BB#0:
; SSE-NEXT:    addpd (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_arg_v2f64:
; AVX:       # BB#0:
; AVX-NEXT:    vaddpd (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_arg_v2f64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vaddpd (%rdi), %xmm0, %xmm0
; AVX512-NEXT:    retq
  %1 = load <2 x double>, <2 x double>* %src, align 16, !nontemporal !1
  %2 = fadd <2 x double> %arg, %1
  ret <2 x double> %2
}

define <2 x i64> @test_arg_v2i64(<2 x i64> %arg, <2 x i64>* %src) {
; SSE-LABEL: test_arg_v2i64:
; SSE:       # BB#0:
; SSE-NEXT:    paddq (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_arg_v2i64:
; AVX:       # BB#0:
; AVX-NEXT:    vpaddq (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_arg_v2i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpaddq (%rdi), %xmm0, %xmm0
; AVX512-NEXT:    retq
  %1 = load <2 x i64>, <2 x i64>* %src, align 16, !nontemporal !1
  %2 = add <2 x i64> %arg, %1
  ret <2 x i64> %2
}

define <8 x i16> @test_arg_v8i16(<8 x i16> %arg, <8 x i16>* %src) {
; SSE-LABEL: test_arg_v8i16:
; SSE:       # BB#0:
; SSE-NEXT:    paddw (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_arg_v8i16:
; AVX:       # BB#0:
; AVX-NEXT:    vpaddw (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_arg_v8i16:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpaddw (%rdi), %xmm0, %xmm0
; AVX512-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %src, align 16, !nontemporal !1
  %2 = add <8 x i16> %arg, %1
  ret <8 x i16> %2
}

define <16 x i8> @test_arg_v16i8(<16 x i8> %arg, <16 x i8>* %src) {
; SSE-LABEL: test_arg_v16i8:
; SSE:       # BB#0:
; SSE-NEXT:    paddb (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_arg_v16i8:
; AVX:       # BB#0:
; AVX-NEXT:    vpaddb (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_arg_v16i8:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpaddb (%rdi), %xmm0, %xmm0
; AVX512-NEXT:    retq
  %1 = load <16 x i8>, <16 x i8>* %src, align 16, !nontemporal !1
  %2 = add <16 x i8> %arg, %1
  ret <16 x i8> %2
}

; And now YMM versions.

define <8 x float> @test_arg_v8f32(<8 x float> %arg, <8 x float>* %src) {
; SSE-LABEL: test_arg_v8f32:
; SSE:       # BB#0:
; SSE-NEXT:    addps (%rdi), %xmm0
; SSE-NEXT:    addps 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_arg_v8f32:
; AVX:       # BB#0:
; AVX-NEXT:    vaddps (%rdi), %ymm0, %ymm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_arg_v8f32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vaddps (%rdi), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = load <8 x float>, <8 x float>* %src, align 32, !nontemporal !1
  %2 = fadd <8 x float> %arg, %1
  ret <8 x float> %2
}

define <8 x i32> @test_arg_v8i32(<8 x i32> %arg, <8 x i32>* %src) {
; SSE-LABEL: test_arg_v8i32:
; SSE:       # BB#0:
; SSE-NEXT:    paddd (%rdi), %xmm0
; SSE-NEXT:    paddd 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_arg_v8i32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_arg_v8i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpaddd (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_arg_v8i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpaddd (%rdi), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = load <8 x i32>, <8 x i32>* %src, align 32, !nontemporal !1
  %2 = add <8 x i32> %arg, %1
  ret <8 x i32> %2
}

define <4 x double> @test_arg_v4f64(<4 x double> %arg, <4 x double>* %src) {
; SSE-LABEL: test_arg_v4f64:
; SSE:       # BB#0:
; SSE-NEXT:    addpd (%rdi), %xmm0
; SSE-NEXT:    addpd 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_arg_v4f64:
; AVX:       # BB#0:
; AVX-NEXT:    vaddpd (%rdi), %ymm0, %ymm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_arg_v4f64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vaddpd (%rdi), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = load <4 x double>, <4 x double>* %src, align 32, !nontemporal !1
  %2 = fadd <4 x double> %arg, %1
  ret <4 x double> %2
}

define <4 x i64> @test_arg_v4i64(<4 x i64> %arg, <4 x i64>* %src) {
; SSE-LABEL: test_arg_v4i64:
; SSE:       # BB#0:
; SSE-NEXT:    paddq (%rdi), %xmm0
; SSE-NEXT:    paddq 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_arg_v4i64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_arg_v4i64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpaddq (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_arg_v4i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpaddq (%rdi), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = load <4 x i64>, <4 x i64>* %src, align 32, !nontemporal !1
  %2 = add <4 x i64> %arg, %1
  ret <4 x i64> %2
}

define <16 x i16> @test_arg_v16i16(<16 x i16> %arg, <16 x i16>* %src) {
; SSE-LABEL: test_arg_v16i16:
; SSE:       # BB#0:
; SSE-NEXT:    paddw (%rdi), %xmm0
; SSE-NEXT:    paddw 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_arg_v16i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_arg_v16i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpaddw (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_arg_v16i16:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpaddw (%rdi), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = load <16 x i16>, <16 x i16>* %src, align 32, !nontemporal !1
  %2 = add <16 x i16> %arg, %1
  ret <16 x i16> %2
}

define <32 x i8> @test_arg_v32i8(<32 x i8> %arg, <32 x i8>* %src) {
; SSE-LABEL: test_arg_v32i8:
; SSE:       # BB#0:
; SSE-NEXT:    paddb (%rdi), %xmm0
; SSE-NEXT:    paddb 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_arg_v32i8:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_arg_v32i8:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpaddb (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_arg_v32i8:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpaddb (%rdi), %ymm0, %ymm0
; AVX512-NEXT:    retq
  %1 = load <32 x i8>, <32 x i8>* %src, align 32, !nontemporal !1
  %2 = add <32 x i8> %arg, %1
  ret <32 x i8> %2
}

; And now ZMM versions.

define <16 x float> @test_arg_v16f32(<16 x float> %arg, <16 x float>* %src) {
; SSE-LABEL: test_arg_v16f32:
; SSE:       # BB#0:
; SSE-NEXT:    addps (%rdi), %xmm0
; SSE-NEXT:    addps 16(%rdi), %xmm1
; SSE-NEXT:    addps 32(%rdi), %xmm2
; SSE-NEXT:    addps 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX-LABEL: test_arg_v16f32:
; AVX:       # BB#0:
; AVX-NEXT:    vaddps (%rdi), %ymm0, %ymm0
; AVX-NEXT:    vaddps 32(%rdi), %ymm1, %ymm1
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_arg_v16f32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vaddps (%rdi), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %1 = load <16 x float>, <16 x float>* %src, align 64, !nontemporal !1
  %2 = fadd <16 x float> %arg, %1
  ret <16 x float> %2
}

define <16 x i32> @test_arg_v16i32(<16 x i32> %arg, <16 x i32>* %src) {
; SSE-LABEL: test_arg_v16i32:
; SSE:       # BB#0:
; SSE-NEXT:    paddd (%rdi), %xmm0
; SSE-NEXT:    paddd 16(%rdi), %xmm1
; SSE-NEXT:    paddd 32(%rdi), %xmm2
; SSE-NEXT:    paddd 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_arg_v16i32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm2
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpaddd %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpaddd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vpaddd %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_arg_v16i32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpaddd (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpaddd 32(%rdi), %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_arg_v16i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpaddd (%rdi), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %1 = load <16 x i32>, <16 x i32>* %src, align 64, !nontemporal !1
  %2 = add <16 x i32> %arg, %1
  ret <16 x i32> %2
}

define <8 x double> @test_arg_v8f64(<8 x double> %arg, <8 x double>* %src) {
; SSE-LABEL: test_arg_v8f64:
; SSE:       # BB#0:
; SSE-NEXT:    addpd (%rdi), %xmm0
; SSE-NEXT:    addpd 16(%rdi), %xmm1
; SSE-NEXT:    addpd 32(%rdi), %xmm2
; SSE-NEXT:    addpd 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX-LABEL: test_arg_v8f64:
; AVX:       # BB#0:
; AVX-NEXT:    vaddpd (%rdi), %ymm0, %ymm0
; AVX-NEXT:    vaddpd 32(%rdi), %ymm1, %ymm1
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_arg_v8f64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vaddpd (%rdi), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %1 = load <8 x double>, <8 x double>* %src, align 64, !nontemporal !1
  %2 = fadd <8 x double> %arg, %1
  ret <8 x double> %2
}

define <8 x i64> @test_arg_v8i64(<8 x i64> %arg, <8 x i64>* %src) {
; SSE-LABEL: test_arg_v8i64:
; SSE:       # BB#0:
; SSE-NEXT:    paddq (%rdi), %xmm0
; SSE-NEXT:    paddq 16(%rdi), %xmm1
; SSE-NEXT:    paddq 32(%rdi), %xmm2
; SSE-NEXT:    paddq 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_arg_v8i64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm2
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpaddq %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vpaddq %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpaddq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_arg_v8i64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpaddq (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpaddq 32(%rdi), %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_arg_v8i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vpaddq (%rdi), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %1 = load <8 x i64>, <8 x i64>* %src, align 64, !nontemporal !1
  %2 = add <8 x i64> %arg, %1
  ret <8 x i64> %2
}

define <32 x i16> @test_arg_v32i16(<32 x i16> %arg, <32 x i16>* %src) {
; SSE-LABEL: test_arg_v32i16:
; SSE:       # BB#0:
; SSE-NEXT:    paddw (%rdi), %xmm0
; SSE-NEXT:    paddw 16(%rdi), %xmm1
; SSE-NEXT:    paddw 32(%rdi), %xmm2
; SSE-NEXT:    paddw 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_arg_v32i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm2
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpaddw %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpaddw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vpaddw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_arg_v32i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpaddw (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpaddw 32(%rdi), %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test_arg_v32i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vpaddw (%rdi), %ymm0, %ymm0
; AVX512F-NEXT:    vpaddw 32(%rdi), %ymm1, %ymm1
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: test_arg_v32i16:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vpaddw (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: test_arg_v32i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpaddw (%rdi), %ymm0, %ymm0
; AVX512VL-NEXT:    vpaddw 32(%rdi), %ymm1, %ymm1
; AVX512VL-NEXT:    retq
  %1 = load <32 x i16>, <32 x i16>* %src, align 64, !nontemporal !1
  %2 = add <32 x i16> %arg, %1
  ret <32 x i16> %2
}

define <64 x i8> @test_arg_v64i8(<64 x i8> %arg, <64 x i8>* %src) {
; SSE-LABEL: test_arg_v64i8:
; SSE:       # BB#0:
; SSE-NEXT:    paddb (%rdi), %xmm0
; SSE-NEXT:    paddb 16(%rdi), %xmm1
; SSE-NEXT:    paddb 32(%rdi), %xmm2
; SSE-NEXT:    paddb 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_arg_v64i8:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovaps (%rdi), %ymm2
; AVX1-NEXT:    vmovaps 32(%rdi), %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpaddb %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vpaddb %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_arg_v64i8:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpaddb (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vpaddb 32(%rdi), %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: test_arg_v64i8:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vpaddb (%rdi), %ymm0, %ymm0
; AVX512F-NEXT:    vpaddb 32(%rdi), %ymm1, %ymm1
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: test_arg_v64i8:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vpaddb (%rdi), %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: test_arg_v64i8:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpaddb (%rdi), %ymm0, %ymm0
; AVX512VL-NEXT:    vpaddb 32(%rdi), %ymm1, %ymm1
; AVX512VL-NEXT:    retq
  %1 = load <64 x i8>, <64 x i8>* %src, align 64, !nontemporal !1
  %2 = add <64 x i8> %arg, %1
  ret <64 x i8> %2
}


; Unaligned non-temporal loads (not supported)

define <4 x float> @test_unaligned_v4f32(<4 x float>* %src) {
; SSE-LABEL: test_unaligned_v4f32:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v4f32:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v4f32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %xmm0
; AVX512-NEXT:    retq
  %1 = load <4 x float>, <4 x float>* %src, align 1, !nontemporal !1
  ret <4 x float> %1
}

define <4 x i32> @test_unaligned_v4i32(<4 x i32>* %src) {
; SSE-LABEL: test_unaligned_v4i32:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v4i32:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v4i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %xmm0
; AVX512-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %src, align 1, !nontemporal !1
  ret <4 x i32> %1
}

define <2 x double> @test_unaligned_v2f64(<2 x double>* %src) {
; SSE-LABEL: test_unaligned_v2f64:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v2f64:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v2f64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %xmm0
; AVX512-NEXT:    retq
  %1 = load <2 x double>, <2 x double>* %src, align 1, !nontemporal !1
  ret <2 x double> %1
}

define <2 x i64> @test_unaligned_v2i64(<2 x i64>* %src) {
; SSE-LABEL: test_unaligned_v2i64:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v2i64:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v2i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %xmm0
; AVX512-NEXT:    retq
  %1 = load <2 x i64>, <2 x i64>* %src, align 1, !nontemporal !1
  ret <2 x i64> %1
}

define <8 x i16> @test_unaligned_v8i16(<8 x i16>* %src) {
; SSE-LABEL: test_unaligned_v8i16:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v8i16:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v8i16:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %xmm0
; AVX512-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %src, align 1, !nontemporal !1
  ret <8 x i16> %1
}

define <16 x i8> @test_unaligned_v16i8(<16 x i8>* %src) {
; SSE-LABEL: test_unaligned_v16i8:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v16i8:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v16i8:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %xmm0
; AVX512-NEXT:    retq
  %1 = load <16 x i8>, <16 x i8>* %src, align 1, !nontemporal !1
  ret <16 x i8> %1
}

; And now YMM versions.

define <8 x float> @test_unaligned_v8f32(<8 x float>* %src) {
; SSE-LABEL: test_unaligned_v8f32:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v8f32:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v8f32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %ymm0
; AVX512-NEXT:    retq
  %1 = load <8 x float>, <8 x float>* %src, align 1, !nontemporal !1
  ret <8 x float> %1
}

define <8 x i32> @test_unaligned_v8i32(<8 x i32>* %src) {
; SSE-LABEL: test_unaligned_v8i32:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v8i32:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v8i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %ymm0
; AVX512-NEXT:    retq
  %1 = load <8 x i32>, <8 x i32>* %src, align 1, !nontemporal !1
  ret <8 x i32> %1
}

define <4 x double> @test_unaligned_v4f64(<4 x double>* %src) {
; SSE-LABEL: test_unaligned_v4f64:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v4f64:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v4f64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %ymm0
; AVX512-NEXT:    retq
  %1 = load <4 x double>, <4 x double>* %src, align 1, !nontemporal !1
  ret <4 x double> %1
}

define <4 x i64> @test_unaligned_v4i64(<4 x i64>* %src) {
; SSE-LABEL: test_unaligned_v4i64:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v4i64:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v4i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %ymm0
; AVX512-NEXT:    retq
  %1 = load <4 x i64>, <4 x i64>* %src, align 1, !nontemporal !1
  ret <4 x i64> %1
}

define <16 x i16> @test_unaligned_v16i16(<16 x i16>* %src) {
; SSE-LABEL: test_unaligned_v16i16:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v16i16:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v16i16:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %ymm0
; AVX512-NEXT:    retq
  %1 = load <16 x i16>, <16 x i16>* %src, align 1, !nontemporal !1
  ret <16 x i16> %1
}

define <32 x i8> @test_unaligned_v32i8(<32 x i8>* %src) {
; SSE-LABEL: test_unaligned_v32i8:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v32i8:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v32i8:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %ymm0
; AVX512-NEXT:    retq
  %1 = load <32 x i8>, <32 x i8>* %src, align 1, !nontemporal !1
  ret <32 x i8> %1
}

; And now ZMM versions.

define <16 x float> @test_unaligned_v16f32(<16 x float>* %src) {
; SSE-LABEL: test_unaligned_v16f32:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    movups 32(%rdi), %xmm2
; SSE-NEXT:    movups 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v16f32:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    vmovups 32(%rdi), %ymm1
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v16f32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <16 x float>, <16 x float>* %src, align 1, !nontemporal !1
  ret <16 x float> %1
}

define <16 x i32> @test_unaligned_v16i32(<16 x i32>* %src) {
; SSE-LABEL: test_unaligned_v16i32:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    movups 32(%rdi), %xmm2
; SSE-NEXT:    movups 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v16i32:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    vmovups 32(%rdi), %ymm1
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v16i32:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <16 x i32>, <16 x i32>* %src, align 1, !nontemporal !1
  ret <16 x i32> %1
}

define <8 x double> @test_unaligned_v8f64(<8 x double>* %src) {
; SSE-LABEL: test_unaligned_v8f64:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    movups 32(%rdi), %xmm2
; SSE-NEXT:    movups 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v8f64:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    vmovups 32(%rdi), %ymm1
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v8f64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <8 x double>, <8 x double>* %src, align 1, !nontemporal !1
  ret <8 x double> %1
}

define <8 x i64> @test_unaligned_v8i64(<8 x i64>* %src) {
; SSE-LABEL: test_unaligned_v8i64:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    movups 32(%rdi), %xmm2
; SSE-NEXT:    movups 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v8i64:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    vmovups 32(%rdi), %ymm1
; AVX-NEXT:    retq
;
; AVX512-LABEL: test_unaligned_v8i64:
; AVX512:       # BB#0:
; AVX512-NEXT:    vmovups (%rdi), %zmm0
; AVX512-NEXT:    retq
  %1 = load <8 x i64>, <8 x i64>* %src, align 1, !nontemporal !1
  ret <8 x i64> %1
}

define <32 x i16> @test_unaligned_v32i16(<32 x i16>* %src) {
; SSE-LABEL: test_unaligned_v32i16:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    movups 32(%rdi), %xmm2
; SSE-NEXT:    movups 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v32i16:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    vmovups 32(%rdi), %ymm1
; AVX-NEXT:    retq
;
; AVX512F-LABEL: test_unaligned_v32i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovups (%rdi), %ymm0
; AVX512F-NEXT:    vmovups 32(%rdi), %ymm1
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: test_unaligned_v32i16:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vmovdqu16 (%rdi), %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: test_unaligned_v32i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovups (%rdi), %ymm0
; AVX512VL-NEXT:    vmovups 32(%rdi), %ymm1
; AVX512VL-NEXT:    retq
  %1 = load <32 x i16>, <32 x i16>* %src, align 1, !nontemporal !1
  ret <32 x i16> %1
}

define <64 x i8> @test_unaligned_v64i8(<64 x i8>* %src) {
; SSE-LABEL: test_unaligned_v64i8:
; SSE:       # BB#0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movups 16(%rdi), %xmm1
; SSE-NEXT:    movups 32(%rdi), %xmm2
; SSE-NEXT:    movups 48(%rdi), %xmm3
; SSE-NEXT:    retq
;
; AVX-LABEL: test_unaligned_v64i8:
; AVX:       # BB#0:
; AVX-NEXT:    vmovups (%rdi), %ymm0
; AVX-NEXT:    vmovups 32(%rdi), %ymm1
; AVX-NEXT:    retq
;
; AVX512F-LABEL: test_unaligned_v64i8:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovups (%rdi), %ymm0
; AVX512F-NEXT:    vmovups 32(%rdi), %ymm1
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: test_unaligned_v64i8:
; AVX512BW:       # BB#0:
; AVX512BW-NEXT:    vmovdqu8 (%rdi), %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: test_unaligned_v64i8:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovups (%rdi), %ymm0
; AVX512VL-NEXT:    vmovups 32(%rdi), %ymm1
; AVX512VL-NEXT:    retq
  %1 = load <64 x i8>, <64 x i8>* %src, align 1, !nontemporal !1
  ret <64 x i8> %1
}

!1 = !{i32 1}
