/* { dg-do run { target { riscv_v } } } */
/* { dg-options "-O2" } */

#include<cmath>
#include<cstddef>
#include<cstdint>
#include<iomanip>
#include<ios>
#include<iostream>
#include<memory>
#include<type_traits>
#include"riscv_vector.h"

using std::addressof;
using std::cerr;
using std::endl;
using std::int8_t;
using std::int16_t;
using std::int32_t;
using std::int64_t;
using std::uint8_t;
using std::uint16_t;
using std::uint32_t;
using std::uint64_t;
using std::ptrdiff_t;
using std::size_t;
using float16_t = _Float16;
using float32_t = float;
using float64_t = double;

template<class T, class T2>
constexpr T uint_to_float(T2 val) noexcept
{
  return *reinterpret_cast<T*>(&val);
}

constexpr const auto &f16(uint_to_float<float16_t, uint16_t>);
constexpr const auto &f32(uint_to_float<float32_t, uint32_t>);
constexpr const auto &f64(uint_to_float<float64_t, uint64_t>);

template<class T>
struct To_uint
{
  using type = std::conditional_t<
    sizeof(T) == 1, uint8_t, std::conditional_t<
      sizeof(T) == 2, uint16_t, std::conditional_t<
        sizeof(T) == 4, uint32_t, std::conditional_t<
          sizeof(T) == 8, uint64_t, void
        >
      >
    >
  >;
};

// isnan() does not support half type
template<class T>
struct To_float
{
  using type = std::conditional_t<
    std::is_same<T, float16_t>::value, float, std::conditional_t<
      std::is_same<T, float32_t>::value, float, std::conditional_t<
        std::is_same<T, float64_t>::value, double, float
      >
    >
  >;
};

template<class T>
using To_uint_t = typename To_uint<T>::type;

template<class T>
using To_isnan_float = typename To_float<T>::type;

template <class T>
void print_float(std::ostream &os, T val)
{
  using std::setw;
  os << std::hex << std::setfill('0') << setw(sizeof(T) * 2) << *reinterpret_cast<To_uint_t<T>*>(addressof(val)) << setw(0) << std::dec;
}

template <class T>
bool __attribute__((noinline))
check(const T *a, const T *b, size_t size)
{
  bool rv = true;
  for (size_t i = 0; i < (size / sizeof(T)); ++i) {
    if (reinterpret_cast<const To_uint_t<T> *>(a)[i] ==
        reinterpret_cast<const To_uint_t<T> *>(b)[i])
      continue;
    // floating negative zero == positive zero
    if ((std::is_floating_point_v<T> || std::is_same<T, float16_t>::value) &&
        (a[i] == b[i]))
      continue;
    // if both result are NaN, return true
    if ((std::is_same<T, float16_t>::value || std::is_floating_point_v<T>) &&
         std::isnan(static_cast<To_isnan_float<T>>(a[i])) &&
         std::isnan(static_cast<To_isnan_float<T>>(b[i])))
      continue;

    if (std::is_same<T, float16_t>::value) {
      cerr << std::hex << std::setfill('0') << std::setw(sizeof(T) * 2) << "["
           << i
           << "] result/golden:" << reinterpret_cast<const To_uint_t<T> *>(a)[i]
           << " != " << reinterpret_cast<const To_uint_t<T> *>(b)[i]
           << std::setw(0) << std::dec << endl;
    } else if constexpr (std::is_floating_point_v<T>) {
      cerr << "[" << i << "] result/golden:" << a[i] << "(";
      print_float(cerr, a[i]);
      cerr << ") != " << b[i] << "(";
      print_float(cerr, b[i]);
      cerr << ")" << endl;
    } else if constexpr (std::is_unsigned_v<T>) {
      cerr << "[" << i << "] result/golden: " << static_cast<uintmax_t>(a[i])
           << " != " << static_cast<uintmax_t>(b[i]) << endl;
    } else {
      cerr << "[" << i << "] result/golden:" << static_cast<intmax_t>(a[i])
           << " != " << static_cast<intmax_t>(b[i]) << endl;
    }
    rv = false;
  }
  return rv;
}

template <class T>
bool __attribute__((noinline))
check(const T a, const T golden)
{
  return check(addressof(a), addressof(golden), sizeof(T));
}



int main()
{
int return_value = 0;

size_t var_135 = 86u;
uint16_t var_134 [] = {101u, 65480u, 65455u, 82u, 3u, 65517u, 40u, 12u, 35u, 18500u, 23u, 18620u, 52u, 65474u, 65525u, 8732u, 65533u, 186u, 67u, 65394u, 24u, 106u, 65534u, 65404u, 57u, 10u, 65501u, 65418u, 65443u, 52416u, 5u, 32376u, 65512u, 81u, 10325u, 38u, 142u, 150u, 194u, 65451u, 75u, 65506u, 65357u};
size_t var_132 = 78u;
uint16_t var_131 [] = {30791u, 32459u, 39289u, 50133u, 53913u, 48374u, 15719u, 9547u, 28529u, 15519u, 26813u, 22990u, 62351u, 47984u, 32959u, 25324u, 32137u, 16732u, 63291u, 54919u, 40630u, 3912u, 64270u, 16071u, 36589u, 3729u, 38470u, 25306u, 58574u, 39571u, 47284u, 3995u, 52442u, 17945u, 38770u, 12707u, 15396u, 39496u, 45828u};
size_t var_129 = 46u;
uint16_t var_128 [] = {10847u, 47586u, 21367u, 56430u, 60552u, 49838u, 906u, 20140u, 15972u, 2432u, 48332u, 7048u, 63008u, 40299u, 20052u, 13973u, 42746u, 45489u, 29260u, 11899u, 11897u, 53839u, 61489u};
size_t var_126 = 256u;
int16_t var_125 [] = {-29374, -15481, 28920, -16452, -15542, 4422, -19325, -160, -21628, -15526, -5851, 17291, -9264, 10571, -9725, 21681, 7770, -27896, 8998, 8565, -9045, -13965, -4977, 179, -20071, -27134, 12350, 11152, 5002, 19533, 24385, 2478, -6586, -18052, -21197, 15515, -1205, -12533, -15128, 10248, 27609, 25188, -93, -4918, 17451, 22912, -20227, -6643, -14084, 22545, -18912, 32759, -6204, 31913, -18248, -20565, 6372, 4, -1905, 13419, 8566, 2143, 26280, -14245, -19591, -22952, -22908, 8195, -2915, 2877, 7785, 4800, -20496, -8460, 5595, 23150, -24522, -2279, 13303, 25966, 4905, 425, 20568, -20256, 7660, -24302, -29119, -5390, -12536, -26772, 25331, -29355, -24243, -2531, -4230, 11276, 8009, -14260, 7084, 168, -13462, -1518, -8743, -6700, -5155, -25117, -31224, -23509, 28117, -9954, -9154, -5234, -295, -20522, -31997, 20187, -21432, 2916, 28399, 23453, 507, -25503, 14386, 11067, 9561, -29313, 11963, -30487};
size_t var_123 = 256u;
int16_t var_122 [] = {-9779, 20322, 9964, 16445, 10077, -14092, 1053, -24392, -20234, -16301, 15011, -7, -16, 27721, -12237, 5, 17070, -19, 6, -14645, 5848, 4, 17103, 21269, 5365, -8, -22, 6057, 2, 19, 8, -23, -26216, -16087, -8159, 4, 28042, 18378, 23, 16, -26012, -18796, 17, -27369, -12, 26688, 20, -4956, -26919, 11, -11617, 700, -22094, 22832, -21, -1083, 21087, -17, -15, 18, -9850, -16, 15, 14796, -11, -13746, 20978, -3, 10, 4768, 4, -5897, 3, 13613, 26955, -1, -7010, -28036, 11544, -8005, -3522, 9462, -19205, -21061, -12631, 27851, -12976, 3266, 29841, -30711, -20551, -25063, -2205, -15380, 16556, -14343, -18597, -22218, -17102, -18595, 1034, 9826, -22564, 9423, -25000, 29563, -4231, -12393, 18583, -23925, -32736, 3895, 2430, -25828, 9243, -29312, -7255, 27874, 5674, 14350, -1347, 16832, 19485, 17730, -9238, 19700, -30034, -31690};
size_t var_120 = 256u;
int16_t var_119 [] = {1, 29465, 6474, -25756, 23923, 18868, -10781, -15553, -8305, -16504, -30487, 8332, 19752, 25079, 23916, -28308, -7311, -19198, 19440, -1210, 14958, 4160, -31337, -22573, -7743, 25456, -7074, -1865, 8330, 14620, 29422, -29488, -15547, 17994, -32001, 8358, -25369, -29699, 28419, 11299, -20258, -22725, 14496, 30262, 5255, -28915, 2977, 5166, 32637, 6460, 29635, 24282, 4546, 7571, -22871, -13662, -31692, -17626, 23116, -17448, 9863, 5564, 13871, 31159, -29565, 27247, -8472, 252, 23090, -16895, -24312, 29092, -17706, -23920, -29885, -23821, -17923, -16922, -4015, 2157, 19898, 9954, -29035, -21849, -23231, 22782, -14137, 20072, 12911, -9342, -13658, -24662, 31525, -6178, 9277, -14469, -19084, -28917, 25630, 7517, -14808, 31276, -20633, 2584, 30957, 24446, 24798, -16615, 25411, 25663, -24046, 17106, -17497, -28776, 508, 9460, 16764, -5739, -15844, 3823, -30527, -29697, -20735, -14620, 31146, 9289, 6438, 3847};
size_t var_117 = 256u;
int16_t var_116 [] = {1, 20722, 1, 22720, 1, -19617, -8352, -19084, -11721, 1, 1, 1, 6538, 28054, -22963, -2809, 1, 1, 32630, 1, -23503, 1, -18651, 18936, -29542, 32208, -708, 1, 26355, 718, 6225, 1, 28436, -22436, -17578, -30480, 4557, -29427, 10025, 1563, 13061, 23731, -5472, -30419, 26171, 14686, 19845, -8878, 16886, -19497, 24513, -28385, -16884, 2838, -21201, -8518, 6468, 13042, -20974, 9603, 21472, 20455, -19082, 1333, -24415, 12544, 7158, -19727, 28796, -28104, 514, -8743, -32065, -32473, -25143, -30438, -10681, -11338, -26675, -21366, 18382, -18871, 29289, -15442, -8510, -7680, -20745, 10615, 4523, -8149, -11113, -18605, -9399, 21399, -1960, -8917, -18937, -23129, 6896, 31806, 27974, -25251, 22588, -23751, -30214, 28818, 22871, -8686, -27219, 14863, -30951, -3588, -11658, -3754, 10961, 23990, 4547, -20682, 825, 29950, 2360, -2175, -27679, 30293, 30760, -15197, 15133, 10292};
size_t var_114 = 256u;
int16_t var_113 [] = {-27921, -25052, 17832, 616, -30606, -32768, 15769, -24859, -21566, -24594, 9058, 23553, -17, -12646, -23156, 16746, -1299, -27261, 28274, -17232, 16159, -16, -12, 15054, -30018, 1382, 25442, -14681, 21780, -30685, 19074, -23903, 10275, -10194, -25109, -26930, -1214, -25421, 21296, -22317, -24482, -30681, 1735, -15453, 4881, 6713, -146, -4636, 17907, -29353, 13031, -8501, -27209, -21201, -26647, 13381, -25682, 17799, -13180, 14034, 148, 7132, -1481, 17652, 15028, -4414, -31767, 6625, 1589, 26303, -25350, -31496, 6875, -4582, 16015, 31295, -20630, 18688, -25027, 26702, -16763, 21440, 29449, -31200, 19962, 8181, 28685, -32649, 6083, 16115, 9848, -19572, -27638, 27095, -22780, 13956, 1445, 15760, 13295, -924, 12659, 9013, 1995, -10922, 11799, 9588, 30924, 17945, 11031, -30318, -3110, -11197, 21288, -6094, 113, 27014, -16517, 24610, 19362, 12764, 1606, -747, -20702, 25212, 22203, -11154, -22043, -7504};
size_t var_111 = 256u;
int16_t var_110 [] = {-15492, 23101, 14967, -32768, -12646, -27082, -32768, -12646, -29916, -7866, -29810, -12, -27241, -27162, -3251, -7283, 8473, 18748, 4, 12359, -15321, 3, -23469, -24270, 16430, -20952, 14685, -23080, -14145, 10, 28186, -17789, -12646, -16913, 14361, -3176, 20, -14023, -13448, -32768, 3681, -11155, 30481, 23168, -6168, -32768, -12646, 7798, 16362, -23127, -25052, -2508, 16746, 29051, -15579, -358, -16, 11693, -32768, 22322, 22404, -15, 31824, 29220, -5721, 825, 1382, -23445, 12691, -31070, 1056, -19648, -7531, 21048, -22147, -11335, 3558, 28586, 24436, 11439, 30757, 31324, -26838, 309, -4808, 495, -17589, -27288, -15211, 23828, -15238, 17853, 1635, -6742, -17379, 1058, -21211, -20864, -5881, 14996, 16633, 32428, 31671, -25448, 21404, 9282, -22238, -2801, -18720, -18553, 10067, -30009, -19143, -25031, -5829, -7791, 24351, -26653, -26167, -11576, 19452, -4049, -3229, 22213, 10747, -28049, 1921, -22078};
size_t var_108 = 256u;
int16_t var_107 [] = {-3874, -12, -20776, -27893, 5623, -940, 3669, -16, 28868, 13347, -16183, -17728, -11479, -24369, -14520, 8473, 3, -17, 6985, 31356, 19598, -22191, -20210, 27510, 18332, 10, -17009, 2047, 26555, -5868, -21633, 22262, -17463, -11486, 8813, 16846, 14661, 20809, -12848, 4, -16662, 24523, -21618, -3465, -15, -265, 14338, -3888, -23743, 3364, 16, -14897, 23522, -24093, 16159, -21254, -32668, 23506, -12646, -27921, -21009, 11, 15400, -31894, -3851, -16, 11, 23041, 26941, 11816, 15717, -12646, -32768, 7798, -29440, -7152, 32254, -8309, 8465, 27732, 1682, -12646, -32768, 15054, -32668, -12646, -20544, -6746, -8882, -269, 6852, 4310, 21923, 27401, -9283, 5161, -31250, -28027, -16488, 30764, -14033, -19598, -15939, 4343, 12385, 25855, -27676, -23371, 795, -16892, -1057, -20925, 10153, 30543, -2938, -24906, 4433, -6792, -13850, 19334, 24614, -589, 1781, 26446, -31615, -13874, -20619, -18747};
uint16_t var_105 [] = {31948u, 15907u, 56598u, 26356u, 21703u, 35189u, 21809u, 41347u, 15301u, 780u, 50399u, 13875u, 22322u, 53469u, 12493u, 17561u, 59087u, 63637u, 40436u, 52340u, 19231u, 7491u, 23389u, 18589u, 36475u, 1623u, 52640u, 58979u, 49152u, 37134u, 53410u, 61580u, 4499u, 61008u, 36727u, 30357u, 41436u, 63122u, 22918u, 44665u, 48029u, 65046u, 64857u};
int16_t var_104 [] = {-3874, 29324, -20776, -27893, 5623, -940, 3669, -3775, -30637, 13347, -16183, -17728, 22422, -24369, 32674, -21436, 6704, -8112, 22062, 31356, 19598, 7780, -20210, 27510, -29606, -14943, -17009, 2047, 26555, 1938, -21633, 22262, -17463, -11486, 8813, -24610, 14458, 20809, -12848, 3487, -16662, 24523, -21618, -3465, 30293, -265, 14338, -3888, -17904, 3364, 25055, -14897, 23522, -24093, 16130, -21254, 1841, 23506, 15439, 13236, -21009, -19417, 15400, -31894, -3851, 32001, -173, 23041, 26941, 11816, 15717, -15344, -14537, -14261, -29440, -7152, 32254, -8309, 8465, 27732, 29441, 4130, -4609, -29621, 10494, 8630, -20544, -6746, -8882, -269, 6852, 4310, 21923, 27401, -9283, 5161, -31250, -28027, -16488, 30764, -14033, -19598, -15939, 4343, 12385, 25855, -27676, -23371, 795, -16892, -1057, -20925, 10153, 30543, -2938, -24906, 4433, -6792, -13850, 19334, 24614, -589, 1781, 26446, -31615, -13874, -20619, -18747};
uint16_t var_102 [] = {118u, 42u, 34u, 142u, 166u, 160u, 2u, 14u, 108u, 50u, 48u, 116u, 70u, 78u, 88u, 130u, 78u, 146u, 30u, 32u, 28u, 122u, 58u, 168u, 72u, 162u, 164u, 142u, 50u, 162u, 112u, 170u, 30u, 112u, 16u, 100u, 144u, 28u, 24u, 36u, 42u, 96u, 132u};
int16_t var_100 [] = {-15492, 23101, -27323, 28216, 15107, -27082, -4475, -882, 29881, -7866, -29810, -8654, -27241, -27162, -3251, -7283, 18740, -15821, 11720, 12359, -15321, -25798, -23469, -24270, 16430, -20952, 14685, -23080, -14145, -18304, 28186, -17789, 25620, -16913, 30551, -3176, 21965, 1733, -13448, 10643, 3681, -11155, 30481, 23168, -17383, -22184, 4172, -23928, 16362, -23127, -15986, -2508, -30854, 29051, -15579, -358, 17410, 11693, 27722, 22322, 22404, -14262, 31824, 29220, -5721, 825, 16083, -23445, 12691, -31070, 1056, -19648, -7531, 21048, -22147, -11335, 3558, 28586, 24436, 11439, 30757, 31324, -26838, 309, -4808, 495, -17589, -27288, -15211, 23828, -15238, 17853, 1635, -6742, -17379, 1058, -21211, -20864, -5881, 14996, 16633, 32428, 31671, -25448, 21404, 9282, -22238, -2801, -18720, -18553, 10067, -30009, -19143, -25031, -5829, -7791, 24351, -26653, -26167, -11576, 19452, -4049, -3229, 22213, 10747, -28049, 1921, -22078};
uint16_t var_99 [] = {104u, 100u, 88u, 64u, 74u, 132u, 22u, 58u, 78u, 116u, 4u, 14u, 104u, 72u, 122u, 112u, 36u, 94u, 4u, 42u, 16u, 58u, 88u, 90u, 68u, 74u, 6u, 64u, 58u, 92u, 34u, 8u, 32u, 12u, 78u};
int16_t var_97 [] = {1273, -7516, 2986, 616, -30606, 8269, 15769, -24859, -21566, -24594, 9058, 23553, 16465, -13325, -23156, -4046, -1299, -27261, 28274, -17232, 31223, -29920, 10888, -25042, -30018, 14395, 25442, -14681, 21780, -30685, 19074, -23903, 10275, -10194, -25109, -26930, -1214, -25421, 21296, -22317, -24482, -30681, 1735, -15453, 4881, 6713, -146, -4636, 17907, -29353, 13031, -8501, -27209, -21201, -26647, 13381, -25682, 17799, -13180, 14034, 148, 7132, -1481, 17652, 15028, -4414, -31767, 6625, 1589, 26303, -25350, -31496, 6875, -4582, 16015, 31295, -20630, 18688, -25027, 26702, -16763, 21440, 29449, -31200, 19962, 8181, 28685, -32649, 6083, 16115, 9848, -19572, -27638, 27095, -22780, 13956, 1445, 15760, 13295, -924, 12659, 9013, 1995, -10922, 11799, 9588, 30924, 17945, 11031, -30318, -3110, -11197, 21288, -6094, 113, 27014, -16517, 24610, 19362, 12764, 1606, -747, -20702, 25212, 22203, -11154, -22043, -7504};
uint16_t var_96 [] = {0u, 2u, 24u, 50u, 46u, 50u, 44u, 42u, 40u, 10u, 4u, 26u, 30u};
int16_t var_94 [] = {-30573, 20722, -7246, 22720, -26505, -19617, -8352, -19084, -11721, -2847, 24265, 29063, 6538, 28054, -22963, -2809, -17932, 13466, 32630, -5817, -23503, -15731, -18651, 18936, -29542, 32208, -708, -6265, 26355, 718, 6225, -29005, 28436, -22436, -17578, -30480, 4557, -29427, 10025, 1563, 13061, 23731, -5472, -30419, 26171, 14686, 19845, -8878, 16886, -19497, 24513, -28385, -16884, 2838, -21201, -8518, 6468, 13042, -20974, 9603, 21472, 20455, -19082, 1333, -24415, 12544, 7158, -19727, 28796, -28104, 514, -8743, -32065, -32473, -25143, -30438, -10681, -11338, -26675, -21366, 18382, -18871, 29289, -15442, -8510, -7680, -20745, 10615, 4523, -8149, -11113, -18605, -9399, 21399, -1960, -8917, -18937, -23129, 6896, 31806, 27974, -25251, 22588, -23751, -30214, 28818, 22871, -8686, -27219, 14863, -30951, -3588, -11658, -3754, 10961, 23990, 4547, -20682, 825, 29950, 2360, -2175, -27679, 30293, 30760, -15197, 15133, 10292};
uint16_t var_93 [] = {0u, 54u, 20u, 22u, 38u, 62u, 42u, 34u, 32u, 4u, 18u, 8u, 18u, 34u, 8u, 4u};
int16_t var_91 [] = {30189, 29465, 6474, -25756, 23923, 18868, -10781, -15553, -8305, -16504, -30487, 8332, 19752, 25079, 23916, -28308, -7311, -19198, 19440, -1210, 14958, 4160, -31337, -22573, -7743, 25456, -7074, -1865, 8330, 14620, 29422, -29488, -15547, 17994, -32001, 8358, -25369, -29699, 28419, 11299, -20258, -22725, 14496, 30262, 5255, -28915, 2977, 5166, 32637, 6460, 29635, 24282, 4546, 7571, -22871, -13662, -31692, -17626, 23116, -17448, 9863, 5564, 13871, 31159, -29565, 27247, -8472, 252, 23090, -16895, -24312, 29092, -17706, -23920, -29885, -23821, -17923, -16922, -4015, 2157, 19898, 9954, -29035, -21849, -23231, 22782, -14137, 20072, 12911, -9342, -13658, -24662, 31525, -6178, 9277, -14469, -19084, -28917, 25630, 7517, -14808, 31276, -20633, 2584, 30957, 24446, 24798, -16615, 25411, 25663, -24046, 17106, -17497, -28776, 508, 9460, 16764, -5739, -15844, 3823, -30527, -29697, -20735, -14620, 31146, 9289, 6438, 3847};
uint16_t var_90 [] = {0u, 0u};
uint16_t var_88 [] = {65227u, 41370u, 12269u, 17089u, 28969u, 14890u, 15550u, 20307u, 7477u, 23844u, 41557u, 2477u, 27142u, 30712u, 21610u, 15475u, 46088u, 2851u, 65481u, 11244u, 25403u, 24148u, 37501u, 11798u, 61070u, 64030u, 37532u, 821u, 35906u, 11956u, 43933u, 17530u, 50878u, 45820u, 44015u, 43927u, 18941u, 53293u, 20991u};
int16_t var_87 [] = {-9779, 20322, 9964, -26815, 10077, -14092, 1053, -24392, -20234, -16301, 15011, -6775, 18716, 27721, -12237, 10726, 17070, 30274, -3902, -14645, 5848, 28719, 17103, 21269, 5365, -28263, -14925, 6057, 9840, -30658, 14370, -13916, -26216, -16087, -8159, -17690, 28042, 18378, 11037, -11121, -26012, -18796, 12102, -27369, 13438, 26688, 8335, -4956, -26919, 11883, -11617, 700, -22094, 22832, 21108, -1083, 21087, 1234, -22422, -17256, -9850, -27596, -29223, 14796, 16656, -13746, 20978, 13606, 7999, 4768, -22686, -5897, 25569, 13613, 26955, -17915, -7190, -28036, 11544, -8005, -3522, 9462, -19205, -21061, -12631, 27851, -12976, 3266, 29841, -30711, -20551, -25063, -2205, -15380, 16556, -14343, -18597, -22218, -17102, -18595, 1034, 9826, -22564, 9423, -25000, 29563, -4231, -12393, 18583, -23925, -32736, 3895, 2430, -25828, 9243, -29312, -7255, 27874, 5674, 14350, -1347, 16832, 19485, 17730, -9238, 19700, -30034, -31690};
uint16_t var_85 [] = {36u, 34u, 114u, 6u, 56u, 128u, 152u, 122u, 124u, 84u, 52u, 34u, 108u, 58u, 116u, 24u, 42u, 76u, 140u, 144u, 30u, 98u, 134u, 22u, 88u, 60u, 118u, 92u, 136u, 150u, 108u, 62u, 70u, 50u, 152u, 78u, 56u, 52u, 58u};
uint16_t var_83 [] = {10138u, 25302u, 39202u, 23724u, 23053u, 3225u, 38517u, 5270u, 952u, 24729u, 13809u, 56006u, 61525u, 18955u, 51707u, 22482u, 39659u, 1284u, 61542u, 32864u, 13656u, 4337u, 7451u};
int16_t var_82 [] = {-29374, -15481, 28920, -16452, 2364, 11352, 31508, -160, -21628, -15526, 21857, 17291, 11391, 13824, -9725, -3202, 7770, 8309, -6758, -20988, -1052, -13965, 17482, 179, -20071, -27134, 12350, -13029, 30140, 19533, 24385, 2478, -6586, -18052, -19817, 15515, -494, -12533, -15128, 10248, 27609, -2556, 12711, -4918, 11494, 22912, -20227, -6643, -14084, 22545, -18912, 32759, -6204, 31913, -18248, -20565, 6372, 4, -1905, 13419, 8566, 2143, 26280, -14245, -19591, -22952, -22908, 8195, -2915, 2877, 7785, 4800, -20496, -8460, 5595, 23150, -24522, -2279, 13303, 25966, 4905, 425, 20568, -20256, 7660, -24302, -29119, -5390, -12536, -26772, 25331, -29355, -24243, -2531, -4230, 11276, 8009, -14260, 7084, 168, -13462, -1518, -8743, -6700, -5155, -25117, -31224, -23509, 28117, -9954, -9154, -5234, -295, -20522, -31997, 20187, -21432, 2916, 28399, 23453, 507, -25503, 14386, 11067, 9561, -29313, 11963, -30487};
uint16_t var_80 [] = {56u, 26u, 8u, 38u, 84u, 44u, 82u, 36u, 40u, 44u, 88u, 12u, 38u, 82u, 72u, 10u, 68u, 54u, 20u, 88u, 30u, 24u, 34u};
int16_t var_78 [] = {-5511, 15397, -4090, 16445, -10331, -5993, -14277, 4670, 13645, 28158, 28011, 11743, -17516, 22469, 25023, 11351, 29064, 4055, 21504, 21062, -26487, -21392, -21758, -2303, 2416, -5950, 1317, 25973, 24101, -17769, 16867, -5484, -18462, 4760, -7010, -13594, 9063, -24357, 6877, 32191, 20488, -28272, -14390};
int16_t var_77 [] = {-9272, 6480, 23710, -26200, -10002, 15766, 16296, 22542, -20837, -23948, 26261, 25825, 29785, -27571, 20391, 22236, -5484, -31468, -6557, -4992, -7302, -15536, 4982, 9881, 16502, -11417, -24719, -27524, -14185, 2026, 29115, 31200, -6220, 11180, 18656, -22473, -3476, 31030, -25960, -17740, 32565, -10169, -15162};
int8_t var_76 [] = {57, -3, -103, 21, 52, -36, 52, -51, -105, 98, 83, 103, 114, -35, 102, -63, -68, -34, 78, 81, 114, -49, -60, 47, -34, -67, 39, -68, -125, 30, -108, -79, 69, 55, 21, -4, 123, 100, 35, 66, -58, -111, 123};
int16_t var_75 [] = {-12646, 2213, 18070, -25056, 20976, 13975, 22983, -5316, 23375, 1375, 30183, -20303, -21873, -22498, -13300, 25563};
uint16_t var_74 [] = {10847u, 47586u, 21367u, 56430u, 60552u, 49838u, 906u, 20140u, 15972u, 2432u, 48332u, 7048u, 63008u, 40299u, 20052u, 13973u, 42746u, 45489u, 29260u, 11899u, 11897u, 53839u, 61489u};
int16_t var_73 [] = {5002, 10571, -15542, 26888, -93, -17789, 31891, 8998, -9045, -4977, -6086, -19325, 8565, 25188, -1205, 4422, -21197, 11152, -5851, 17451, 21681, -9264, -27896};
int8_t var_72 [] = {-128, 27, -125, 81, 101, 93, 109, -84, 89, -55, 95, 63, 53, -83, 44, -68, 112, -118, -113, 66, 103, -82, -45, 70, 4, -100, -26, 50, 120, -6, -84, -3, 51, 30, -70, -72, 87, -114, -86, 20, -27, 91, -36};
int8_t var_71 [] = {46, -55, 38, -91, -4, -52, -122, 8, -119, 32, -25, 50, -32, 7, -101, 67, 51, 49, 69, -63, 70, -8, 76, -106, -122, 4, -15, 112, -1, 55, -116, 15, -88, 35, 63, 42, 54, 23, 107, 67, 104, -59, -99};
uint8_t var_70 [] = {227u, 90u, 33u, 177u, 193u, 6u, 63u, 227u, 151u, 211u, 162u, 248u, 135u, 190u, 160u, 173u, 153u, 227u, 227u, 111u, 175u, 121u, 98u, 3u, 249u, 197u, 131u, 120u, 149u, 7u, 36u, 64u, 118u, 96u, 94u, 191u, 142u, 221u, 242u, 76u, 208u, 30u, 7u};
uint8_t var_69 [] = {126u, 146u, 114u, 95u, 190u, 25u, 23u, 215u, 116u, 98u, 139u, 9u, 83u, 252u, 171u, 206u, 156u, 41u, 160u, 253u, 151u, 15u, 100u, 135u, 192u, 187u, 166u, 238u, 242u, 249u, 31u, 197u, 142u, 15u, 122u, 153u, 0u, 71u, 48u, 161u, 133u, 60u, 186u};
int8_t var_68 [] = {-100, 52, 10, -108};
uint16_t var_67 [] = {30791u, 32459u, 39289u, 50133u, 53913u, 48374u, 15719u, 9547u, 28529u, 15519u, 26813u, 22990u, 62351u, 47984u, 32959u, 25324u, 32137u, 16732u, 63291u, 54919u, 40630u, 3912u, 64270u, 16071u, 36589u, 3729u, 38470u, 25306u, 58574u, 39571u, 47284u, 3995u, 52442u, 17945u, 38770u, 12707u, 15396u, 39496u, 45828u};
uint16_t var_66 [] = {45618u, 62692u, 39356u, 14082u, 29123u, 46469u, 64388u, 61757u, 35123u, 64621u, 51420u, 8965u, 31645u, 53358u, 49100u, 52945u, 41586u, 57867u, 52741u, 48479u, 33678u, 37157u, 42709u, 6424u, 28769u, 39681u, 24575u, 19532u, 38277u, 17703u, 41691u, 2212u, 30429u, 56201u, 32882u, 34302u, 50077u, 24423u, 46580u, 38670u, 36911u, 10324u, 31124u};
int16_t var_65 [] = {-10538, 31070, -6546, -810, 5895, 18940, 16260, 26564, 7998, -16670, -20866, 15828, -26614, -24949, -19205, 495};
int16_t var_64 [] = {13702, -18610, -12797, 19185, 21065, -2396, 16058, -20073, -26093, -25203, -24989, 6430, -20885, -6194, 19788, -19441};
int16_t var_63 [] = {11637, 14703, -7094, -28721, 27782, 10360, -14008, 7374, 11740, 22525, 16581, -437, -26907, 19495, 22176, 27240};
uint8_t var_62 [] = {160u, 60u, 44u, 207u, 248u, 254u, 160u, 176u, 101u, 148u, 47u, 190u, 145u, 189u, 116u, 236u, 114u, 158u, 203u, 158u, 24u, 130u, 148u, 97u, 129u, 58u, 75u, 158u, 53u, 208u, 206u, 213u, 220u, 182u, 59u, 214u, 91u, 90u, 229u, 165u, 62u, 214u, 6u};
uint8_t var_61 [] = {203u, 135u, 191u, 188u, 192u, 161u, 148u, 127u, 202u, 125u, 127u, 98u, 194u, 32u, 146u, 37u, 141u, 160u, 91u, 217u, 82u, 91u, 154u, 66u, 172u, 117u, 10u, 184u, 119u, 252u, 202u, 152u, 39u, 132u, 175u, 20u, 225u, 160u, 182u, 153u, 21u, 145u, 201u};
int16_t var_60 [] = {1598, -8821, -23423, -10042, -23921, -19702, 21693, -15108, 12119, -2074, 13483, -6254, -22188, -16141, -25471, -6047, 28605, -17302, 25119, -20212, 28410, 30522, -12565, 4887, 6405, -25476, 3974, -17684, 7450, -674, 27331, -3539, 3566, 14853, -5480, -7573, 27415, -21047, 19826, 21081, -29014, -21530, -16291};
int8_t var_59 [] = {-85, -43, 99, -52, 53, -81, 71, 39, 5, 30, 37, -61, 98, 104, -31, 93, 47, -87, 15, 110, 73, -5, -112, -85, -95, 16, -57, -81, 125, 99, 74, 67, -94, 15, -118, 58, 30, -46, -111, -111, -31, -111, -18};
int8_t var_58 [] = {56, -35, -4, 36, -28, 88, 56, 2, 35, 79, 41, -113, 53, -46, -105, 59, 39, -89, -73, -71, 110, -91, 111, 99, 126, 32, -57, -106, -55, -60, 95, 11, 96, 38, 65, 56, 42, 104, -104, 44, 112, 64, -116};
uint16_t var_57 [] = {40437u, 1413u, 18568u, 7352u, 56494u, 35473u, 28212u, 7527u, 6266u, 15098u, 64091u, 31478u, 56635u, 42334u, 35812u, 34310u, 10601u, 59359u, 58998u, 10634u, 4819u, 44391u, 5989u, 61550u, 18084u, 21434u, 9675u, 33913u, 45750u, 32052u, 32212u, 8999u, 30041u, 7670u, 21180u, 19159u, 48162u, 57027u, 50230u, 35468u, 22026u, 40268u, 51250u};
uint8_t var_56 [] = {122u, 113u, 82u, 171u, 243u, 2u, 238u, 133u, 100u, 6u, 18u, 50u, 109u, 123u, 144u, 6u, 189u, 46u, 60u, 92u, 12u, 55u, 0u, 111u, 82u, 168u, 245u, 202u, 73u, 47u, 74u, 78u, 227u, 173u, 114u, 168u, 72u, 52u, 158u, 88u, 208u, 35u, 179u};
int16_t var_55 [] = {-16284, -13415, -19274, -8700, 26691, 13019, 8586, 7041, 27796, -28029, 29469, 10834, 28383, 5432, -20502, 21913, 30298, 19435, 26604, -20204, -18279, 8553, 5469, -28047, 25998, -2386, -24509, -6229, -27464, 11837, 30385, -5603, 20110, -32594, -28965, -17685, -23970, -3083, 158, 18622, -12954, -16606, -25145};
int16_t var_54 = -1354;
int8_t var_53 = -27;
uint16_t var_52 = 20066u;
int16_t var_51 = 7149;
uint16_t var_50 = 11724u;
__riscv_vsetvl_e16m8(43);
vuint16m8_t var_101 = __riscv_vle16_v_u16m8(var_102, 43);
// 118, 42, 34, 142, 166, 160, 2, 14, 108, 50, 48, 116, 70, 78, 88, 130, 78, 146, 30, 32, 28, 122, 58, 168, 72, 162, 164, 142, 50, 162, 112, 170, 30, 112, 16, 100, 144, 28, 24, 36, 42, 96, 132

__riscv_vsetvl_e16m8(35);
vuint16m8_t var_98 = __riscv_vle16_v_u16m8(var_99, 35);
// 104, 100, 88, 64, 74, 132, 22, 58, 78, 116, 4, 14, 104, 72, 122, 112, 36, 94, 4, 42, 16, 58, 88, 90, 68, 74, 6, 64, 58, 92, 34, 8, 32, 12, 78

__riscv_vsetvl_e16m8(13);
vuint16m8_t var_95 = __riscv_vle16_v_u16m8(var_96, 13);
// 0, 2, 24, 50, 46, 50, 44, 42, 40, 10, 4, 26, 30

__riscv_vsetvl_e16m8(16);
vuint16m8_t var_92 = __riscv_vle16_v_u16m8(var_93, 16);
// 0, 54, 20, 22, 38, 62, 42, 34, 32, 4, 18, 8, 18, 34, 8, 4

__riscv_vsetvl_e16m8(2);
vuint16m8_t var_89 = __riscv_vle16_v_u16m8(var_90, 2);
// 0, 0

__riscv_vsetvl_e16m8(39);
vuint16m8_t var_84 = __riscv_vle16_v_u16m8(var_85, 39);
// 36, 34, 114, 6, 56, 128, 152, 122, 124, 84, 52, 34, 108, 58, 116, 24, 42, 76, 140, 144, 30, 98, 134, 22, 88, 60, 118, 92, 136, 150, 108, 62, 70, 50, 152, 78, 56, 52, 58

__riscv_vsetvl_e16m8(23);
vuint16m8_t var_79 = __riscv_vle16_v_u16m8(var_80, 23);
// 56, 26, 8, 38, 84, 44, 82, 36, 40, 44, 88, 12, 38, 82, 72, 10, 68, 54, 20, 88, 30, 24, 34

__riscv_vsetvl_e16m8(43);
vint16m8_t var_21 = __riscv_vle16_v_i16m8(var_78, 43);
// -5511, 15397, -4090, 16445, -10331, -5993, -14277, 4670, 13645, 28158, 28011, 11743, -17516, 22469, 25023, 11351, 29064, 4055, 21504, 21062, -26487, -21392, -21758, -2303, 2416, -5950, 1317, 25973, 24101, -17769, 16867, -5484, -18462, 4760, -7010, -13594, 9063, -24357, 6877, 32191, 20488, -28272, -14390

vint16m8_t var_22 = __riscv_vle16_v_i16m8(var_77, 43);
// -9272, 6480, 23710, -26200, -10002, 15766, 16296, 22542, -20837, -23948, 26261, 25825, 29785, -27571, 20391, 22236, -5484, -31468, -6557, -4992, -7302, -15536, 4982, 9881, 16502, -11417, -24719, -27524, -14185, 2026, 29115, 31200, -6220, 11180, 18656, -22473, -3476, 31030, -25960, -17740, 32565, -10169, -15162

vint8m4_t var_23 = __riscv_vle8_v_i8m4(var_76, 43);
// 57, -3, -103, 21, 52, -36, 52, -51, -105, 98, 83, 103, 114, -35, 102, -63, -68, -34, 78, 81, 114, -49, -60, 47, -34, -67, 39, -68, -125, 30, -108, -79, 69, 55, 21, -4, 123, 100, 35, 66, -58, -111, 123

__riscv_vsetvl_e16m2(16);
vint16m2_t var_24 = __riscv_vle16_v_i16m2(var_75, 16);
// -12646, 2213, 18070, -25056, 20976, 13975, 22983, -5316, 23375, 1375, 30183, -20303, -21873, -22498, -13300, 25563

__riscv_vsetvl_e16m8(23);
vuint16m8_t var_25 = __riscv_vle16_v_u16m8(var_74, 23);
// 10847, 47586, 21367, 56430, 60552, 49838, 906, 20140, 15972, 2432, 48332, 7048, 63008, 40299, 20052, 13973, 42746, 45489, 29260, 11899, 11897, 53839, 61489

vint16m8_t var_26 = __riscv_vle16_v_i16m8(var_73, 23);
// 5002, 10571, -15542, 26888, -93, -17789, 31891, 8998, -9045, -4977, -6086, -19325, 8565, 25188, -1205, 4422, -21197, 11152, -5851, 17451, 21681, -9264, -27896

__riscv_vsetvl_e8m4(43);
vint8m4_t var_27 = __riscv_vle8_v_i8m4(var_72, 43);
// -128, 27, -125, 81, 101, 93, 109, -84, 89, -55, 95, 63, 53, -83, 44, -68, 112, -118, -113, 66, 103, -82, -45, 70, 4, -100, -26, 50, 120, -6, -84, -3, 51, 30, -70, -72, 87, -114, -86, 20, -27, 91, -36

vint8m4_t var_28 = __riscv_vle8_v_i8m4(var_71, 43);
// 46, -55, 38, -91, -4, -52, -122, 8, -119, 32, -25, 50, -32, 7, -101, 67, 51, 49, 69, -63, 70, -8, 76, -106, -122, 4, -15, 112, -1, 55, -116, 15, -88, 35, 63, 42, 54, 23, 107, 67, 104, -59, -99

vuint8m4_t var_29 = __riscv_vle8_v_u8m4(var_70, 43);
// 227, 90, 33, 177, 193, 6, 63, 227, 151, 211, 162, 248, 135, 190, 160, 173, 153, 227, 227, 111, 175, 121, 98, 3, 249, 197, 131, 120, 149, 7, 36, 64, 118, 96, 94, 191, 142, 221, 242, 76, 208, 30, 7

vuint8m4_t var_30 = __riscv_vle8_v_u8m4(var_69, 43);
// 126, 146, 114, 95, 190, 25, 23, 215, 116, 98, 139, 9, 83, 252, 171, 206, 156, 41, 160, 253, 151, 15, 100, 135, 192, 187, 166, 238, 242, 249, 31, 197, 142, 15, 122, 153, 0, 71, 48, 161, 133, 60, 186

__riscv_vsetvl_e8mf4(4);
vint8mf4_t var_31 = __riscv_vle8_v_i8mf4(var_68, 4);
// -100, 52, 10, -108

__riscv_vsetvl_e16m8(39);
vuint16m8_t var_32 = __riscv_vle16_v_u16m8(var_67, 39);
// 30791, 32459, 39289, 50133, 53913, 48374, 15719, 9547, 28529, 15519, 26813, 22990, 62351, 47984, 32959, 25324, 32137, 16732, 63291, 54919, 40630, 3912, 64270, 16071, 36589, 3729, 38470, 25306, 58574, 39571, 47284, 3995, 52442, 17945, 38770, 12707, 15396, 39496, 45828

__riscv_vsetvl_e16m8(43);
vuint16m8_t var_34 = __riscv_vle16_v_u16m8(var_66, 43);
// 45618, 62692, 39356, 14082, 29123, 46469, 64388, 61757, 35123, 64621, 51420, 8965, 31645, 53358, 49100, 52945, 41586, 57867, 52741, 48479, 33678, 37157, 42709, 6424, 28769, 39681, 24575, 19532, 38277, 17703, 41691, 2212, 30429, 56201, 32882, 34302, 50077, 24423, 46580, 38670, 36911, 10324, 31124

__riscv_vsetvl_e16m8(16);
vint16m8_t var_36 = __riscv_vle16_v_i16m8(var_65, 16);
// -10538, 31070, -6546, -810, 5895, 18940, 16260, 26564, 7998, -16670, -20866, 15828, -26614, -24949, -19205, 495

vint16m8_t var_37 = __riscv_vle16_v_i16m8(var_64, 16);
// 13702, -18610, -12797, 19185, 21065, -2396, 16058, -20073, -26093, -25203, -24989, 6430, -20885, -6194, 19788, -19441

__riscv_vsetvl_e16m2(16);
vint16m2_t var_38 = __riscv_vle16_v_i16m2(var_63, 16);
// 11637, 14703, -7094, -28721, 27782, 10360, -14008, 7374, 11740, 22525, 16581, -437, -26907, 19495, 22176, 27240

__riscv_vsetvl_e8m4(43);
vuint8m4_t var_40 = __riscv_vle8_v_u8m4(var_62, 43);
// 160, 60, 44, 207, 248, 254, 160, 176, 101, 148, 47, 190, 145, 189, 116, 236, 114, 158, 203, 158, 24, 130, 148, 97, 129, 58, 75, 158, 53, 208, 206, 213, 220, 182, 59, 214, 91, 90, 229, 165, 62, 214, 6

vuint8m4_t var_41 = __riscv_vle8_v_u8m4(var_61, 43);
// 203, 135, 191, 188, 192, 161, 148, 127, 202, 125, 127, 98, 194, 32, 146, 37, 141, 160, 91, 217, 82, 91, 154, 66, 172, 117, 10, 184, 119, 252, 202, 152, 39, 132, 175, 20, 225, 160, 182, 153, 21, 145, 201

vint16m8_t var_42 = __riscv_vle16_v_i16m8(var_60, 43);
// 1598, -8821, -23423, -10042, -23921, -19702, 21693, -15108, 12119, -2074, 13483, -6254, -22188, -16141, -25471, -6047, 28605, -17302, 25119, -20212, 28410, 30522, -12565, 4887, 6405, -25476, 3974, -17684, 7450, -674, 27331, -3539, 3566, 14853, -5480, -7573, 27415, -21047, 19826, 21081, -29014, -21530, -16291

vint8m4_t var_45 = __riscv_vle8_v_i8m4(var_59, 43);
// -85, -43, 99, -52, 53, -81, 71, 39, 5, 30, 37, -61, 98, 104, -31, 93, 47, -87, 15, 110, 73, -5, -112, -85, -95, 16, -57, -81, 125, 99, 74, 67, -94, 15, -118, 58, 30, -46, -111, -111, -31, -111, -18

vint8m4_t var_46 = __riscv_vle8_v_i8m4(var_58, 43);
// 56, -35, -4, 36, -28, 88, 56, 2, 35, 79, 41, -113, 53, -46, -105, 59, 39, -89, -73, -71, 110, -91, 111, 99, 126, 32, -57, -106, -55, -60, 95, 11, 96, 38, 65, 56, 42, 104, -104, 44, 112, 64, -116

vuint16m8_t var_47 = __riscv_vle16_v_u16m8(var_57, 43);
// 40437, 1413, 18568, 7352, 56494, 35473, 28212, 7527, 6266, 15098, 64091, 31478, 56635, 42334, 35812, 34310, 10601, 59359, 58998, 10634, 4819, 44391, 5989, 61550, 18084, 21434, 9675, 33913, 45750, 32052, 32212, 8999, 30041, 7670, 21180, 19159, 48162, 57027, 50230, 35468, 22026, 40268, 51250

vuint8m4_t var_48 = __riscv_vle8_v_u8m4(var_56, 43);
// 122, 113, 82, 171, 243, 2, 238, 133, 100, 6, 18, 50, 109, 123, 144, 6, 189, 46, 60, 92, 12, 55, 0, 111, 82, 168, 245, 202, 73, 47, 74, 78, 227, 173, 114, 168, 72, 52, 158, 88, 208, 35, 179

vint16m8_t var_49 = __riscv_vle16_v_i16m8(var_55, 43);
// -16284, -13415, -19274, -8700, 26691, 13019, 8586, 7041, 27796, -28029, 29469, 10834, 28383, 5432, -20502, 21913, 30298, 19435, 26604, -20204, -18279, 8553, 5469, -28047, 25998, -2386, -24509, -6229, -27464, 11837, 30385, -5603, 20110, -32594, -28965, -17685, -23970, -3083, 158, 18622, -12954, -16606, -25145

vbool2_t var_20 = __riscv_vmadc_vx_i8m4_b2(var_23, var_53, 43);
// 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e16m2(16);
int16_t var_18 = __riscv_vmv_x_s_i16m2_i16(var_24);
// -12646

__riscv_vsetvl_e16m8(23);
__riscv_vse16_v_u16m8(var_83, var_25, 23);
__riscv_vsoxei16_v_i16m8(var_82, var_79, var_26, 23);
__riscv_vsetvl_e8m4(43);
vint8m4_t var_16 = __riscv_vor_vv_i8m4(var_27, var_28, 43);
// -82, -37, -89, -11, -3, -35, -17, -84, -39, -23, -1, 63, -11, -81, -65, -1, 115, -69, -49, -61, 103, -2, -33, -42, -122, -100, -9, 114, -1, -1, -84, -1, -69, 63, -65, -70, 119, -97, -21, 87, -19, -33, -35

vuint16m8_t var_15 = __riscv_vwsubu_vv_u16m8(var_29, var_30, 43);
// 101, 65480, 65455, 82, 3, 65517, 40, 12, 35, 113, 23, 239, 52, 65474, 65525, 65503, 65533, 186, 67, 65394, 24, 106, 65534, 65404, 57, 10, 65501, 65418, 65443, 65294, 5, 65403, 65512, 81, 65508, 38, 142, 150, 194, 65451, 75, 65506, 65357

__riscv_vsetvl_e8mf4(4);
int8_t var_14 = __riscv_vmv_x_s_i8mf4_i8(var_31);
// -100

__riscv_vsetvl_e16m8(39);
__riscv_vse16_v_u16m8(var_88, var_32, 39);
__riscv_vsetvl_e16m8(43);
vbool2_t var_33 = __riscv_vmsbc_vx_u16m8_b2(var_34, var_52, 43);
// 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e16m8(16);
vbool2_t var_35 = __riscv_vmsne_vv_i16m8_b2(var_36, var_37, 16);
// 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e16m2(16);
int16_t var_10 = __riscv_vmv_x_s_i16m2_i16(var_38);
// 11637

__riscv_vsetvl_e16m8(43);
vbool2_t var_39 = __riscv_vmadc_vx_i16m8_b2(var_42, var_51, 43);
// 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vbool2_t var_44 = __riscv_vmsle_vv_i8m4_b2(var_45, var_46, 43);
// 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vbool2_t var_43 = __riscv_vmadc_vx_u16m8_b2(var_47, var_50, 43);
// 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

vint16m8_t var_19 = __riscv_vdiv_vx_i16m8_mu(var_20, var_21, var_22, var_54, 43);
// 6, -4, -17, 16445, 7, -11, -12, -16, 15, 17, -19, -19, -21, 20, -15, -16, 4, 23, 4, 3, 5, 11, -3, -7, -12, 8, 18, 20, 10, -1, -21, -23, 4, -8, -7010, 16, 2, -22, 19, 13, -24, 7, 11

if(!check(var_83, var_128, var_129)) {cerr << "check 127 fails" << endl; return_value = 1;}
if(!check(var_82, var_125, var_126)) {cerr << "check 124 fails" << endl; return_value = 1;}
if(!check(var_88, var_131, var_132)) {cerr << "check 130 fails" << endl; return_value = 1;}
vuint16m8_t var_8 = __riscv_vwmulu_vv_u16m8_mu(var_39, var_15, var_40, var_41, 43);
// 101, 65480, 65455, 82, 3, 65517, 40, 12, 35, 18500, 23, 18620, 52, 65474, 65525, 8732, 65533, 186, 67, 65394, 24, 106, 65534, 65404, 57, 10, 65501, 65418, 65443, 52416, 5, 32376, 65512, 81, 10325, 38, 142, 150, 194, 65451, 75, 65506, 65357

vbool2_t var_6 = __riscv_vmsge_vv_i8m4_b2_mu(var_43, var_44, var_16, var_16, 43);
// 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

__riscv_vsetvl_e16m8(39);
__riscv_vsoxei16_v_i16m8(var_87, var_84, var_19, 39);
__riscv_vsetvl_e16m8(43);
vint16m8_t var_12 = __riscv_vmerge_vxm_i16m8(var_19, var_18, var_33, 43);
// 6, -4, -17, -12646, 7, -11, -12, -16, 15, 17, -19, -12646, -21, 20, -15, -16, 4, 23, 4, 3, 5, 11, -3, -12646, -12, 8, 18, -12646, 10, -12646, -21, -12646, 4, -8, -7010, 16, 2, -22, 19, 13, -24, -12646, 11

__riscv_vse16_v_u16m8(var_105, var_8, 43);
if(!check(var_87, var_122, var_123)) {cerr << "check 121 fails" << endl; return_value = 1;}
vint8m4_t var_5 = __riscv_vnsra_wv_i8m4(var_12, var_48, 43);
// 0, -2, -5, -7, 0, -3, -1, -1, 0, 0, -5, -90, -1, 0, -15, -1, 0, 0, 0, 0, 0, 0, -3, -1, -3, 0, 0, -13, 0, -1, -1, -1, 0, -1, 39, 0, 0, -2, 0, 0, -24, -45, 1

vint16m8_t var_4 = __riscv_vssub_vx_i16m8_mu(var_6, var_12, var_49, var_10, 43);
// -27921, -25052, -17, -20337, 15054, 1382, -12, -16, 16159, -32768, 17832, -12646, 16746, 20, -15, -16, 4, 7798, 14967, 3, -29916, 11, -6168, -32768, 14361, -14023, -32768, -12646, 10, -12646, 18748, -12646, 8473, -32768, -32768, 16, -32768, -14720, -11479, 6985, -24591, -28243, 11

__riscv_vsetvl_e16m8(16);
vint16m8_t var_11 = __riscv_vdiv_vv_i16m8_mu(var_35, var_12, var_12, var_12, 16);
// 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 23, 4, 3, 5, 11, -3, -12646, -12, 8, 18, -12646, 10, -12646, -21, -12646, 4, -8, -7010, 16, 2, -22, 19, 13, -24, -12646, 11

if(!check(var_105, var_134, var_135)) {cerr << "check 133 fails" << endl; return_value = 1;}
__riscv_vsetvl_e8m4(43);
vint16m8_t var_1 = __riscv_vwmacc_vx_i16m8_mu(var_6, var_4, var_14, var_5, 43);
// -27921, -24852, -17, -19637, 15054, 1682, -12, -16, 16159, -32768, 18332, -12646, 16846, 20, -15, -16, 4, 7798, 14967, 3, -29916, 11, -5868, -32668, 14661, -14023, -32768, -12646, 10, -12646, 18848, -12646, 8473, -32668, 28868, 16, -32768, -14520, -11479, 6985, -22191, -23743, 11

__riscv_vsetvl_e16m8(13);
__riscv_vsoxei16_v_i16m8(var_97, var_95, var_4, 13);
__riscv_vsetvl_e16m8(35);
__riscv_vsoxei16_v_i16m8(var_100, var_98, var_4, 35);
__riscv_vsetvl_e16m8(16);
__riscv_vsoxei16_v_i16m8(var_94, var_92, var_11, 16);
__riscv_vsetvl_e16m8(2);
__riscv_vsoxei16_v_i16m8(var_91, var_89, var_11, 2);
__riscv_vsetvl_e16m8(43);
__riscv_vsoxei16_v_i16m8(var_104, var_101, var_1, 43);
if(!check(var_97, var_113, var_114)) {cerr << "check 112 fails" << endl; return_value = 1;}
if(!check(var_100, var_110, var_111)) {cerr << "check 109 fails" << endl; return_value = 1;}
if(!check(var_94, var_116, var_117)) {cerr << "check 115 fails" << endl; return_value = 1;}
if(!check(var_91, var_119, var_120)) {cerr << "check 118 fails" << endl; return_value = 1;}
if(!check(var_104, var_107, var_108)) {cerr << "check 106 fails" << endl; return_value = 1;}
if (return_value)
  __builtin_abort ();
return return_value;
}
