/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2023 Intel Corporation
 */

#ifndef VRB2_VF_ENUM_H
#define VRB2_VF_ENUM_H

/*
 * VRB2 Register mapping on VF BAR0
 * This is automatically generated from RDL, format may change with new RDL
 */
enum {
	VRB2_VfHiVfToPfDbellVf           = 0x00000000,
	VRB2_VfHiPfToVfDbellVf           = 0x00000008,
	VRB2_VfHiInfoRingBaseLoVf        = 0x00000010,
	VRB2_VfHiInfoRingBaseHiVf        = 0x00000014,
	VRB2_VfHiInfoRingPointerVf       = 0x00000018,
	VRB2_VfHiInfoRingIntWrEnVf       = 0x00000020,
	VRB2_VfHiInfoRingPf2VfWrEnVf     = 0x00000024,
	VRB2_VfHiMsixVectorMapperVf      = 0x00000060,
	VRB2_VfHiDeviceStatus            = 0x00000068,
	VRB2_VfHiInterruptSrc            = 0x00000070,
	VRB2_VfDmaFec5GulDescBaseLoRegVf = 0x00000120,
	VRB2_VfDmaFec5GulDescBaseHiRegVf = 0x00000124,
	VRB2_VfDmaFec5GulRespPtrLoRegVf  = 0x00000128,
	VRB2_VfDmaFec5GulRespPtrHiRegVf  = 0x0000012C,
	VRB2_VfDmaFec5GdlDescBaseLoRegVf = 0x00000140,
	VRB2_VfDmaFec5GdlDescBaseHiRegVf = 0x00000144,
	VRB2_VfDmaFec5GdlRespPtrLoRegVf  = 0x00000148,
	VRB2_VfDmaFec5GdlRespPtrHiRegVf  = 0x0000014C,
	VRB2_VfDmaFec4GulDescBaseLoRegVf = 0x00000160,
	VRB2_VfDmaFec4GulDescBaseHiRegVf = 0x00000164,
	VRB2_VfDmaFec4GulRespPtrLoRegVf  = 0x00000168,
	VRB2_VfDmaFec4GulRespPtrHiRegVf  = 0x0000016C,
	VRB2_VfDmaFec4GdlDescBaseLoRegVf = 0x00000180,
	VRB2_VfDmaFec4GdlDescBaseHiRegVf = 0x00000184,
	VRB2_VfDmaFec4GdlRespPtrLoRegVf  = 0x00000188,
	VRB2_VfDmaFec4GdlRespPtrHiRegVf  = 0x0000018C,
	VRB2_VfDmaFftDescBaseLoRegVf     = 0x000001A0,
	VRB2_VfDmaFftDescBaseHiRegVf     = 0x000001A4,
	VRB2_VfDmaFftRespPtrLoRegVf      = 0x000001A8,
	VRB2_VfDmaFftRespPtrHiRegVf      = 0x000001AC,
	VRB2_VfDmaMldDescBaseLoRegVf     = 0x000001C0,
	VRB2_VfDmaMldDescBaseHiRegVf     = 0x000001C4,
	VRB2_VfDmaMldRespPtrLoRegVf      = 0x000001C8,
	VRB2_VfDmaMldRespPtrHiRegVf      = 0x000001CC,
	VRB2_VfPmACntrlRegVf             = 0x00000200,
	VRB2_VfPmACountVf                = 0x00000208,
	VRB2_VfPmAKCntLoVf               = 0x00000210,
	VRB2_VfPmAKCntHiVf               = 0x00000214,
	VRB2_VfPmADeltaCntLoVf           = 0x00000220,
	VRB2_VfPmADeltaCntHiVf           = 0x00000224,
	VRB2_VfPmBCntrlRegVf             = 0x00000240,
	VRB2_VfPmBCountVf                = 0x00000248,
	VRB2_VfPmBKCntLoVf               = 0x00000250,
	VRB2_VfPmBKCntHiVf               = 0x00000254,
	VRB2_VfPmBDeltaCntLoVf           = 0x00000260,
	VRB2_VfPmBDeltaCntHiVf           = 0x00000264,
	VRB2_VfPmCCntrlRegVf             = 0x00000280,
	VRB2_VfPmCCountVf                = 0x00000288,
	VRB2_VfPmCKCntLoVf               = 0x00000290,
	VRB2_VfPmCKCntHiVf               = 0x00000294,
	VRB2_VfPmCDeltaCntLoVf           = 0x000002A0,
	VRB2_VfPmCDeltaCntHiVf           = 0x000002A4,
	VRB2_VfPmDCntrlRegVf             = 0x000002C0,
	VRB2_VfPmDCountVf                = 0x000002C8,
	VRB2_VfPmDKCntLoVf               = 0x000002D0,
	VRB2_VfPmDKCntHiVf               = 0x000002D4,
	VRB2_VfPmDDeltaCntLoVf           = 0x000002E0,
	VRB2_VfPmDDeltaCntHiVf           = 0x000002E4,
	VRB2_VfPmECntrlRegVf             = 0x00000300,
	VRB2_VfPmECountVf                = 0x00000308,
	VRB2_VfPmEKCntLoVf               = 0x00000310,
	VRB2_VfPmEKCntHiVf               = 0x00000314,
	VRB2_VfPmEDeltaCntLoVf           = 0x00000320,
	VRB2_VfPmEDeltaCntHiVf           = 0x00000324,
	VRB2_VfPmFCntrlRegVf             = 0x00000340,
	VRB2_VfPmFCountVf                = 0x00000348,
	VRB2_VfPmFKCntLoVf               = 0x00000350,
	VRB2_VfPmFKCntHiVf               = 0x00000354,
	VRB2_VfPmFDeltaCntLoVf           = 0x00000360,
	VRB2_VfPmFDeltaCntHiVf           = 0x00000364,
	VRB2_VfQmgrAqReset0              = 0x00000600,
	VRB2_VfQmgrAqReset1              = 0x00000604,
	VRB2_VfQmgrAqReset2              = 0x00000608,
	VRB2_VfQmgrAqReset3              = 0x0000060C,
	VRB2_VfQmgrRingSizeVf            = 0x00000610,
	VRB2_VfQmgrGrpDepthLog20Vf       = 0x00000620,
	VRB2_VfQmgrGrpDepthLog21Vf       = 0x00000624,
	VRB2_VfQmgrGrpDepthLog22Vf       = 0x00000628,
	VRB2_VfQmgrGrpDepthLog23Vf       = 0x0000062C,
	VRB2_VfQmgrGrpFunction0Vf        = 0x00000630,
	VRB2_VfQmgrGrpFunction1Vf        = 0x00000634,
	VRB2_VfQmgrAramUsageN0           = 0x00000640,
	VRB2_VfQmgrAramUsageN1           = 0x00000644,
	VRB2_VfQmgrAramUsageN2           = 0x00000648,
	VRB2_VfQmgrAramUsageN3           = 0x0000064C,
	VRB2_VfHiMSIXBaseLoRegVf         = 0x00001000,
	VRB2_VfHiMSIXBaseHiRegVf         = 0x00001004,
	VRB2_VfHiMSIXBaseDataRegVf       = 0x00001008,
	VRB2_VfHiMSIXBaseMaskRegVf       = 0x0000100C,
	VRB2_VfHiMSIXPBABaseLoRegVf      = 0x00003000,
	VRB2_VfQmgrIngressAq             = 0x00004000,
};

/* TIP VF Interrupt numbers */
enum {
	VRB2_VF_INT_QMGR_AQ_OVERFLOW = 0,
	VRB2_VF_INT_DOORBELL_PF_2_VF = 1,
	VRB2_VF_INT_ILLEGAL_FORMAT = 2,
	VRB2_VF_INT_QMGR_DISABLED_ACCESS = 3,
	VRB2_VF_INT_QMGR_AQ_OVERTHRESHOLD = 4,
	VRB2_VF_INT_DMA_DL_DESC_IRQ = 5,
	VRB2_VF_INT_DMA_UL_DESC_IRQ = 6,
	VRB2_VF_INT_DMA_FFT_DESC_IRQ = 7,
	VRB2_VF_INT_DMA_UL5G_DESC_IRQ = 8,
	VRB2_VF_INT_DMA_DL5G_DESC_IRQ = 9,
	VRB2_VF_INT_DMA_MLD_DESC_IRQ = 10,
};

#endif /* VRB2_VF_ENUM_H */
