/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.fest.reflect.core.Reflection;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JToolBarIsFloatingQuery;
import org.fest.swing.driver.JToolBarLocation;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.GenericRange;
import org.fest.swing.util.Pair;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JToolBarDriver
extends JComponentDriver {
    private final JToolBarLocation location = new JToolBarLocation();

    public JToolBarDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public boolean isFloating(JToolBar toolBar) {
        return JToolBarDriver.floating(toolBar);
    }

    private static boolean floating(final JToolBar toolBar) {
        return GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return JToolBarIsFloatingQuery.isJToolBarFloating(toolBar);
            }
        });
    }

    public void makeFloat(JToolBar toolBar) {
        Pair<Point, Pair<Window, Point>> floatInfo = JToolBarDriver.floatInfo(toolBar, this.location);
        Point p = (Point)((Pair)floatInfo.ii).ii;
        this.doFloat(toolBar, p.x, p.y, floatInfo);
    }

    @RunsInEDT
    public void floatTo(JToolBar toolBar, int x, int y) {
        this.doFloat(toolBar, x, y, JToolBarDriver.floatInfo(toolBar, this.location));
    }

    @RunsInEDT
    private static Pair<Point, Pair<Window, Point>> floatInfo(final JToolBar toolBar, final JToolBarLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Point, Pair<Window, Point>>>(){

            @Override
            protected Pair<Point, Pair<Window, Point>> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(toolBar);
                JToolBarDriver.validateIsFloatable(toolBar);
                Pair windowAndLocation = JToolBarDriver.ancestorAndLocation(toolBar);
                return new Pair<Point, Pair<Window, Point>>(location.pointToGrab(toolBar), windowAndLocation);
            }
        });
    }

    @RunsInCurrentThread
    private static void validateIsFloatable(JToolBar toolBar) {
        if (!toolBar.isFloatable()) {
            throw new IllegalStateException(Strings.concat((Object[])new Object[]{"JToolbar <", Formatting.format(toolBar), "> is not floatable"}));
        }
    }

    @RunsInCurrentThread
    private static Pair<Window, Point> ancestorAndLocation(JToolBar toolBar) {
        Window window = SwingUtilities.getWindowAncestor(toolBar);
        return new Pair<Window, Point>(window, window.getLocation());
    }

    @RunsInEDT
    private void doFloat(JToolBar toolBar, int x, int y, Pair<Point, Pair<Window, Point>> floatInfo) {
        this.drag(toolBar, (Point)floatInfo.i);
        Pair locationAndAncestor = (Pair)floatInfo.ii;
        Point ancestorLocation = (Point)locationAndAncestor.ii;
        this.drop((Component)locationAndAncestor.i, new Point(x - ancestorLocation.x, y - ancestorLocation.y));
        JToolBarDriver.validateFloated(toolBar);
    }

    @RunsInEDT
    private static void validateFloated(final JToolBar toolBar) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                if (!JToolBarIsFloatingQuery.isJToolBarFloating(toolBar)) {
                    throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to float JToolbar <", Formatting.format(toolBar), ">"}));
                }
            }
        });
    }

    @RunsInEDT
    public void unfloat(JToolBar toolBar, String constraint) {
        Pair<GenericRange<Point>, Container> unfloatInfo = JToolBarDriver.unfloatInfo(toolBar, constraint, this.location);
        GenericRange fromAndTo = (GenericRange)unfloatInfo.i;
        this.drag(toolBar, (Point)fromAndTo.from);
        this.drop((Component)unfloatInfo.ii, (Point)fromAndTo.to);
        JToolBarDriver.validateIsNotFloating(toolBar, constraint);
    }

    @RunsInEDT
    private static Pair<GenericRange<Point>, Container> unfloatInfo(final JToolBar toolBar, final String constraint, final JToolBarLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Pair<GenericRange<Point>, Container>>(){

            @Override
            protected Pair<GenericRange<Point>, Container> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(toolBar);
                Container dock = JToolBarDriver.dockFor(toolBar);
                Point from = location.pointToGrab(toolBar);
                Point to = location.dockLocation(toolBar, dock, constraint);
                return new Pair<GenericRange<Point>, Container>(new GenericRange<Point>(from, to), dock);
            }
        });
    }

    @RunsInEDT
    private static void validateIsNotFloating(final JToolBar toolBar, final String constraint) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                if (JToolBarIsFloatingQuery.isJToolBarFloating(toolBar)) {
                    throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Failed to dock <", Formatting.format(toolBar), "> using constraint ", Strings.quote((String)constraint)}));
                }
            }
        });
    }

    @RunsInCurrentThread
    private static Container dockFor(JToolBar toolBar) {
        try {
            return (Container)Reflection.field((String)"dockingSource").ofType(Container.class).in((Object)toolBar.getUI()).get();
        }
        catch (RuntimeException e) {
            throw ActionFailedException.actionFailure("Unabled to determine dock for JToolBar");
        }
    }

    @RunsInEDT
    public void unfloat(JToolBar toolBar) {
        Window w = JToolBarDriver.windowAncestorOf(toolBar);
        this.robot.close(w);
    }

    @RunsInEDT
    private static Window windowAncestorOf(final JToolBar toolBar) {
        return GuiActionRunner.execute(new GuiQuery<Window>(){

            @Override
            protected Window executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(toolBar);
                return SwingUtilities.getWindowAncestor(toolBar);
            }
        });
    }
}

