/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTableCellValidator;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;

final class JTableCancelCellEditingTask {
    @RunsInEDT
    static void cancelEditing(final JTable table, final int row, final int column) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JTableCellValidator.validateIndices(table, row, column);
                JTableCellValidator.validateCellIsEditable(table, row, column);
                TableCellEditor cellEditor = table.getCellEditor(row, column);
                JTableCancelCellEditingTask.doCancelEditing(cellEditor);
            }
        });
    }

    @RunsInEDT
    static void cancelEditing(final TableCellEditor cellEditor) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                JTableCancelCellEditingTask.doCancelEditing(cellEditor);
            }
        });
    }

    private static void doCancelEditing(TableCellEditor cellEditor) {
        if (cellEditor == null) {
            return;
        }
        cellEditor.cancelCellEditing();
    }

    private JTableCancelCellEditingTask() {
    }
}

