// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/common/policy.proto

package common

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Key of the violation. The key is used for referring to a violation
// when filing an exemption request.
type PolicyViolationKey struct {
	// Unique ID of the violated policy.
	PolicyName *wrappers.StringValue `protobuf:"bytes,1,opt,name=policy_name,json=policyName,proto3" json:"policy_name,omitempty"`
	// The text that violates the policy if specified.
	// Otherwise, refers to the policy in general
	// (e.g., when requesting to be exempt from the whole policy).
	// If not specified for criterion exemptions, the whole policy is implied.
	// Must be specified for ad exemptions.
	ViolatingText        *wrappers.StringValue `protobuf:"bytes,2,opt,name=violating_text,json=violatingText,proto3" json:"violating_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PolicyViolationKey) Reset()         { *m = PolicyViolationKey{} }
func (m *PolicyViolationKey) String() string { return proto.CompactTextString(m) }
func (*PolicyViolationKey) ProtoMessage()    {}
func (*PolicyViolationKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{0}
}

func (m *PolicyViolationKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyViolationKey.Unmarshal(m, b)
}
func (m *PolicyViolationKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyViolationKey.Marshal(b, m, deterministic)
}
func (m *PolicyViolationKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyViolationKey.Merge(m, src)
}
func (m *PolicyViolationKey) XXX_Size() int {
	return xxx_messageInfo_PolicyViolationKey.Size(m)
}
func (m *PolicyViolationKey) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyViolationKey.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyViolationKey proto.InternalMessageInfo

func (m *PolicyViolationKey) GetPolicyName() *wrappers.StringValue {
	if m != nil {
		return m.PolicyName
	}
	return nil
}

func (m *PolicyViolationKey) GetViolatingText() *wrappers.StringValue {
	if m != nil {
		return m.ViolatingText
	}
	return nil
}

// Parameter for controlling how policy exemption is done. Ignorable policy
// topics are only usable with expanded text ads and responsive search ads. All
// other ad types must use policy violation keys.
type PolicyValidationParameter struct {
	// The list of policy topics that should not cause a PolicyFindingError to
	// be reported. This field is currently only compatible with Enhanced Text Ad.
	// It corresponds to the PolicyTopicEntry.topic field.
	//
	// Resources violating these policies will be saved, but will not be eligible
	// to serve. They may begin serving at a later time due to a change in
	// policies, re-review of the resource, or a change in advertiser
	// certificates.
	IgnorablePolicyTopics []*wrappers.StringValue `protobuf:"bytes,1,rep,name=ignorable_policy_topics,json=ignorablePolicyTopics,proto3" json:"ignorable_policy_topics,omitempty"`
	// The list of policy violation keys that should not cause a
	// PolicyViolationError to be reported. Not all policy violations are
	// exemptable, please refer to the is_exemptible field in the returned
	// PolicyViolationError.
	//
	// Resources violating these polices will be saved, but will not be eligible
	// to serve. They may begin serving at a later time due to a change in
	// policies, re-review of the resource, or a change in advertiser
	// certificates.
	ExemptPolicyViolationKeys []*PolicyViolationKey `protobuf:"bytes,2,rep,name=exempt_policy_violation_keys,json=exemptPolicyViolationKeys,proto3" json:"exempt_policy_violation_keys,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}              `json:"-"`
	XXX_unrecognized          []byte                `json:"-"`
	XXX_sizecache             int32                 `json:"-"`
}

func (m *PolicyValidationParameter) Reset()         { *m = PolicyValidationParameter{} }
func (m *PolicyValidationParameter) String() string { return proto.CompactTextString(m) }
func (*PolicyValidationParameter) ProtoMessage()    {}
func (*PolicyValidationParameter) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{1}
}

func (m *PolicyValidationParameter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyValidationParameter.Unmarshal(m, b)
}
func (m *PolicyValidationParameter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyValidationParameter.Marshal(b, m, deterministic)
}
func (m *PolicyValidationParameter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyValidationParameter.Merge(m, src)
}
func (m *PolicyValidationParameter) XXX_Size() int {
	return xxx_messageInfo_PolicyValidationParameter.Size(m)
}
func (m *PolicyValidationParameter) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyValidationParameter.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyValidationParameter proto.InternalMessageInfo

func (m *PolicyValidationParameter) GetIgnorablePolicyTopics() []*wrappers.StringValue {
	if m != nil {
		return m.IgnorablePolicyTopics
	}
	return nil
}

func (m *PolicyValidationParameter) GetExemptPolicyViolationKeys() []*PolicyViolationKey {
	if m != nil {
		return m.ExemptPolicyViolationKeys
	}
	return nil
}

// Policy finding attached to a resource (e.g. alcohol policy associated with
// a site that sells alcohol).
//
// Each PolicyTopicEntry has a topic that indicates the specific ads policy
// the entry is about and a type to indicate the effect that the entry will have
// on serving. It may optionally have one or more evidences that indicate the
// reason for the finding. It may also optionally have one or more constraints
// that provide details about how serving may be restricted.
type PolicyTopicEntry struct {
	// Policy topic this finding refers to. For example, "ALCOHOL",
	// "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
	// policy topics is not fixed for a particular API version and may change
	// at any time.
	Topic *wrappers.StringValue `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Describes the negative or positive effect this policy will have on serving.
	Type enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType `protobuf:"varint,2,opt,name=type,proto3,enum=google.ads.googleads.v2.enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType" json:"type,omitempty"`
	// Additional information that explains policy finding
	// (e.g. the brand name for a trademark finding).
	Evidences []*PolicyTopicEvidence `protobuf:"bytes,3,rep,name=evidences,proto3" json:"evidences,omitempty"`
	// Indicates how serving of this resource may be affected (e.g. not serving
	// in a country).
	Constraints          []*PolicyTopicConstraint `protobuf:"bytes,4,rep,name=constraints,proto3" json:"constraints,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *PolicyTopicEntry) Reset()         { *m = PolicyTopicEntry{} }
func (m *PolicyTopicEntry) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEntry) ProtoMessage()    {}
func (*PolicyTopicEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{2}
}

func (m *PolicyTopicEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEntry.Unmarshal(m, b)
}
func (m *PolicyTopicEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEntry.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEntry.Merge(m, src)
}
func (m *PolicyTopicEntry) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEntry.Size(m)
}
func (m *PolicyTopicEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEntry.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEntry proto.InternalMessageInfo

func (m *PolicyTopicEntry) GetTopic() *wrappers.StringValue {
	if m != nil {
		return m.Topic
	}
	return nil
}

func (m *PolicyTopicEntry) GetType() enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType {
	if m != nil {
		return m.Type
	}
	return enums.PolicyTopicEntryTypeEnum_UNSPECIFIED
}

func (m *PolicyTopicEntry) GetEvidences() []*PolicyTopicEvidence {
	if m != nil {
		return m.Evidences
	}
	return nil
}

func (m *PolicyTopicEntry) GetConstraints() []*PolicyTopicConstraint {
	if m != nil {
		return m.Constraints
	}
	return nil
}

// Additional information that explains a policy finding.
type PolicyTopicEvidence struct {
	// Specific evidence information depending on the evidence type.
	//
	// Types that are valid to be assigned to Value:
	//	*PolicyTopicEvidence_WebsiteList_
	//	*PolicyTopicEvidence_TextList_
	//	*PolicyTopicEvidence_LanguageCode
	//	*PolicyTopicEvidence_DestinationTextList_
	//	*PolicyTopicEvidence_DestinationMismatch_
	//	*PolicyTopicEvidence_DestinationNotWorking_
	Value                isPolicyTopicEvidence_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *PolicyTopicEvidence) Reset()         { *m = PolicyTopicEvidence{} }
func (m *PolicyTopicEvidence) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence) ProtoMessage()    {}
func (*PolicyTopicEvidence) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{3}
}

func (m *PolicyTopicEvidence) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEvidence) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence.Merge(m, src)
}
func (m *PolicyTopicEvidence) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence.Size(m)
}
func (m *PolicyTopicEvidence) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence proto.InternalMessageInfo

type isPolicyTopicEvidence_Value interface {
	isPolicyTopicEvidence_Value()
}

type PolicyTopicEvidence_WebsiteList_ struct {
	WebsiteList *PolicyTopicEvidence_WebsiteList `protobuf:"bytes,3,opt,name=website_list,json=websiteList,proto3,oneof"`
}

type PolicyTopicEvidence_TextList_ struct {
	TextList *PolicyTopicEvidence_TextList `protobuf:"bytes,4,opt,name=text_list,json=textList,proto3,oneof"`
}

type PolicyTopicEvidence_LanguageCode struct {
	LanguageCode *wrappers.StringValue `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3,oneof"`
}

type PolicyTopicEvidence_DestinationTextList_ struct {
	DestinationTextList *PolicyTopicEvidence_DestinationTextList `protobuf:"bytes,6,opt,name=destination_text_list,json=destinationTextList,proto3,oneof"`
}

type PolicyTopicEvidence_DestinationMismatch_ struct {
	DestinationMismatch *PolicyTopicEvidence_DestinationMismatch `protobuf:"bytes,7,opt,name=destination_mismatch,json=destinationMismatch,proto3,oneof"`
}

type PolicyTopicEvidence_DestinationNotWorking_ struct {
	DestinationNotWorking *PolicyTopicEvidence_DestinationNotWorking `protobuf:"bytes,8,opt,name=destination_not_working,json=destinationNotWorking,proto3,oneof"`
}

func (*PolicyTopicEvidence_WebsiteList_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_TextList_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_LanguageCode) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_DestinationTextList_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_DestinationMismatch_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_DestinationNotWorking_) isPolicyTopicEvidence_Value() {}

func (m *PolicyTopicEvidence) GetValue() isPolicyTopicEvidence_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *PolicyTopicEvidence) GetWebsiteList() *PolicyTopicEvidence_WebsiteList {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_WebsiteList_); ok {
		return x.WebsiteList
	}
	return nil
}

func (m *PolicyTopicEvidence) GetTextList() *PolicyTopicEvidence_TextList {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_TextList_); ok {
		return x.TextList
	}
	return nil
}

func (m *PolicyTopicEvidence) GetLanguageCode() *wrappers.StringValue {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_LanguageCode); ok {
		return x.LanguageCode
	}
	return nil
}

func (m *PolicyTopicEvidence) GetDestinationTextList() *PolicyTopicEvidence_DestinationTextList {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_DestinationTextList_); ok {
		return x.DestinationTextList
	}
	return nil
}

func (m *PolicyTopicEvidence) GetDestinationMismatch() *PolicyTopicEvidence_DestinationMismatch {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_DestinationMismatch_); ok {
		return x.DestinationMismatch
	}
	return nil
}

func (m *PolicyTopicEvidence) GetDestinationNotWorking() *PolicyTopicEvidence_DestinationNotWorking {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_DestinationNotWorking_); ok {
		return x.DestinationNotWorking
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PolicyTopicEvidence) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PolicyTopicEvidence_WebsiteList_)(nil),
		(*PolicyTopicEvidence_TextList_)(nil),
		(*PolicyTopicEvidence_LanguageCode)(nil),
		(*PolicyTopicEvidence_DestinationTextList_)(nil),
		(*PolicyTopicEvidence_DestinationMismatch_)(nil),
		(*PolicyTopicEvidence_DestinationNotWorking_)(nil),
	}
}

// A list of fragments of text that violated a policy.
type PolicyTopicEvidence_TextList struct {
	// The fragments of text from the resource that caused the policy finding.
	Texts                []*wrappers.StringValue `protobuf:"bytes,1,rep,name=texts,proto3" json:"texts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PolicyTopicEvidence_TextList) Reset()         { *m = PolicyTopicEvidence_TextList{} }
func (m *PolicyTopicEvidence_TextList) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_TextList) ProtoMessage()    {}
func (*PolicyTopicEvidence_TextList) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{3, 0}
}

func (m *PolicyTopicEvidence_TextList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_TextList.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_TextList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_TextList.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEvidence_TextList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_TextList.Merge(m, src)
}
func (m *PolicyTopicEvidence_TextList) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_TextList.Size(m)
}
func (m *PolicyTopicEvidence_TextList) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_TextList.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_TextList proto.InternalMessageInfo

func (m *PolicyTopicEvidence_TextList) GetTexts() []*wrappers.StringValue {
	if m != nil {
		return m.Texts
	}
	return nil
}

// A list of websites that caused a policy finding. Used for
// ONE_WEBSITE_PER_AD_GROUP policy topic, for example. In case there are more
// than five websites, only the top five (those that appear in resources the
// most) will be listed here.
type PolicyTopicEvidence_WebsiteList struct {
	// Websites that caused the policy finding.
	Websites             []*wrappers.StringValue `protobuf:"bytes,1,rep,name=websites,proto3" json:"websites,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PolicyTopicEvidence_WebsiteList) Reset()         { *m = PolicyTopicEvidence_WebsiteList{} }
func (m *PolicyTopicEvidence_WebsiteList) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_WebsiteList) ProtoMessage()    {}
func (*PolicyTopicEvidence_WebsiteList) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{3, 1}
}

func (m *PolicyTopicEvidence_WebsiteList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_WebsiteList.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_WebsiteList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_WebsiteList.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEvidence_WebsiteList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_WebsiteList.Merge(m, src)
}
func (m *PolicyTopicEvidence_WebsiteList) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_WebsiteList.Size(m)
}
func (m *PolicyTopicEvidence_WebsiteList) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_WebsiteList.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_WebsiteList proto.InternalMessageInfo

func (m *PolicyTopicEvidence_WebsiteList) GetWebsites() []*wrappers.StringValue {
	if m != nil {
		return m.Websites
	}
	return nil
}

// A list of strings found in a destination page that caused a policy
// finding.
type PolicyTopicEvidence_DestinationTextList struct {
	// List of text found in the resource's destination page.
	DestinationTexts     []*wrappers.StringValue `protobuf:"bytes,1,rep,name=destination_texts,json=destinationTexts,proto3" json:"destination_texts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PolicyTopicEvidence_DestinationTextList) Reset() {
	*m = PolicyTopicEvidence_DestinationTextList{}
}
func (m *PolicyTopicEvidence_DestinationTextList) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_DestinationTextList) ProtoMessage()    {}
func (*PolicyTopicEvidence_DestinationTextList) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{3, 2}
}

func (m *PolicyTopicEvidence_DestinationTextList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_DestinationTextList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEvidence_DestinationTextList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.Merge(m, src)
}
func (m *PolicyTopicEvidence_DestinationTextList) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.Size(m)
}
func (m *PolicyTopicEvidence_DestinationTextList) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_DestinationTextList proto.InternalMessageInfo

func (m *PolicyTopicEvidence_DestinationTextList) GetDestinationTexts() []*wrappers.StringValue {
	if m != nil {
		return m.DestinationTexts
	}
	return nil
}

// Evidence of mismatches between the URLs of a resource.
type PolicyTopicEvidence_DestinationMismatch struct {
	// The set of URLs that did not match each other.
	UrlTypes             []enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType `protobuf:"varint,1,rep,packed,name=url_types,json=urlTypes,proto3,enum=google.ads.googleads.v2.enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType" json:"url_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                                                                `json:"-"`
	XXX_unrecognized     []byte                                                                                                  `json:"-"`
	XXX_sizecache        int32                                                                                                   `json:"-"`
}

func (m *PolicyTopicEvidence_DestinationMismatch) Reset() {
	*m = PolicyTopicEvidence_DestinationMismatch{}
}
func (m *PolicyTopicEvidence_DestinationMismatch) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_DestinationMismatch) ProtoMessage()    {}
func (*PolicyTopicEvidence_DestinationMismatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{3, 3}
}

func (m *PolicyTopicEvidence_DestinationMismatch) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_DestinationMismatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEvidence_DestinationMismatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.Merge(m, src)
}
func (m *PolicyTopicEvidence_DestinationMismatch) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.Size(m)
}
func (m *PolicyTopicEvidence_DestinationMismatch) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch proto.InternalMessageInfo

func (m *PolicyTopicEvidence_DestinationMismatch) GetUrlTypes() []enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType {
	if m != nil {
		return m.UrlTypes
	}
	return nil
}

// Evidence details when the destination is returning an HTTP error
// code or isn't functional in all locations for commonly used devices.
type PolicyTopicEvidence_DestinationNotWorking struct {
	// The full URL that didn't work.
	ExpandedUrl *wrappers.StringValue `protobuf:"bytes,3,opt,name=expanded_url,json=expandedUrl,proto3" json:"expanded_url,omitempty"`
	// The type of device that failed to load the URL.
	Device enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_PolicyTopicEvidenceDestinationNotWorkingDevice `protobuf:"varint,4,opt,name=device,proto3,enum=google.ads.googleads.v2.enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_PolicyTopicEvidenceDestinationNotWorkingDevice" json:"device,omitempty"`
	// The time the URL was last checked.
	// The format is "YYYY-MM-DD HH:MM:SS".
	// Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
	LastCheckedDateTime *wrappers.StringValue `protobuf:"bytes,5,opt,name=last_checked_date_time,json=lastCheckedDateTime,proto3" json:"last_checked_date_time,omitempty"`
	// Indicates the reason of the DESTINATION_NOT_WORKING policy finding.
	//
	// Types that are valid to be assigned to Reason:
	//	*PolicyTopicEvidence_DestinationNotWorking_DnsErrorType
	//	*PolicyTopicEvidence_DestinationNotWorking_HttpErrorCode
	Reason               isPolicyTopicEvidence_DestinationNotWorking_Reason `protobuf_oneof:"reason"`
	XXX_NoUnkeyedLiteral struct{}                                           `json:"-"`
	XXX_unrecognized     []byte                                             `json:"-"`
	XXX_sizecache        int32                                              `json:"-"`
}

func (m *PolicyTopicEvidence_DestinationNotWorking) Reset() {
	*m = PolicyTopicEvidence_DestinationNotWorking{}
}
func (m *PolicyTopicEvidence_DestinationNotWorking) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_DestinationNotWorking) ProtoMessage()    {}
func (*PolicyTopicEvidence_DestinationNotWorking) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{3, 4}
}

func (m *PolicyTopicEvidence_DestinationNotWorking) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationNotWorking.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_DestinationNotWorking) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationNotWorking.Marshal(b, m, deterministic)
}
func (m *PolicyTopicEvidence_DestinationNotWorking) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_DestinationNotWorking.Merge(m, src)
}
func (m *PolicyTopicEvidence_DestinationNotWorking) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationNotWorking.Size(m)
}
func (m *PolicyTopicEvidence_DestinationNotWorking) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_DestinationNotWorking.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_DestinationNotWorking proto.InternalMessageInfo

func (m *PolicyTopicEvidence_DestinationNotWorking) GetExpandedUrl() *wrappers.StringValue {
	if m != nil {
		return m.ExpandedUrl
	}
	return nil
}

func (m *PolicyTopicEvidence_DestinationNotWorking) GetDevice() enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_PolicyTopicEvidenceDestinationNotWorkingDevice {
	if m != nil {
		return m.Device
	}
	return enums.PolicyTopicEvidenceDestinationNotWorkingDeviceEnum_UNSPECIFIED
}

func (m *PolicyTopicEvidence_DestinationNotWorking) GetLastCheckedDateTime() *wrappers.StringValue {
	if m != nil {
		return m.LastCheckedDateTime
	}
	return nil
}

type isPolicyTopicEvidence_DestinationNotWorking_Reason interface {
	isPolicyTopicEvidence_DestinationNotWorking_Reason()
}

type PolicyTopicEvidence_DestinationNotWorking_DnsErrorType struct {
	DnsErrorType enums.PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum_PolicyTopicEvidenceDestinationNotWorkingDnsErrorType `protobuf:"varint,1,opt,name=dns_error_type,json=dnsErrorType,proto3,enum=google.ads.googleads.v2.enums.PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum_PolicyTopicEvidenceDestinationNotWorkingDnsErrorType,oneof"`
}

type PolicyTopicEvidence_DestinationNotWorking_HttpErrorCode struct {
	HttpErrorCode *wrappers.Int64Value `protobuf:"bytes,2,opt,name=http_error_code,json=httpErrorCode,proto3,oneof"`
}

func (*PolicyTopicEvidence_DestinationNotWorking_DnsErrorType) isPolicyTopicEvidence_DestinationNotWorking_Reason() {
}

func (*PolicyTopicEvidence_DestinationNotWorking_HttpErrorCode) isPolicyTopicEvidence_DestinationNotWorking_Reason() {
}

func (m *PolicyTopicEvidence_DestinationNotWorking) GetReason() isPolicyTopicEvidence_DestinationNotWorking_Reason {
	if m != nil {
		return m.Reason
	}
	return nil
}

func (m *PolicyTopicEvidence_DestinationNotWorking) GetDnsErrorType() enums.PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum_PolicyTopicEvidenceDestinationNotWorkingDnsErrorType {
	if x, ok := m.GetReason().(*PolicyTopicEvidence_DestinationNotWorking_DnsErrorType); ok {
		return x.DnsErrorType
	}
	return enums.PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum_UNSPECIFIED
}

func (m *PolicyTopicEvidence_DestinationNotWorking) GetHttpErrorCode() *wrappers.Int64Value {
	if x, ok := m.GetReason().(*PolicyTopicEvidence_DestinationNotWorking_HttpErrorCode); ok {
		return x.HttpErrorCode
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PolicyTopicEvidence_DestinationNotWorking) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PolicyTopicEvidence_DestinationNotWorking_DnsErrorType)(nil),
		(*PolicyTopicEvidence_DestinationNotWorking_HttpErrorCode)(nil),
	}
}

// Describes the effect on serving that a policy topic entry will have.
type PolicyTopicConstraint struct {
	// Specific information about the constraint.
	//
	// Types that are valid to be assigned to Value:
	//	*PolicyTopicConstraint_CountryConstraintList_
	//	*PolicyTopicConstraint_ResellerConstraint_
	//	*PolicyTopicConstraint_CertificateMissingInCountryList
	//	*PolicyTopicConstraint_CertificateDomainMismatchInCountryList
	Value                isPolicyTopicConstraint_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *PolicyTopicConstraint) Reset()         { *m = PolicyTopicConstraint{} }
func (m *PolicyTopicConstraint) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicConstraint) ProtoMessage()    {}
func (*PolicyTopicConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{4}
}

func (m *PolicyTopicConstraint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicConstraint.Unmarshal(m, b)
}
func (m *PolicyTopicConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicConstraint.Marshal(b, m, deterministic)
}
func (m *PolicyTopicConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicConstraint.Merge(m, src)
}
func (m *PolicyTopicConstraint) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicConstraint.Size(m)
}
func (m *PolicyTopicConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicConstraint proto.InternalMessageInfo

type isPolicyTopicConstraint_Value interface {
	isPolicyTopicConstraint_Value()
}

type PolicyTopicConstraint_CountryConstraintList_ struct {
	CountryConstraintList *PolicyTopicConstraint_CountryConstraintList `protobuf:"bytes,1,opt,name=country_constraint_list,json=countryConstraintList,proto3,oneof"`
}

type PolicyTopicConstraint_ResellerConstraint_ struct {
	ResellerConstraint *PolicyTopicConstraint_ResellerConstraint `protobuf:"bytes,2,opt,name=reseller_constraint,json=resellerConstraint,proto3,oneof"`
}

type PolicyTopicConstraint_CertificateMissingInCountryList struct {
	CertificateMissingInCountryList *PolicyTopicConstraint_CountryConstraintList `protobuf:"bytes,3,opt,name=certificate_missing_in_country_list,json=certificateMissingInCountryList,proto3,oneof"`
}

type PolicyTopicConstraint_CertificateDomainMismatchInCountryList struct {
	CertificateDomainMismatchInCountryList *PolicyTopicConstraint_CountryConstraintList `protobuf:"bytes,4,opt,name=certificate_domain_mismatch_in_country_list,json=certificateDomainMismatchInCountryList,proto3,oneof"`
}

func (*PolicyTopicConstraint_CountryConstraintList_) isPolicyTopicConstraint_Value() {}

func (*PolicyTopicConstraint_ResellerConstraint_) isPolicyTopicConstraint_Value() {}

func (*PolicyTopicConstraint_CertificateMissingInCountryList) isPolicyTopicConstraint_Value() {}

func (*PolicyTopicConstraint_CertificateDomainMismatchInCountryList) isPolicyTopicConstraint_Value() {}

func (m *PolicyTopicConstraint) GetValue() isPolicyTopicConstraint_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *PolicyTopicConstraint) GetCountryConstraintList() *PolicyTopicConstraint_CountryConstraintList {
	if x, ok := m.GetValue().(*PolicyTopicConstraint_CountryConstraintList_); ok {
		return x.CountryConstraintList
	}
	return nil
}

func (m *PolicyTopicConstraint) GetResellerConstraint() *PolicyTopicConstraint_ResellerConstraint {
	if x, ok := m.GetValue().(*PolicyTopicConstraint_ResellerConstraint_); ok {
		return x.ResellerConstraint
	}
	return nil
}

func (m *PolicyTopicConstraint) GetCertificateMissingInCountryList() *PolicyTopicConstraint_CountryConstraintList {
	if x, ok := m.GetValue().(*PolicyTopicConstraint_CertificateMissingInCountryList); ok {
		return x.CertificateMissingInCountryList
	}
	return nil
}

func (m *PolicyTopicConstraint) GetCertificateDomainMismatchInCountryList() *PolicyTopicConstraint_CountryConstraintList {
	if x, ok := m.GetValue().(*PolicyTopicConstraint_CertificateDomainMismatchInCountryList); ok {
		return x.CertificateDomainMismatchInCountryList
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PolicyTopicConstraint) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PolicyTopicConstraint_CountryConstraintList_)(nil),
		(*PolicyTopicConstraint_ResellerConstraint_)(nil),
		(*PolicyTopicConstraint_CertificateMissingInCountryList)(nil),
		(*PolicyTopicConstraint_CertificateDomainMismatchInCountryList)(nil),
	}
}

// A list of countries where a resource's serving is constrained.
type PolicyTopicConstraint_CountryConstraintList struct {
	// Total number of countries targeted by the resource.
	TotalTargetedCountries *wrappers.Int32Value `protobuf:"bytes,1,opt,name=total_targeted_countries,json=totalTargetedCountries,proto3" json:"total_targeted_countries,omitempty"`
	// Countries in which serving is restricted.
	Countries            []*PolicyTopicConstraint_CountryConstraint `protobuf:"bytes,2,rep,name=countries,proto3" json:"countries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *PolicyTopicConstraint_CountryConstraintList) Reset() {
	*m = PolicyTopicConstraint_CountryConstraintList{}
}
func (m *PolicyTopicConstraint_CountryConstraintList) String() string {
	return proto.CompactTextString(m)
}
func (*PolicyTopicConstraint_CountryConstraintList) ProtoMessage() {}
func (*PolicyTopicConstraint_CountryConstraintList) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{4, 0}
}

func (m *PolicyTopicConstraint_CountryConstraintList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.Unmarshal(m, b)
}
func (m *PolicyTopicConstraint_CountryConstraintList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.Marshal(b, m, deterministic)
}
func (m *PolicyTopicConstraint_CountryConstraintList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.Merge(m, src)
}
func (m *PolicyTopicConstraint_CountryConstraintList) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.Size(m)
}
func (m *PolicyTopicConstraint_CountryConstraintList) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList proto.InternalMessageInfo

func (m *PolicyTopicConstraint_CountryConstraintList) GetTotalTargetedCountries() *wrappers.Int32Value {
	if m != nil {
		return m.TotalTargetedCountries
	}
	return nil
}

func (m *PolicyTopicConstraint_CountryConstraintList) GetCountries() []*PolicyTopicConstraint_CountryConstraint {
	if m != nil {
		return m.Countries
	}
	return nil
}

// Indicates that a policy topic was constrained due to disapproval of the
// website for reseller purposes.
type PolicyTopicConstraint_ResellerConstraint struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PolicyTopicConstraint_ResellerConstraint) Reset() {
	*m = PolicyTopicConstraint_ResellerConstraint{}
}
func (m *PolicyTopicConstraint_ResellerConstraint) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicConstraint_ResellerConstraint) ProtoMessage()    {}
func (*PolicyTopicConstraint_ResellerConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{4, 1}
}

func (m *PolicyTopicConstraint_ResellerConstraint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.Unmarshal(m, b)
}
func (m *PolicyTopicConstraint_ResellerConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.Marshal(b, m, deterministic)
}
func (m *PolicyTopicConstraint_ResellerConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.Merge(m, src)
}
func (m *PolicyTopicConstraint_ResellerConstraint) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.Size(m)
}
func (m *PolicyTopicConstraint_ResellerConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint proto.InternalMessageInfo

// Indicates that a resource's ability to serve in a particular country is
// constrained.
type PolicyTopicConstraint_CountryConstraint struct {
	// Geo target constant resource name of the country in which serving is
	// constrained.
	CountryCriterion     *wrappers.StringValue `protobuf:"bytes,1,opt,name=country_criterion,json=countryCriterion,proto3" json:"country_criterion,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PolicyTopicConstraint_CountryConstraint) Reset() {
	*m = PolicyTopicConstraint_CountryConstraint{}
}
func (m *PolicyTopicConstraint_CountryConstraint) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicConstraint_CountryConstraint) ProtoMessage()    {}
func (*PolicyTopicConstraint_CountryConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d59a9c11d6f3bf2, []int{4, 2}
}

func (m *PolicyTopicConstraint_CountryConstraint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.Unmarshal(m, b)
}
func (m *PolicyTopicConstraint_CountryConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.Marshal(b, m, deterministic)
}
func (m *PolicyTopicConstraint_CountryConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.Merge(m, src)
}
func (m *PolicyTopicConstraint_CountryConstraint) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.Size(m)
}
func (m *PolicyTopicConstraint_CountryConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicConstraint_CountryConstraint proto.InternalMessageInfo

func (m *PolicyTopicConstraint_CountryConstraint) GetCountryCriterion() *wrappers.StringValue {
	if m != nil {
		return m.CountryCriterion
	}
	return nil
}

func init() {
	proto.RegisterType((*PolicyViolationKey)(nil), "google.ads.googleads.v2.common.PolicyViolationKey")
	proto.RegisterType((*PolicyValidationParameter)(nil), "google.ads.googleads.v2.common.PolicyValidationParameter")
	proto.RegisterType((*PolicyTopicEntry)(nil), "google.ads.googleads.v2.common.PolicyTopicEntry")
	proto.RegisterType((*PolicyTopicEvidence)(nil), "google.ads.googleads.v2.common.PolicyTopicEvidence")
	proto.RegisterType((*PolicyTopicEvidence_TextList)(nil), "google.ads.googleads.v2.common.PolicyTopicEvidence.TextList")
	proto.RegisterType((*PolicyTopicEvidence_WebsiteList)(nil), "google.ads.googleads.v2.common.PolicyTopicEvidence.WebsiteList")
	proto.RegisterType((*PolicyTopicEvidence_DestinationTextList)(nil), "google.ads.googleads.v2.common.PolicyTopicEvidence.DestinationTextList")
	proto.RegisterType((*PolicyTopicEvidence_DestinationMismatch)(nil), "google.ads.googleads.v2.common.PolicyTopicEvidence.DestinationMismatch")
	proto.RegisterType((*PolicyTopicEvidence_DestinationNotWorking)(nil), "google.ads.googleads.v2.common.PolicyTopicEvidence.DestinationNotWorking")
	proto.RegisterType((*PolicyTopicConstraint)(nil), "google.ads.googleads.v2.common.PolicyTopicConstraint")
	proto.RegisterType((*PolicyTopicConstraint_CountryConstraintList)(nil), "google.ads.googleads.v2.common.PolicyTopicConstraint.CountryConstraintList")
	proto.RegisterType((*PolicyTopicConstraint_ResellerConstraint)(nil), "google.ads.googleads.v2.common.PolicyTopicConstraint.ResellerConstraint")
	proto.RegisterType((*PolicyTopicConstraint_CountryConstraint)(nil), "google.ads.googleads.v2.common.PolicyTopicConstraint.CountryConstraint")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/common/policy.proto", fileDescriptor_4d59a9c11d6f3bf2)
}

var fileDescriptor_4d59a9c11d6f3bf2 = []byte{
	// 1227 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0x5d, 0x6f, 0x23, 0x35,
	0x17, 0xee, 0xa4, 0x5f, 0xa9, 0xd3, 0xe6, 0xed, 0xba, 0x9b, 0x6d, 0x36, 0x6f, 0xb5, 0xac, 0x82,
	0x84, 0x90, 0x56, 0x9a, 0x48, 0x53, 0x40, 0x28, 0x0b, 0xac, 0xda, 0xb4, 0x6a, 0xab, 0xfd, 0x50,
	0x77, 0x48, 0x5b, 0x04, 0x15, 0x53, 0x77, 0xc6, 0x3b, 0xb5, 0x3a, 0x63, 0x8f, 0x6c, 0x27, 0x6d,
	0xc4, 0x87, 0x90, 0x10, 0x77, 0xfc, 0x00, 0x10, 0xe2, 0x86, 0xcb, 0xbd, 0x45, 0xdc, 0xf2, 0x03,
	0xb8, 0xe2, 0x02, 0xfe, 0xc2, 0x5e, 0xf0, 0x2b, 0xd0, 0xd8, 0x33, 0xc9, 0x34, 0x49, 0xb7, 0xe9,
	0x07, 0x57, 0x71, 0xec, 0xf3, 0x3c, 0xe7, 0xf1, 0xf1, 0xf1, 0xf1, 0x19, 0xf0, 0xc0, 0x67, 0xcc,
	0x0f, 0x70, 0x0d, 0x79, 0xa2, 0xa6, 0x87, 0xf1, 0xa8, 0x6d, 0xd5, 0x5c, 0x16, 0x86, 0x8c, 0xd6,
	0x22, 0x16, 0x10, 0xb7, 0x63, 0x46, 0x9c, 0x49, 0x06, 0xef, 0x69, 0x0b, 0x13, 0x79, 0xc2, 0xec,
	0x1a, 0x9b, 0x6d, 0xcb, 0xd4, 0xc6, 0x95, 0x87, 0xe7, 0x91, 0x61, 0xda, 0x0a, 0x45, 0xc2, 0xe5,
	0x48, 0x16, 0x11, 0xd7, 0xc1, 0x54, 0xf2, 0x8e, 0x23, 0x3b, 0x11, 0xd6, 0xe4, 0x95, 0xbd, 0xcb,
	0x80, 0xdb, 0xc4, 0xc3, 0xd4, 0xc5, 0x8e, 0x87, 0x85, 0x24, 0x14, 0x49, 0xc2, 0xa8, 0x13, 0x12,
	0x11, 0x22, 0xe9, 0x1e, 0x39, 0x2d, 0x1e, 0x64, 0x89, 0x3f, 0xb9, 0x2e, 0x31, 0x65, 0xd2, 0x39,
	0x61, 0xfc, 0x98, 0x50, 0xdf, 0xf1, 0x70, 0x9b, 0xb8, 0x29, 0xf3, 0xc1, 0x8d, 0x32, 0x53, 0xe1,
	0x60, 0xce, 0x19, 0xcf, 0x6a, 0x4f, 0x22, 0x5e, 0x53, 0xff, 0x0e, 0x5b, 0x2f, 0x6a, 0x27, 0x1c,
	0x45, 0x11, 0xe6, 0x22, 0x59, 0x5f, 0x4a, 0x15, 0x44, 0xa4, 0x86, 0x28, 0x65, 0x52, 0xf1, 0x26,
	0xab, 0xd5, 0x1f, 0x0c, 0x00, 0xb7, 0x95, 0x88, 0x5d, 0xc2, 0x02, 0xb5, 0xf4, 0x18, 0x77, 0xe0,
	0x87, 0xa0, 0x90, 0x48, 0xa3, 0x28, 0xc4, 0x65, 0xe3, 0xbe, 0xf1, 0x76, 0xc1, 0x5a, 0x4a, 0x4e,
	0xd4, 0x4c, 0x5d, 0x99, 0x1f, 0x4b, 0x4e, 0xa8, 0xbf, 0x8b, 0x82, 0x16, 0xb6, 0x81, 0x06, 0x3c,
	0x43, 0x21, 0x86, 0x0d, 0x50, 0x6c, 0x6b, 0x3a, 0xea, 0x3b, 0x12, 0x9f, 0xca, 0x72, 0x6e, 0x04,
	0x86, 0xb9, 0x2e, 0xa6, 0x89, 0x4f, 0x65, 0xf5, 0x95, 0x01, 0xee, 0x26, 0xd2, 0x50, 0x40, 0x3c,
	0xa5, 0x6d, 0x1b, 0x71, 0x14, 0x62, 0x89, 0x39, 0x6c, 0x82, 0x45, 0xe2, 0x53, 0xc6, 0xd1, 0x61,
	0x80, 0x9d, 0x6c, 0x18, 0x45, 0xd9, 0xb8, 0x3f, 0x7e, 0xa1, 0xaf, 0x52, 0x17, 0xac, 0x5d, 0x34,
	0x15, 0x14, 0x0a, 0xb0, 0x84, 0x4f, 0x71, 0x18, 0xc9, 0x94, 0xb2, 0x9d, 0x46, 0xc5, 0x39, 0xc6,
	0x1d, 0x51, 0xce, 0x29, 0x6a, 0xcb, 0x7c, 0x7d, 0x96, 0x9b, 0x83, 0x11, 0xb5, 0xef, 0x6a, 0xde,
	0xc1, 0x15, 0x51, 0xfd, 0x2b, 0x07, 0xe6, 0x33, 0x2a, 0xd6, 0xe3, 0xb4, 0x87, 0x16, 0x98, 0x54,
	0xdb, 0x19, 0x29, 0xf6, 0xda, 0x14, 0x1e, 0x80, 0x89, 0x38, 0x31, 0x54, 0xb0, 0x8b, 0xd6, 0x93,
	0x73, 0x55, 0xaa, 0xdc, 0x33, 0xfb, 0x5d, 0x36, 0x3b, 0x11, 0x5e, 0xa7, 0xad, 0x70, 0xe8, 0x82,
	0xad, 0x98, 0xe1, 0x73, 0x30, 0x93, 0x66, 0xa9, 0x28, 0x8f, 0xab, 0x60, 0x2c, 0x8f, 0x16, 0x0c,
	0x4d, 0x97, 0x60, 0xed, 0x1e, 0x0b, 0xdc, 0x03, 0x05, 0x97, 0x51, 0x21, 0x39, 0x22, 0x54, 0x8a,
	0xf2, 0x84, 0x22, 0x7d, 0xf7, 0x12, 0xa4, 0x8d, 0x2e, 0xda, 0xce, 0x32, 0x55, 0x7f, 0x9e, 0x03,
	0x0b, 0x43, 0x7c, 0x43, 0x0f, 0xcc, 0x9e, 0xe0, 0x43, 0x41, 0x24, 0x76, 0x02, 0x22, 0x64, 0x79,
	0x5c, 0x05, 0xf8, 0xd1, 0x15, 0xb6, 0x61, 0xee, 0x69, 0x9e, 0x27, 0x44, 0xc8, 0xcd, 0x31, 0xbb,
	0x70, 0xd2, 0xfb, 0x0b, 0x3f, 0x03, 0x33, 0x71, 0xe2, 0x6b, 0x17, 0x13, 0xca, 0xc5, 0x07, 0x57,
	0x71, 0x11, 0x5f, 0x85, 0x84, 0x3f, 0x2f, 0x93, 0x31, 0x6c, 0x80, 0xb9, 0x00, 0x51, 0xbf, 0x85,
	0x7c, 0xec, 0xb8, 0xcc, 0xc3, 0xe5, 0xc9, 0x8b, 0x93, 0x64, 0x73, 0xcc, 0x9e, 0x4d, 0x41, 0x0d,
	0xe6, 0x61, 0xf8, 0x15, 0x28, 0x65, 0x0b, 0x4d, 0x4f, 0xed, 0x94, 0x22, 0xdb, 0xb8, 0x8a, 0xda,
	0xb5, 0x1e, 0x61, 0x46, 0xf8, 0x82, 0x37, 0x38, 0x0d, 0xbf, 0x04, 0xb7, 0x87, 0x95, 0xe6, 0xf2,
	0xf4, 0x8d, 0x78, 0x7f, 0x9a, 0xd0, 0xf5, 0x79, 0x4f, 0xa7, 0xe1, 0xb7, 0x06, 0x58, 0x3c, 0xa7,
	0xcc, 0x96, 0xf3, 0x4a, 0xc1, 0xd6, 0x35, 0x15, 0x3c, 0x63, 0x72, 0x4f, 0x13, 0x6e, 0x8e, 0xd9,
	0xd9, 0x48, 0xf7, 0x16, 0x2a, 0x1f, 0x81, 0x7c, 0x37, 0x1e, 0xf1, 0x85, 0xc7, 0xa7, 0x72, 0xb4,
	0xf2, 0xa5, 0x4d, 0x2b, 0x1b, 0xa0, 0x90, 0x49, 0x41, 0xf8, 0x3e, 0xc8, 0x27, 0x29, 0x38, 0x1a,
	0x4b, 0xd7, 0xba, 0x72, 0x00, 0x16, 0x86, 0x1c, 0x1d, 0xdc, 0x02, 0xb7, 0xfa, 0x53, 0x64, 0x34,
	0xe6, 0xf9, 0xbe, 0x13, 0x17, 0x95, 0x5f, 0x8d, 0x33, 0x2e, 0xba, 0x07, 0xf1, 0x93, 0x01, 0x66,
	0xd2, 0xd7, 0x58, 0x73, 0x17, 0xad, 0xaf, 0x2f, 0x51, 0xb9, 0x92, 0xc8, 0x0f, 0xa1, 0xde, 0xe1,
	0xc1, 0xd0, 0x92, 0x76, 0x21, 0xc2, 0xce, 0xb7, 0xf4, 0x40, 0x54, 0xfe, 0x9c, 0x00, 0xa5, 0xa1,
	0x67, 0x0a, 0x1f, 0x81, 0x59, 0x7c, 0x1a, 0x21, 0xea, 0x61, 0x2f, 0xee, 0x26, 0x92, 0x2a, 0xf2,
	0xfa, 0xa8, 0x14, 0x52, 0xc4, 0x0e, 0x0f, 0xe0, 0x8f, 0x06, 0x98, 0xd2, 0xad, 0x82, 0x2a, 0x0f,
	0x45, 0xeb, 0x1b, 0xe3, 0x5a, 0xdb, 0xee, 0x69, 0x5b, 0x53, 0xac, 0x23, 0xec, 0xbb, 0x1f, 0x62,
	0x27, 0x82, 0xe0, 0x73, 0x70, 0x27, 0x40, 0x42, 0x3a, 0xee, 0x11, 0x76, 0x8f, 0xb1, 0xe7, 0x78,
	0x48, 0x62, 0x47, 0x92, 0x70, 0xa4, 0x42, 0x63, 0x2f, 0xc4, 0xd8, 0x86, 0x86, 0xae, 0x21, 0x89,
	0x9b, 0x24, 0xc4, 0xf0, 0x37, 0x03, 0x14, 0xcf, 0xf6, 0x2f, 0xea, 0x65, 0x2b, 0x5a, 0xdf, 0xdf,
	0xd8, 0xb6, 0xa9, 0x58, 0x8f, 0xc9, 0x47, 0x3c, 0xf4, 0xe1, 0xc0, 0xb8, 0x4a, 0x7a, 0x99, 0xff,
	0x70, 0x1d, 0xfc, 0xef, 0x48, 0xca, 0x28, 0xd1, 0xad, 0x8a, 0xad, 0xee, 0x65, 0xfe, 0x3f, 0x10,
	0x83, 0x2d, 0x2a, 0xdf, 0x7b, 0x27, 0xad, 0xb5, 0x73, 0x31, 0x4a, 0xd1, 0xc4, 0xc5, 0x76, 0x35,
	0x0f, 0xa6, 0x38, 0x46, 0x82, 0xd1, 0xd5, 0x69, 0x30, 0xd9, 0x8e, 0x6d, 0xaa, 0xbf, 0x4f, 0x83,
	0xd2, 0xd0, 0x67, 0x0c, 0x7e, 0x67, 0x80, 0x45, 0x97, 0xb5, 0x54, 0xfb, 0xdb, 0x7b, 0xd1, 0x74,
	0x71, 0xd6, 0xed, 0xc0, 0xe3, 0x2b, 0xbd, 0x8f, 0x66, 0x43, 0x93, 0xf6, 0x66, 0x92, 0x02, 0x5d,
	0x72, 0x87, 0x2d, 0xc0, 0x2f, 0xc0, 0x02, 0xc7, 0x02, 0x07, 0x01, 0xe6, 0x19, 0x1d, 0xc9, 0xfe,
	0x37, 0xaf, 0x26, 0xc1, 0x4e, 0x08, 0x7b, 0x53, 0x9b, 0x63, 0x36, 0xe4, 0x03, 0xb3, 0x71, 0x61,
	0x78, 0xd3, 0xc5, 0x5c, 0x92, 0x17, 0xc4, 0x8d, 0xd3, 0x2f, 0x24, 0x42, 0xc4, 0xed, 0x24, 0xa1,
	0x4e, 0x1a, 0x9b, 0xcc, 0xf3, 0x7d, 0xc3, 0x01, 0x79, 0x23, 0xe3, 0xf9, 0xa9, 0x76, 0xbc, 0x45,
	0x13, 0x63, 0x15, 0x9a, 0x97, 0x06, 0x78, 0x90, 0x55, 0xe7, 0xb1, 0x10, 0x91, 0xcc, 0x07, 0x46,
	0xbf, 0xca, 0x89, 0xff, 0x42, 0xe5, 0x5b, 0x19, 0x05, 0x6b, 0x4a, 0x40, 0x5a, 0xc9, 0xce, 0x88,
	0xad, 0xfc, 0x6d, 0x80, 0xd2, 0x50, 0x0e, 0xb8, 0x03, 0xca, 0x92, 0x49, 0x14, 0x38, 0x12, 0x71,
	0x1f, 0x4b, 0xec, 0x25, 0xaa, 0x89, 0xaa, 0xc5, 0xe7, 0xa6, 0xf9, 0xb2, 0xa5, 0x6f, 0xfa, 0x1d,
	0x05, 0x6e, 0x26, 0xd8, 0x46, 0x0a, 0x85, 0x18, 0xcc, 0xf4, 0x78, 0x74, 0xcf, 0xbc, 0x71, 0x43,
	0x5b, 0xb7, 0x7b, 0xcc, 0x95, 0xdb, 0x00, 0x0e, 0xa6, 0x53, 0xe5, 0x73, 0x70, 0x6b, 0x00, 0x15,
	0xbf, 0x64, 0xdd, 0x1b, 0xc5, 0x89, 0xc4, 0x9c, 0x30, 0x3a, 0x52, 0x6b, 0x3d, 0x9f, 0x5e, 0x8d,
	0x14, 0xd5, 0xbd, 0xc0, 0xab, 0xaf, 0x0c, 0x50, 0x75, 0x59, 0x78, 0xc1, 0xc6, 0x56, 0x0b, 0x7a,
	0x67, 0xdb, 0x31, 0xfb, 0xb6, 0xf1, 0xe9, 0x5a, 0x62, 0xee, 0xb3, 0xb8, 0x1b, 0x33, 0x19, 0xf7,
	0x6b, 0x3e, 0xa6, 0xca, 0x77, 0xfa, 0x85, 0x18, 0x11, 0x71, 0xde, 0xd7, 0xf6, 0x43, 0xfd, 0xf3,
	0x4b, 0x6e, 0x7c, 0x63, 0x65, 0xe5, 0x65, 0xee, 0xde, 0x86, 0x26, 0x5b, 0xf1, 0x84, 0xa9, 0x87,
	0xf1, 0x68, 0xd7, 0x32, 0x1b, 0xca, 0xec, 0x8f, 0xd4, 0x60, 0x7f, 0xc5, 0x13, 0xfb, 0x5d, 0x83,
	0xfd, 0x5d, 0x6b, 0x5f, 0x1b, 0xfc, 0x93, 0xab, 0xea, 0xd9, 0x7a, 0x7d, 0xc5, 0x13, 0xf5, 0x7a,
	0xd7, 0xa4, 0x5e, 0xdf, 0xb5, 0xea, 0x75, 0x6d, 0x74, 0x38, 0xa5, 0xd4, 0x2d, 0xff, 0x1b, 0x00,
	0x00, 0xff, 0xff, 0x2e, 0xef, 0x3d, 0x92, 0x0a, 0x10, 0x00, 0x00,
}
