// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package detective

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAcceptInvitation = "AcceptInvitation"

// AcceptInvitationRequest generates a "aws/request.Request" representing the
// client's request for the AcceptInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptInvitation for more information on using the AcceptInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptInvitationRequest method.
//    req, resp := client.AcceptInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/AcceptInvitation
func (c *Detective) AcceptInvitationRequest(input *AcceptInvitationInput) (req *request.Request, output *AcceptInvitationOutput) {
	op := &request.Operation{
		Name:       opAcceptInvitation,
		HTTPMethod: "PUT",
		HTTPPath:   "/invitation",
	}

	if input == nil {
		input = &AcceptInvitationInput{}
	}

	output = &AcceptInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptInvitation API operation for Amazon Detective.
//
// Accepts an invitation for the member account to contribute data to a behavior
// graph. This operation can only be called by an invited member account.
//
// The request provides the ARN of behavior graph.
//
// The member account status in the graph must be INVITED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation AcceptInvitation for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request attempted an invalid action.
//
//   * InternalServerException
//   The request was valid but failed because of a problem with the service.
//
//   * ResourceNotFoundException
//   The request refers to a nonexistent resource.
//
//   * ValidationException
//   The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/AcceptInvitation
func (c *Detective) AcceptInvitation(input *AcceptInvitationInput) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	return out, req.Send()
}

// AcceptInvitationWithContext is the same as AcceptInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) AcceptInvitationWithContext(ctx aws.Context, input *AcceptInvitationInput, opts ...request.Option) (*AcceptInvitationOutput, error) {
	req, out := c.AcceptInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGraph = "CreateGraph"

// CreateGraphRequest generates a "aws/request.Request" representing the
// client's request for the CreateGraph operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGraph for more information on using the CreateGraph
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGraphRequest method.
//    req, resp := client.CreateGraphRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/CreateGraph
func (c *Detective) CreateGraphRequest(input *CreateGraphInput) (req *request.Request, output *CreateGraphOutput) {
	op := &request.Operation{
		Name:       opCreateGraph,
		HTTPMethod: "POST",
		HTTPPath:   "/graph",
	}

	if input == nil {
		input = &CreateGraphInput{}
	}

	output = &CreateGraphOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGraph API operation for Amazon Detective.
//
// Creates a new behavior graph for the calling account, and sets that account
// as the master account. This operation is called by the account that is enabling
// Detective.
//
// Before you try to enable Detective, make sure that your account has been
// enrolled in Amazon GuardDuty for at least 48 hours. If you do not meet this
// requirement, you cannot enable Detective. If you do meet the GuardDuty prerequisite,
// then when you make the request to enable Detective, it checks whether your
// data volume is within the Detective quota. If it exceeds the quota, then
// you cannot enable Detective.
//
// The operation also enables Detective for the calling account in the currently
// selected Region. It returns the ARN of the new behavior graph.
//
// CreateGraph triggers a process to create the corresponding data tables for
// the new behavior graph.
//
// An account can only be the master account for one behavior graph within a
// Region. If the same account calls CreateGraph with the same master account,
// it always returns the same behavior graph ARN. It does not create a new behavior
// graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation CreateGraph for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request attempted an invalid action.
//
//   * InternalServerException
//   The request was valid but failed because of a problem with the service.
//
//   * ServiceQuotaExceededException
//   This request cannot be completed for one of the following reasons.
//
//      * The request would cause the number of member accounts in the behavior
//      graph to exceed the maximum allowed. A behavior graph cannot have more
//      than 1000 member accounts.
//
//      * The request would cause the data rate for the behavior graph to exceed
//      the maximum allowed.
//
//      * Detective is unable to verify the data rate for the member account.
//      This is usually because the member account is not enrolled in Amazon GuardDuty.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/CreateGraph
func (c *Detective) CreateGraph(input *CreateGraphInput) (*CreateGraphOutput, error) {
	req, out := c.CreateGraphRequest(input)
	return out, req.Send()
}

// CreateGraphWithContext is the same as CreateGraph with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGraph for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) CreateGraphWithContext(ctx aws.Context, input *CreateGraphInput, opts ...request.Option) (*CreateGraphOutput, error) {
	req, out := c.CreateGraphRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMembers = "CreateMembers"

// CreateMembersRequest generates a "aws/request.Request" representing the
// client's request for the CreateMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMembers for more information on using the CreateMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMembersRequest method.
//    req, resp := client.CreateMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/CreateMembers
func (c *Detective) CreateMembersRequest(input *CreateMembersInput) (req *request.Request, output *CreateMembersOutput) {
	op := &request.Operation{
		Name:       opCreateMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/members",
	}

	if input == nil {
		input = &CreateMembersInput{}
	}

	output = &CreateMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMembers API operation for Amazon Detective.
//
// Sends a request to invite the specified AWS accounts to be member accounts
// in the behavior graph. This operation can only be called by the master account
// for a behavior graph.
//
// CreateMembers verifies the accounts and then sends invitations to the verified
// accounts.
//
// The request provides the behavior graph ARN and the list of accounts to invite.
//
// The response separates the requested accounts into two lists:
//
//    * The accounts that CreateMembers was able to start the verification for.
//    This list includes member accounts that are being verified, that have
//    passed verification and are being sent an invitation, and that have failed
//    verification.
//
//    * The accounts that CreateMembers was unable to process. This list includes
//    accounts that were already invited to be member accounts in the behavior
//    graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation CreateMembers for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request was valid but failed because of a problem with the service.
//
//   * ResourceNotFoundException
//   The request refers to a nonexistent resource.
//
//   * ValidationException
//   The request parameters are invalid.
//
//   * ServiceQuotaExceededException
//   This request cannot be completed for one of the following reasons.
//
//      * The request would cause the number of member accounts in the behavior
//      graph to exceed the maximum allowed. A behavior graph cannot have more
//      than 1000 member accounts.
//
//      * The request would cause the data rate for the behavior graph to exceed
//      the maximum allowed.
//
//      * Detective is unable to verify the data rate for the member account.
//      This is usually because the member account is not enrolled in Amazon GuardDuty.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/CreateMembers
func (c *Detective) CreateMembers(input *CreateMembersInput) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	return out, req.Send()
}

// CreateMembersWithContext is the same as CreateMembers with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) CreateMembersWithContext(ctx aws.Context, input *CreateMembersInput, opts ...request.Option) (*CreateMembersOutput, error) {
	req, out := c.CreateMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGraph = "DeleteGraph"

// DeleteGraphRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGraph operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGraph for more information on using the DeleteGraph
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGraphRequest method.
//    req, resp := client.DeleteGraphRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DeleteGraph
func (c *Detective) DeleteGraphRequest(input *DeleteGraphInput) (req *request.Request, output *DeleteGraphOutput) {
	op := &request.Operation{
		Name:       opDeleteGraph,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/removal",
	}

	if input == nil {
		input = &DeleteGraphInput{}
	}

	output = &DeleteGraphOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGraph API operation for Amazon Detective.
//
// Disables the specified behavior graph and queues it to be deleted. This operation
// removes the graph from each member account's list of behavior graphs.
//
// DeleteGraph can only be called by the master account for a behavior graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation DeleteGraph for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request was valid but failed because of a problem with the service.
//
//   * ResourceNotFoundException
//   The request refers to a nonexistent resource.
//
//   * ValidationException
//   The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DeleteGraph
func (c *Detective) DeleteGraph(input *DeleteGraphInput) (*DeleteGraphOutput, error) {
	req, out := c.DeleteGraphRequest(input)
	return out, req.Send()
}

// DeleteGraphWithContext is the same as DeleteGraph with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGraph for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) DeleteGraphWithContext(ctx aws.Context, input *DeleteGraphInput, opts ...request.Option) (*DeleteGraphOutput, error) {
	req, out := c.DeleteGraphRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMembers = "DeleteMembers"

// DeleteMembersRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMembers for more information on using the DeleteMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMembersRequest method.
//    req, resp := client.DeleteMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DeleteMembers
func (c *Detective) DeleteMembersRequest(input *DeleteMembersInput) (req *request.Request, output *DeleteMembersOutput) {
	op := &request.Operation{
		Name:       opDeleteMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/members/removal",
	}

	if input == nil {
		input = &DeleteMembersInput{}
	}

	output = &DeleteMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMembers API operation for Amazon Detective.
//
// Deletes one or more member accounts from the master account behavior graph.
// This operation can only be called by a Detective master account. That account
// cannot use DeleteMembers to delete their own account from the behavior graph.
// To disable a behavior graph, the master account uses the DeleteGraph API
// method.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation DeleteMembers for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request attempted an invalid action.
//
//   * InternalServerException
//   The request was valid but failed because of a problem with the service.
//
//   * ResourceNotFoundException
//   The request refers to a nonexistent resource.
//
//   * ValidationException
//   The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DeleteMembers
func (c *Detective) DeleteMembers(input *DeleteMembersInput) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	return out, req.Send()
}

// DeleteMembersWithContext is the same as DeleteMembers with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) DeleteMembersWithContext(ctx aws.Context, input *DeleteMembersInput, opts ...request.Option) (*DeleteMembersOutput, error) {
	req, out := c.DeleteMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMembership = "DisassociateMembership"

// DisassociateMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMembership for more information on using the DisassociateMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateMembershipRequest method.
//    req, resp := client.DisassociateMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DisassociateMembership
func (c *Detective) DisassociateMembershipRequest(input *DisassociateMembershipInput) (req *request.Request, output *DisassociateMembershipOutput) {
	op := &request.Operation{
		Name:       opDisassociateMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/membership/removal",
	}

	if input == nil {
		input = &DisassociateMembershipInput{}
	}

	output = &DisassociateMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateMembership API operation for Amazon Detective.
//
// Removes the member account from the specified behavior graph. This operation
// can only be called by a member account that has the ENABLED status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation DisassociateMembership for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request attempted an invalid action.
//
//   * InternalServerException
//   The request was valid but failed because of a problem with the service.
//
//   * ResourceNotFoundException
//   The request refers to a nonexistent resource.
//
//   * ValidationException
//   The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/DisassociateMembership
func (c *Detective) DisassociateMembership(input *DisassociateMembershipInput) (*DisassociateMembershipOutput, error) {
	req, out := c.DisassociateMembershipRequest(input)
	return out, req.Send()
}

// DisassociateMembershipWithContext is the same as DisassociateMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) DisassociateMembershipWithContext(ctx aws.Context, input *DisassociateMembershipInput, opts ...request.Option) (*DisassociateMembershipOutput, error) {
	req, out := c.DisassociateMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMembers = "GetMembers"

// GetMembersRequest generates a "aws/request.Request" representing the
// client's request for the GetMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMembers for more information on using the GetMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMembersRequest method.
//    req, resp := client.GetMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/GetMembers
func (c *Detective) GetMembersRequest(input *GetMembersInput) (req *request.Request, output *GetMembersOutput) {
	op := &request.Operation{
		Name:       opGetMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/members/get",
	}

	if input == nil {
		input = &GetMembersInput{}
	}

	output = &GetMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMembers API operation for Amazon Detective.
//
// Returns the membership details for specified member accounts for a behavior
// graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation GetMembers for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request was valid but failed because of a problem with the service.
//
//   * ResourceNotFoundException
//   The request refers to a nonexistent resource.
//
//   * ValidationException
//   The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/GetMembers
func (c *Detective) GetMembers(input *GetMembersInput) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	return out, req.Send()
}

// GetMembersWithContext is the same as GetMembers with the addition of
// the ability to pass a context and additional request options.
//
// See GetMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) GetMembersWithContext(ctx aws.Context, input *GetMembersInput, opts ...request.Option) (*GetMembersOutput, error) {
	req, out := c.GetMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGraphs = "ListGraphs"

// ListGraphsRequest generates a "aws/request.Request" representing the
// client's request for the ListGraphs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGraphs for more information on using the ListGraphs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGraphsRequest method.
//    req, resp := client.ListGraphsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListGraphs
func (c *Detective) ListGraphsRequest(input *ListGraphsInput) (req *request.Request, output *ListGraphsOutput) {
	op := &request.Operation{
		Name:       opListGraphs,
		HTTPMethod: "POST",
		HTTPPath:   "/graphs/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGraphsInput{}
	}

	output = &ListGraphsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGraphs API operation for Amazon Detective.
//
// Returns the list of behavior graphs that the calling account is a master
// of. This operation can only be called by a master account.
//
// Because an account can currently only be the master of one behavior graph
// within a Region, the results always contain a single graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation ListGraphs for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request was valid but failed because of a problem with the service.
//
//   * ValidationException
//   The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListGraphs
func (c *Detective) ListGraphs(input *ListGraphsInput) (*ListGraphsOutput, error) {
	req, out := c.ListGraphsRequest(input)
	return out, req.Send()
}

// ListGraphsWithContext is the same as ListGraphs with the addition of
// the ability to pass a context and additional request options.
//
// See ListGraphs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListGraphsWithContext(ctx aws.Context, input *ListGraphsInput, opts ...request.Option) (*ListGraphsOutput, error) {
	req, out := c.ListGraphsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGraphsPages iterates over the pages of a ListGraphs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGraphs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGraphs operation.
//    pageNum := 0
//    err := client.ListGraphsPages(params,
//        func(page *detective.ListGraphsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Detective) ListGraphsPages(input *ListGraphsInput, fn func(*ListGraphsOutput, bool) bool) error {
	return c.ListGraphsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGraphsPagesWithContext same as ListGraphsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListGraphsPagesWithContext(ctx aws.Context, input *ListGraphsInput, fn func(*ListGraphsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGraphsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGraphsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGraphsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInvitations = "ListInvitations"

// ListInvitationsRequest generates a "aws/request.Request" representing the
// client's request for the ListInvitations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInvitations for more information on using the ListInvitations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInvitationsRequest method.
//    req, resp := client.ListInvitationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListInvitations
func (c *Detective) ListInvitationsRequest(input *ListInvitationsInput) (req *request.Request, output *ListInvitationsOutput) {
	op := &request.Operation{
		Name:       opListInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInvitationsInput{}
	}

	output = &ListInvitationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInvitations API operation for Amazon Detective.
//
// Retrieves the list of open and accepted behavior graph invitations for the
// member account. This operation can only be called by a member account.
//
// Open invitations are invitations that the member account has not responded
// to.
//
// The results do not include behavior graphs for which the member account declined
// the invitation. The results also do not include behavior graphs that the
// member account resigned from or was removed from.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation ListInvitations for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request was valid but failed because of a problem with the service.
//
//   * ValidationException
//   The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListInvitations
func (c *Detective) ListInvitations(input *ListInvitationsInput) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	return out, req.Send()
}

// ListInvitationsWithContext is the same as ListInvitations with the addition of
// the ability to pass a context and additional request options.
//
// See ListInvitations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListInvitationsWithContext(ctx aws.Context, input *ListInvitationsInput, opts ...request.Option) (*ListInvitationsOutput, error) {
	req, out := c.ListInvitationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInvitationsPages iterates over the pages of a ListInvitations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInvitations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInvitations operation.
//    pageNum := 0
//    err := client.ListInvitationsPages(params,
//        func(page *detective.ListInvitationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Detective) ListInvitationsPages(input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool) error {
	return c.ListInvitationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInvitationsPagesWithContext same as ListInvitationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListInvitationsPagesWithContext(ctx aws.Context, input *ListInvitationsInput, fn func(*ListInvitationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInvitationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInvitationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInvitationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMembers = "ListMembers"

// ListMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMembers for more information on using the ListMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMembersRequest method.
//    req, resp := client.ListMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListMembers
func (c *Detective) ListMembersRequest(input *ListMembersInput) (req *request.Request, output *ListMembersOutput) {
	op := &request.Operation{
		Name:       opListMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/members/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMembersInput{}
	}

	output = &ListMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMembers API operation for Amazon Detective.
//
// Retrieves the list of member accounts for a behavior graph. Does not return
// member accounts that were removed from the behavior graph.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation ListMembers for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request was valid but failed because of a problem with the service.
//
//   * ResourceNotFoundException
//   The request refers to a nonexistent resource.
//
//   * ValidationException
//   The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/ListMembers
func (c *Detective) ListMembers(input *ListMembersInput) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	return out, req.Send()
}

// ListMembersWithContext is the same as ListMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListMembersWithContext(ctx aws.Context, input *ListMembersInput, opts ...request.Option) (*ListMembersOutput, error) {
	req, out := c.ListMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMembersPages iterates over the pages of a ListMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMembers operation.
//    pageNum := 0
//    err := client.ListMembersPages(params,
//        func(page *detective.ListMembersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Detective) ListMembersPages(input *ListMembersInput, fn func(*ListMembersOutput, bool) bool) error {
	return c.ListMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMembersPagesWithContext same as ListMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) ListMembersPagesWithContext(ctx aws.Context, input *ListMembersInput, fn func(*ListMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRejectInvitation = "RejectInvitation"

// RejectInvitationRequest generates a "aws/request.Request" representing the
// client's request for the RejectInvitation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectInvitation for more information on using the RejectInvitation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RejectInvitationRequest method.
//    req, resp := client.RejectInvitationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/RejectInvitation
func (c *Detective) RejectInvitationRequest(input *RejectInvitationInput) (req *request.Request, output *RejectInvitationOutput) {
	op := &request.Operation{
		Name:       opRejectInvitation,
		HTTPMethod: "POST",
		HTTPPath:   "/invitation/removal",
	}

	if input == nil {
		input = &RejectInvitationInput{}
	}

	output = &RejectInvitationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RejectInvitation API operation for Amazon Detective.
//
// Rejects an invitation to contribute the account data to a behavior graph.
// This operation must be called by a member account that has the INVITED status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation RejectInvitation for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request attempted an invalid action.
//
//   * InternalServerException
//   The request was valid but failed because of a problem with the service.
//
//   * ResourceNotFoundException
//   The request refers to a nonexistent resource.
//
//   * ValidationException
//   The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/RejectInvitation
func (c *Detective) RejectInvitation(input *RejectInvitationInput) (*RejectInvitationOutput, error) {
	req, out := c.RejectInvitationRequest(input)
	return out, req.Send()
}

// RejectInvitationWithContext is the same as RejectInvitation with the addition of
// the ability to pass a context and additional request options.
//
// See RejectInvitation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) RejectInvitationWithContext(ctx aws.Context, input *RejectInvitationInput, opts ...request.Option) (*RejectInvitationOutput, error) {
	req, out := c.RejectInvitationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMonitoringMember = "StartMonitoringMember"

// StartMonitoringMemberRequest generates a "aws/request.Request" representing the
// client's request for the StartMonitoringMember operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMonitoringMember for more information on using the StartMonitoringMember
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMonitoringMemberRequest method.
//    req, resp := client.StartMonitoringMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/StartMonitoringMember
func (c *Detective) StartMonitoringMemberRequest(input *StartMonitoringMemberInput) (req *request.Request, output *StartMonitoringMemberOutput) {
	op := &request.Operation{
		Name:       opStartMonitoringMember,
		HTTPMethod: "POST",
		HTTPPath:   "/graph/member/monitoringstate",
	}

	if input == nil {
		input = &StartMonitoringMemberInput{}
	}

	output = &StartMonitoringMemberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartMonitoringMember API operation for Amazon Detective.
//
// Sends a request to enable data ingest for a member account that has a status
// of ACCEPTED_BUT_DISABLED.
//
// For valid member accounts, the status is updated as follows.
//
//    * If Detective enabled the member account, then the new status is ENABLED.
//
//    * If Detective cannot enable the member account, the status remains ACCEPTED_BUT_DISABLED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Detective's
// API operation StartMonitoringMember for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request attempted an invalid action.
//
//   * InternalServerException
//   The request was valid but failed because of a problem with the service.
//
//   * ResourceNotFoundException
//   The request refers to a nonexistent resource.
//
//   * ServiceQuotaExceededException
//   This request cannot be completed for one of the following reasons.
//
//      * The request would cause the number of member accounts in the behavior
//      graph to exceed the maximum allowed. A behavior graph cannot have more
//      than 1000 member accounts.
//
//      * The request would cause the data rate for the behavior graph to exceed
//      the maximum allowed.
//
//      * Detective is unable to verify the data rate for the member account.
//      This is usually because the member account is not enrolled in Amazon GuardDuty.
//
//   * ValidationException
//   The request parameters are invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/detective-2018-10-26/StartMonitoringMember
func (c *Detective) StartMonitoringMember(input *StartMonitoringMemberInput) (*StartMonitoringMemberOutput, error) {
	req, out := c.StartMonitoringMemberRequest(input)
	return out, req.Send()
}

// StartMonitoringMemberWithContext is the same as StartMonitoringMember with the addition of
// the ability to pass a context and additional request options.
//
// See StartMonitoringMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Detective) StartMonitoringMemberWithContext(ctx aws.Context, input *StartMonitoringMemberInput, opts ...request.Option) (*StartMonitoringMemberOutput, error) {
	req, out := c.StartMonitoringMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph that the member account is accepting the invitation
	// for.
	//
	// The member account status in the behavior graph must be INVITED.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptInvitationInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *AcceptInvitationInput) SetGraphArn(v string) *AcceptInvitationInput {
	s.GraphArn = &v
	return s
}

type AcceptInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptInvitationOutput) GoString() string {
	return s.String()
}

// An AWS account that is the master of or a member of a behavior graph.
type Account struct {
	_ struct{} `type:"structure"`

	// The account identifier of the AWS account.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The AWS account root user email address for the AWS account.
	//
	// EmailAddress is a required field
	EmailAddress *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Account) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Account) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Account) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Account"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *Account) SetAccountId(v string) *Account {
	s.AccountId = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *Account) SetEmailAddress(v string) *Account {
	s.EmailAddress = &v
	return s
}

// The request attempted an invalid action.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateGraphInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateGraphInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGraphInput) GoString() string {
	return s.String()
}

type CreateGraphOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new behavior graph.
	GraphArn *string `type:"string"`
}

// String returns the string representation
func (s CreateGraphOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGraphOutput) GoString() string {
	return s.String()
}

// SetGraphArn sets the GraphArn field's value.
func (s *CreateGraphOutput) SetGraphArn(v string) *CreateGraphOutput {
	s.GraphArn = &v
	return s
}

type CreateMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of AWS accounts to invite to become member accounts in the behavior
	// graph. For each invited account, the account list contains the account identifier
	// and the AWS account root user email address.
	//
	// Accounts is a required field
	Accounts []*Account `min:"1" type:"list" required:"true"`

	// The ARN of the behavior graph to invite the member accounts to contribute
	// their data to.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`

	// Customized message text to include in the invitation email message to the
	// invited member accounts.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMembersInput"}
	if s.Accounts == nil {
		invalidParams.Add(request.NewErrParamRequired("Accounts"))
	}
	if s.Accounts != nil && len(s.Accounts) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Accounts", 1))
	}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}
	if s.Message != nil && len(*s.Message) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Message", 1))
	}
	if s.Accounts != nil {
		for i, v := range s.Accounts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Accounts", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccounts sets the Accounts field's value.
func (s *CreateMembersInput) SetAccounts(v []*Account) *CreateMembersInput {
	s.Accounts = v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *CreateMembersInput) SetGraphArn(v string) *CreateMembersInput {
	s.GraphArn = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *CreateMembersInput) SetMessage(v string) *CreateMembersInput {
	s.Message = &v
	return s
}

type CreateMembersOutput struct {
	_ struct{} `type:"structure"`

	// The set of member account invitation requests that Detective was able to
	// process. This includes accounts that are being verified, that failed verification,
	// and that passed verification and are being sent an invitation.
	Members []*MemberDetail `type:"list"`

	// The list of accounts for which Detective was unable to process the invitation
	// request. For each account, the list provides the reason why the request could
	// not be processed. The list includes accounts that are already member accounts
	// in the behavior graph.
	UnprocessedAccounts []*UnprocessedAccount `type:"list"`
}

// String returns the string representation
func (s CreateMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *CreateMembersOutput) SetMembers(v []*MemberDetail) *CreateMembersOutput {
	s.Members = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *CreateMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *CreateMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type DeleteGraphInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph to disable.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGraphInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGraphInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGraphInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGraphInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *DeleteGraphInput) SetGraphArn(v string) *DeleteGraphInput {
	s.GraphArn = &v
	return s
}

type DeleteGraphOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGraphOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGraphOutput) GoString() string {
	return s.String()
}

type DeleteMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of AWS account identifiers for the member accounts to delete from
	// the behavior graph.
	//
	// AccountIds is a required field
	AccountIds []*string `min:"1" type:"list" required:"true"`

	// The ARN of the behavior graph to delete members from.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteMembersInput) SetAccountIds(v []*string) *DeleteMembersInput {
	s.AccountIds = v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *DeleteMembersInput) SetGraphArn(v string) *DeleteMembersInput {
	s.GraphArn = &v
	return s
}

type DeleteMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of AWS account identifiers for the member accounts that Detective
	// successfully deleted from the behavior graph.
	AccountIds []*string `min:"1" type:"list"`

	// The list of member accounts that Detective was not able to delete from the
	// behavior graph. For each member account, provides the reason that the deletion
	// could not be processed.
	UnprocessedAccounts []*UnprocessedAccount `type:"list"`
}

// String returns the string representation
func (s DeleteMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMembersOutput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *DeleteMembersOutput) SetAccountIds(v []*string) *DeleteMembersOutput {
	s.AccountIds = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *DeleteMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *DeleteMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

type DisassociateMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph to remove the member account from.
	//
	// The member account's member status in the behavior graph must be ENABLED.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMembershipInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *DisassociateMembershipInput) SetGraphArn(v string) *DisassociateMembershipInput {
	s.GraphArn = &v
	return s
}

type DisassociateMembershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMembershipOutput) GoString() string {
	return s.String()
}

type GetMembersInput struct {
	_ struct{} `type:"structure"`

	// The list of AWS account identifiers for the member account for which to return
	// member details.
	//
	// You cannot use GetMembers to retrieve information about member accounts that
	// were removed from the behavior graph.
	//
	// AccountIds is a required field
	AccountIds []*string `min:"1" type:"list" required:"true"`

	// The ARN of the behavior graph for which to request the member details.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMembersInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *GetMembersInput) SetAccountIds(v []*string) *GetMembersInput {
	s.AccountIds = v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *GetMembersInput) SetGraphArn(v string) *GetMembersInput {
	s.GraphArn = &v
	return s
}

type GetMembersOutput struct {
	_ struct{} `type:"structure"`

	// The member account details that Detective is returning in response to the
	// request.
	MemberDetails []*MemberDetail `type:"list"`

	// The requested member accounts for which Detective was unable to return member
	// details.
	//
	// For each account, provides the reason why the request could not be processed.
	UnprocessedAccounts []*UnprocessedAccount `type:"list"`
}

// String returns the string representation
func (s GetMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMembersOutput) GoString() string {
	return s.String()
}

// SetMemberDetails sets the MemberDetails field's value.
func (s *GetMembersOutput) SetMemberDetails(v []*MemberDetail) *GetMembersOutput {
	s.MemberDetails = v
	return s
}

// SetUnprocessedAccounts sets the UnprocessedAccounts field's value.
func (s *GetMembersOutput) SetUnprocessedAccounts(v []*UnprocessedAccount) *GetMembersOutput {
	s.UnprocessedAccounts = v
	return s
}

// A behavior graph in Detective.
type Graph struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph.
	Arn *string `type:"string"`

	// The date and time that the behavior graph was created. The value is in milliseconds
	// since the epoch.
	CreatedTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Graph) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Graph) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Graph) SetArn(v string) *Graph {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Graph) SetCreatedTime(v time.Time) *Graph {
	s.CreatedTime = &v
	return s
}

// The request was valid but failed because of a problem with the service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListGraphsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of graphs to return at a time. The total must be less
	// than the overall limit on the number of results to return, which is currently
	// 200.
	MaxResults *int64 `min:"1" type:"integer"`

	// For requests to get the next page of results, the pagination token that was
	// returned with the previous set of results. The initial request does not include
	// a pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGraphsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGraphsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGraphsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGraphsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGraphsInput) SetMaxResults(v int64) *ListGraphsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGraphsInput) SetNextToken(v string) *ListGraphsInput {
	s.NextToken = &v
	return s
}

type ListGraphsOutput struct {
	_ struct{} `type:"structure"`

	// A list of behavior graphs that the account is a master for.
	GraphList []*Graph `type:"list"`

	// If there are more behavior graphs remaining in the results, then this is
	// the pagination token to use to request the next page of behavior graphs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGraphsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGraphsOutput) GoString() string {
	return s.String()
}

// SetGraphList sets the GraphList field's value.
func (s *ListGraphsOutput) SetGraphList(v []*Graph) *ListGraphsOutput {
	s.GraphList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGraphsOutput) SetNextToken(v string) *ListGraphsOutput {
	s.NextToken = &v
	return s
}

type ListInvitationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of behavior graph invitations to return in the response.
	// The total must be less than the overall limit on the number of results to
	// return, which is currently 200.
	MaxResults *int64 `min:"1" type:"integer"`

	// For requests to retrieve the next page of results, the pagination token that
	// was returned with the previous page of results. The initial request does
	// not include a pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvitationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInvitationsInput) SetMaxResults(v int64) *ListInvitationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsInput) SetNextToken(v string) *ListInvitationsInput {
	s.NextToken = &v
	return s
}

type ListInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of behavior graphs for which the member account has open or accepted
	// invitations.
	Invitations []*MemberDetail `type:"list"`

	// If there are more behavior graphs remaining in the results, then this is
	// the pagination token to use to request the next page of behavior graphs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvitationsOutput) GoString() string {
	return s.String()
}

// SetInvitations sets the Invitations field's value.
func (s *ListInvitationsOutput) SetInvitations(v []*MemberDetail) *ListInvitationsOutput {
	s.Invitations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInvitationsOutput) SetNextToken(v string) *ListInvitationsOutput {
	s.NextToken = &v
	return s
}

type ListMembersInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph for which to retrieve the list of member accounts.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`

	// The maximum number of member accounts to include in the response. The total
	// must be less than the overall limit on the number of results to return, which
	// is currently 200.
	MaxResults *int64 `min:"1" type:"integer"`

	// For requests to retrieve the next page of member account results, the pagination
	// token that was returned with the previous page of results. The initial request
	// does not include a pagination token.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMembersInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *ListMembersInput) SetGraphArn(v string) *ListMembersInput {
	s.GraphArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMembersInput) SetMaxResults(v int64) *ListMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersInput) SetNextToken(v string) *ListMembersInput {
	s.NextToken = &v
	return s
}

type ListMembersOutput struct {
	_ struct{} `type:"structure"`

	// The list of member accounts in the behavior graph.
	//
	// The results include member accounts that did not pass verification and member
	// accounts that have not yet accepted the invitation to the behavior graph.
	// The results do not include member accounts that were removed from the behavior
	// graph.
	MemberDetails []*MemberDetail `type:"list"`

	// If there are more member accounts remaining in the results, then this is
	// the pagination token to use to request the next page of member accounts.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMembersOutput) GoString() string {
	return s.String()
}

// SetMemberDetails sets the MemberDetails field's value.
func (s *ListMembersOutput) SetMemberDetails(v []*MemberDetail) *ListMembersOutput {
	s.MemberDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMembersOutput) SetNextToken(v string) *ListMembersOutput {
	s.NextToken = &v
	return s
}

// Details about a member account that was invited to contribute to a behavior
// graph.
type MemberDetail struct {
	_ struct{} `type:"structure"`

	// The AWS account identifier for the member account.
	AccountId *string `min:"12" type:"string"`

	// For member accounts with a status of ACCEPTED_BUT_DISABLED, the reason that
	// the member account is not enabled.
	//
	// The reason can have one of the following values:
	//
	//    * VOLUME_TOO_HIGH - Indicates that adding the member account would cause
	//    the data volume for the behavior graph to be too high.
	//
	//    * VOLUME_UNKNOWN - Indicates that Detective is unable to verify the data
	//    volume for the member account. This is usually because the member account
	//    is not enrolled in Amazon GuardDuty.
	DisabledReason *string `type:"string" enum:"MemberDisabledReason"`

	// The AWS account root user email address for the member account.
	EmailAddress *string `min:"1" type:"string"`

	// The ARN of the behavior graph that the member account was invited to.
	GraphArn *string `type:"string"`

	// The date and time that Detective sent the invitation to the member account.
	// The value is in milliseconds since the epoch.
	InvitedTime *time.Time `type:"timestamp"`

	// The AWS account identifier of the master account for the behavior graph.
	MasterId *string `min:"12" type:"string"`

	// The member account data volume as a percentage of the maximum allowed data
	// volume. 0 indicates 0 percent, and 100 indicates 100 percent.
	//
	// Note that this is not the percentage of the behavior graph data volume.
	//
	// For example, the data volume for the behavior graph is 80 GB per day. The
	// maximum data volume is 160 GB per day. If the data volume for the member
	// account is 40 GB per day, then PercentOfGraphUtilization is 25. It represents
	// 25% of the maximum allowed data volume.
	PercentOfGraphUtilization *float64 `type:"double"`

	// The date and time when the graph utilization percentage was last updated.
	PercentOfGraphUtilizationUpdatedTime *time.Time `type:"timestamp"`

	// The current membership status of the member account. The status can have
	// one of the following values:
	//
	//    * INVITED - Indicates that the member was sent an invitation but has not
	//    yet responded.
	//
	//    * VERIFICATION_IN_PROGRESS - Indicates that Detective is verifying that
	//    the account identifier and email address provided for the member account
	//    match. If they do match, then Detective sends the invitation. If the email
	//    address and account identifier don't match, then the member cannot be
	//    added to the behavior graph.
	//
	//    * VERIFICATION_FAILED - Indicates that the account and email address provided
	//    for the member account do not match, and Detective did not send an invitation
	//    to the account.
	//
	//    * ENABLED - Indicates that the member account accepted the invitation
	//    to contribute to the behavior graph.
	//
	//    * ACCEPTED_BUT_DISABLED - Indicates that the member account accepted the
	//    invitation but is prevented from contributing data to the behavior graph.
	//    DisabledReason provides the reason why the member account is not enabled.
	//
	// Member accounts that declined an invitation or that were removed from the
	// behavior graph are not included.
	Status *string `type:"string" enum:"MemberStatus"`

	// The date and time that the member account was last updated. The value is
	// in milliseconds since the epoch.
	UpdatedTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s MemberDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberDetail) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *MemberDetail) SetAccountId(v string) *MemberDetail {
	s.AccountId = &v
	return s
}

// SetDisabledReason sets the DisabledReason field's value.
func (s *MemberDetail) SetDisabledReason(v string) *MemberDetail {
	s.DisabledReason = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *MemberDetail) SetEmailAddress(v string) *MemberDetail {
	s.EmailAddress = &v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *MemberDetail) SetGraphArn(v string) *MemberDetail {
	s.GraphArn = &v
	return s
}

// SetInvitedTime sets the InvitedTime field's value.
func (s *MemberDetail) SetInvitedTime(v time.Time) *MemberDetail {
	s.InvitedTime = &v
	return s
}

// SetMasterId sets the MasterId field's value.
func (s *MemberDetail) SetMasterId(v string) *MemberDetail {
	s.MasterId = &v
	return s
}

// SetPercentOfGraphUtilization sets the PercentOfGraphUtilization field's value.
func (s *MemberDetail) SetPercentOfGraphUtilization(v float64) *MemberDetail {
	s.PercentOfGraphUtilization = &v
	return s
}

// SetPercentOfGraphUtilizationUpdatedTime sets the PercentOfGraphUtilizationUpdatedTime field's value.
func (s *MemberDetail) SetPercentOfGraphUtilizationUpdatedTime(v time.Time) *MemberDetail {
	s.PercentOfGraphUtilizationUpdatedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MemberDetail) SetStatus(v string) *MemberDetail {
	s.Status = &v
	return s
}

// SetUpdatedTime sets the UpdatedTime field's value.
func (s *MemberDetail) SetUpdatedTime(v time.Time) *MemberDetail {
	s.UpdatedTime = &v
	return s
}

type RejectInvitationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the behavior graph to reject the invitation to.
	//
	// The member account's current member status in the behavior graph must be
	// INVITED.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RejectInvitationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectInvitationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectInvitationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectInvitationInput"}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGraphArn sets the GraphArn field's value.
func (s *RejectInvitationInput) SetGraphArn(v string) *RejectInvitationInput {
	s.GraphArn = &v
	return s
}

type RejectInvitationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RejectInvitationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectInvitationOutput) GoString() string {
	return s.String()
}

// The request refers to a nonexistent resource.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This request cannot be completed for one of the following reasons.
//
//    * The request would cause the number of member accounts in the behavior
//    graph to exceed the maximum allowed. A behavior graph cannot have more
//    than 1000 member accounts.
//
//    * The request would cause the data rate for the behavior graph to exceed
//    the maximum allowed.
//
//    * Detective is unable to verify the data rate for the member account.
//    This is usually because the member account is not enrolled in Amazon GuardDuty.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartMonitoringMemberInput struct {
	_ struct{} `type:"structure"`

	// The account ID of the member account to try to enable.
	//
	// The account must be an invited member account with a status of ACCEPTED_BUT_DISABLED.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The ARN of the behavior graph.
	//
	// GraphArn is a required field
	GraphArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartMonitoringMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMonitoringMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMonitoringMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMonitoringMemberInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.GraphArn == nil {
		invalidParams.Add(request.NewErrParamRequired("GraphArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *StartMonitoringMemberInput) SetAccountId(v string) *StartMonitoringMemberInput {
	s.AccountId = &v
	return s
}

// SetGraphArn sets the GraphArn field's value.
func (s *StartMonitoringMemberInput) SetGraphArn(v string) *StartMonitoringMemberInput {
	s.GraphArn = &v
	return s
}

type StartMonitoringMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartMonitoringMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMonitoringMemberOutput) GoString() string {
	return s.String()
}

// A member account that was included in a request but for which the request
// could not be processed.
type UnprocessedAccount struct {
	_ struct{} `type:"structure"`

	// The AWS account identifier of the member account that was not processed.
	AccountId *string `min:"12" type:"string"`

	// The reason that the member account request could not be processed.
	Reason *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedAccount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessedAccount) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *UnprocessedAccount) SetAccountId(v string) *UnprocessedAccount {
	s.AccountId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *UnprocessedAccount) SetReason(v string) *UnprocessedAccount {
	s.Reason = &v
	return s
}

// The request parameters are invalid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// MemberDisabledReasonVolumeTooHigh is a MemberDisabledReason enum value
	MemberDisabledReasonVolumeTooHigh = "VOLUME_TOO_HIGH"

	// MemberDisabledReasonVolumeUnknown is a MemberDisabledReason enum value
	MemberDisabledReasonVolumeUnknown = "VOLUME_UNKNOWN"
)

// MemberDisabledReason_Values returns all elements of the MemberDisabledReason enum
func MemberDisabledReason_Values() []string {
	return []string{
		MemberDisabledReasonVolumeTooHigh,
		MemberDisabledReasonVolumeUnknown,
	}
}

const (
	// MemberStatusInvited is a MemberStatus enum value
	MemberStatusInvited = "INVITED"

	// MemberStatusVerificationInProgress is a MemberStatus enum value
	MemberStatusVerificationInProgress = "VERIFICATION_IN_PROGRESS"

	// MemberStatusVerificationFailed is a MemberStatus enum value
	MemberStatusVerificationFailed = "VERIFICATION_FAILED"

	// MemberStatusEnabled is a MemberStatus enum value
	MemberStatusEnabled = "ENABLED"

	// MemberStatusAcceptedButDisabled is a MemberStatus enum value
	MemberStatusAcceptedButDisabled = "ACCEPTED_BUT_DISABLED"
)

// MemberStatus_Values returns all elements of the MemberStatus enum
func MemberStatus_Values() []string {
	return []string{
		MemberStatusInvited,
		MemberStatusVerificationInProgress,
		MemberStatusVerificationFailed,
		MemberStatusEnabled,
		MemberStatusAcceptedButDisabled,
	}
}
