package ONVIF::PTZ::Types::VideoOutputConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(ONVIF::PTZ::Types::ConfigurationEntity);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Name_of :ATTR(:get<Name>);
my %UseCount_of :ATTR(:get<UseCount>);
my %OutputToken_of :ATTR(:get<OutputToken>);

__PACKAGE__->_factory(
    [ qw(        Name
        UseCount
        OutputToken

    ) ],
    {
        'Name' => \%Name_of,
        'UseCount' => \%UseCount_of,
        'OutputToken' => \%OutputToken_of,
    },
    {
        'Name' => 'ONVIF::PTZ::Types::Name',
        'UseCount' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'OutputToken' => 'ONVIF::PTZ::Types::ReferenceToken',
    },
    {

        'Name' => 'Name',
        'UseCount' => 'UseCount',
        'OutputToken' => 'OutputToken',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::VideoOutputConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
VideoOutputConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * OutputToken




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::VideoOutputConfiguration
   OutputToken => $some_value, # ReferenceToken
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

