// ===========================================================================
// version.h
// - collection of version numbers
//
// Author:  Falei LUO <falei.luo@gmail.com>
//
// ===========================================================================

#ifndef XAVS2_VERSION_H
#define XAVS2_VERSION_H

// version number
#define VER_MAJOR         1     // major version number
#define VER_MINOR         3     // minor version number
#define VER_BUILD         232    // build number
#define VER_SHA_STR       "eae1e8b9d1246805"  // commit id

// stringify
#define _TOSTR(x)       #x            // stringify x
#define TOSTR(x)        _TOSTR(x)     // stringify x, perform macro expansion

// define XVERSION string
#define XVERSION        VER_MAJOR, VER_MINOR, VER_BUILD
#define XVERSION_STR    TOSTR(VER_MAJOR) "." TOSTR(VER_MINOR) "." TOSTR(VER_BUILD) " " VER_SHA_STR
#define XBUILD_TIME     "2021-04-14 10:22:23"

#endif // __VERSION_H__
