/*	Copyright (C) 2018-2024 Martin Guy <martinwguy@gmail.com>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* snd_file.h: Interface to snd_file.c */

#if HAVE_LIBSNDFILE

#ifndef SND_FILE_H
#define SND_FILE_H 1

#include "a_file.h"

extern bool libsndfile_open(audio_file_t *af, char *filename);

extern bool libsndfile_seek(audio_file_t *af, int start);

extern int libsndfile_read_frames(audio_file_t *af,
				  void *write_to,
				  int frames_to_read,
				  af_format_t format);

extern void libsndfile_close(audio_file_t *af);

#endif

#endif /* HAVE_LIBSNDFILE */
