#include "Array_IO.h"
#include "EasyBMP.h"
#include "Array3D.h"
#include "Array.h"

void LoadArray3D ( MyArray3D *myArray, const char *name ) {
   BMP image;
   Point *dst;
   int x,y;

   cout<<"Loading..\n";
   
   image.ReadFromFile( name );
   int sx = image.TellWidth();
   int sy = image.TellHeight();
   if (sx==0 || sy==0) {
       cerr<<"Can't load image "<<name<<" . \n";
       exit(1);
   }
   myArray->ChangeSize(sx,sy);
   
   dst=myArray->Buffer();
   if( image.TellBitDepth()==8) {
      for (y=0; y<sy; y++ )   {
         for (x=0; x<sx; x++ )   {
            float w = float(image(x,y)->Red)*(1.0/255.0);
            *(dst++) = Point(w,w,w);
         }
      }
   }
   else {
      for (y=0; y<sy; y++ )   {
         for (x=0; x<sx; x++ )   {
            Point p;
            p.x = float( image(x,y)->Red   )*(1.0/255.0);
            p.y = float( image(x,y)->Green )*(1.0/255.0);
            p.z = float( image(x,y)->Blue  )*(1.0/255.0);
            *(dst++) = p;
         }
      }
   }
   cout<<"...Ok\n";
}

void SaveArray3D( MyArray3D *myArray, const char *name ) {
   BMP image;
   int x,y;
   Point *src;
   int sizeX = myArray->SizeX(), sizeY = myArray->SizeY();
   
   image.SetSize(sizeX,sizeY);
   image.SetBitDepth(24);
   src = myArray->Buffer();
   for (y=0; y<sizeY; y++ )   {
      for (x=0; x<sizeX; x++ )   {
         image(x,y)->Red   = int(src->x*255.0);
         image(x,y)->Green = int(src->y*255.0);
         image(x,y)->Blue  = int(src->z*255.0);
         src++;
      }
   }
   image.WriteToFile(name);
}

void LoadArray  ( MyArray   *myArray, const char *name ) {
   BMP image;
   float *dst;
   int x,y,sizeX,sizeY;

   cout<<"Loading..\n";
   
   image.ReadFromFile( name );
   sizeX = image.TellWidth();
   sizeY = image.TellHeight();
   if (sizeX==0 || sizeY==0) {
       cerr<<"Can't load image "<<name<<" . \n";
       exit(1);
   }
   myArray->ChangeSize(sizeX,sizeY);
   
   dst=myArray->Buffer();
   if( image.TellBitDepth()==8) {
      for (y=0; y<sizeY; y++ )   {
         for (x=0; x<sizeX; x++ )   {
            *(dst++) = float(image(x,y)->Red)*(1.0/255.0);
         }
      }
   }
   else {
      for (y=0; y<sizeY; y++ )   {
         for (x=0; x<sizeX; x++ )   {
            float f;
            f  = 0.299*float( image(x,y)->Red   );
            f += 0.587*float( image(x,y)->Green );
            f += 0.114*float( image(x,y)->Blue  );
            *(dst++) = f*(1.0/255.0);
         }
      }
   }
   cout<<"...Ok\n";
}

void SaveArray  ( MyArray   *myArray, const char *name ) {
   BMP image;
   int x,y;
   int sizeX = myArray->SizeX(), sizeY = myArray->SizeY();
   float *src;
   
   image.SetSize(sizeX,sizeY);
   image.SetBitDepth(24);
   src = myArray->Buffer();
   for (y=0; y<sizeY; y++ )   {
      for (x=0; x<sizeX; x++ )   {
         int c = int(*(src++)*255.0);
         image(x,y)->Red   = c;
         image(x,y)->Green = c;
         image(x,y)->Blue  = c;
      }
   }
   image.WriteToFile(name);
}

void SaveRGB    ( MyArray   *myArray, const char *name ) {
   BMP image;
   int x,y;
   int sizeX = myArray->SizeX(), sizeY = myArray->SizeY();
   float *src;
   
   image.SetSize(sizeX,sizeY);
   image.SetBitDepth(24);
   src = myArray->Buffer();

   for (y=0; y<sizeY; y++ )   {
      for (x=0; x<sizeX; x++ )   {
         float rr,gg,bb;

         rr = *src * 8.0;
         if(rr>1.0) rr=1.0;
         rr = 255.0*rr*(2.0-rr);
         gg = *src * 2.0;
         if(gg>1.0) gg=1.0;
         gg = 255.0*gg*gg*(3.0 - 2.0*gg);
         bb = *src;
         if(bb>1.0) bb=1.0;
         bb *= 255.0*bb;
         
         image(x,y)->Red   = int(rr);
         image(x,y)->Green = int(gg);
         image(x,y)->Blue  = int(bb);
         src++;
      }
   }
   image.WriteToFile(name);
}

void SaveDirRGB ( DirArray  *myArray, const char *name ) {
   BMP image;
   int x,y;
   int sizeX = myArray->SizeX(), sizeY = myArray->SizeY();
   Point2 *src;
   
   image.SetSize(sizeX,sizeY);
   image.SetBitDepth(24);
   src = myArray->Buffer();

   for (y=0; y<sizeY; y++ )   {
      for (x=0; x<sizeX; x++ )   {
         float rr,gg,bb,dd,phi;
         phi =  2.0*PI*src->Angle()*(1.0/360.0);
         rr = 0.5 + 0.5*cos(phi);
         gg = 0.5 + 0.5*cos(phi + 2.11);
         bb = 0.5 + 0.5*cos(phi + 4.11);
         dd = rr + gg + bb;
         dd = 1.0/dd;
         rr*=dd;gg*=dd;bb*=dd;
         dd = 20.0*src->Norm();
         rr*=dd;gg*=dd;bb*=dd;
         rr *= 255.0; gg *= 255.0; bb *= 255.0;
         if(rr>255.0)rr=255.0;
         if(gg>255.0)gg=255.0;
         if(bb>255.0)bb=255.0;

         image(x,y)->Red   = int(rr);
         image(x,y)->Green = int(gg);
         image(x,y)->Blue  = int(bb);
 
         src++;
      }
   }
   image.WriteToFile(name);
}
