/* ----------------------------------------------------------------

ImageEnlarger  -  resize, especially magnify bitmaps in high quality
    Array3D.h: 2-dim. vector-array

Copyright (C) 2009 Mischa Lusteck

This program is free software;
you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, see <http://www.gnu.org/licenses/>.

---------------------------------------------------------------------- */

#ifndef ARRAY_3D_H
#define ARRAY_3D_H

#include "PointClass.h"
#include "Array.h"
#include "ArraysTemplate.h"

using namespace std;

class MyArray3D : public BasicArray<Point> {

public:
   MyArray3D(void) : BasicArray<Point> () {}
   MyArray3D(int sx,int sy) : BasicArray<Point> (sx,sy) {}

   MyArray3D *SmoothDouble(void)   
      { return (MyArray3D *) BasicArray<Point>::SmoothDouble(); }
   MyArray3D *ShrinkHalf(void)     
      { return (MyArray3D *) BasicArray<Point>::ShrinkHalf(); }
   MyArray3D *Shrink(int sizeXNew, int sizeYNew)   
      { return (MyArray3D *) BasicArray<Point>::Shrink(sizeXNew,sizeYNew); }
   MyArray3D *BlockyPixEnlarge(int sizeXNew, int sizeYNew)
      { return (MyArray3D *) BasicArray<Point>::BlockyPixEnlarge(sizeXNew,sizeYNew); }
   MyArray3D *SplitLowFreq(int lenExp)
      { return (MyArray3D *) BasicArray<Point>::SplitLowFreq(lenExp); }
   MyArray3D *Smooth(void)
      { return (MyArray3D *) BasicArray<Point>::Smooth(); }
   MyArray3D *Clip(int leftX,int topY,int sizeXNew, int sizeYNew)
      { return (MyArray3D *) BasicArray<Point>::Clip(leftX, topY, sizeXNew,  sizeYNew); }
   
   MyArray *NormArray(void);
   DirArray *Direction(void);
   void Clamp01(void);
   void ReduceNoise0(void);
   void ReduceNoise(float reduceF);
   void HiSharpen(float f);
   void HiSharpen0(float f);
   void AddWaves(float f);
   void SmoothenWithDir(DirArray *dir);
   void SmoothenWithDir0(void);

};


#endif
