/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.LipstikLookAndFeel;
import com.lipstikLF.theme.LipstikColorTheme;
import com.lipstikLF.util.LipstikBorderFactory;
import com.lipstikLF.util.LipstikGradients;
import com.lipstikLF.util.LipstikListenerFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.RootPaneUI;

public class LipstikTitlePane
extends JComponent {
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Icon maximizeIcon;
    private Icon minimizeIcon;
    private WindowListener windowListener;
    private Window window;
    private JRootPane rootPane;
    private int state;

    public LipstikTitlePane(JRootPane root, RootPaneUI ui) {
        this.rootPane = root;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    public void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = new WindowHandler();
            this.propertyChangeListener = new PropertyChangeHandler();
            this.window.addWindowListener(this.windowListener);
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        int style = this.getWindowDecorationStyle();
        if (style == 1) {
            this.createActions();
            this.createButtons();
            this.add(this.createMenuBar());
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
        } else if (style == 2 || style == 3 || style == 4 || style == 5 || style == 6 || style == 7 || style == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setOpaque(false);
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(false);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        this.iconifyAction = new IconifyAction();
        this.restoreAction = new RestoreAction();
        this.maximizeAction = new MaximizeAction();
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("WW");
        menu.setOpaque(false);
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        JMenuItem mi = menu.add(this.restoreAction);
        int mnemonic = LipstikTitlePane.getInt("MetalTitlePane.restoreMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
        mi = menu.add(this.iconifyAction);
        mnemonic = LipstikTitlePane.getInt("MetalTitlePane.iconifyMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            mi = menu.add(this.maximizeAction);
            mnemonic = LipstikTitlePane.getInt("MetalTitlePane.maximizeMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
        }
        menu.add(new JSeparator());
        mi = menu.add(this.closeAction);
        mnemonic = LipstikTitlePane.getInt("MetalTitlePane.closeMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
    }

    private JButton createTitleButton() {
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(false);
        return button;
    }

    private void createButtons() {
        LipstikBorderFactory.OptionalMatteBorder handyEmptyBorder = LipstikBorderFactory.getOptionalMatteBorder();
        MouseAdapter handler = LipstikListenerFactory.getFrameButtonMouseHandler();
        this.maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.closeButton.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        this.closeButton.setOpaque(true);
        this.closeButton.addMouseListener(handler);
        this.iconifyButton = this.createTitleButton();
        this.iconifyButton.setAction(this.iconifyAction);
        this.iconifyButton.setText(null);
        this.iconifyButton.setBorder(handyEmptyBorder);
        this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
        this.iconifyButton.setIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
        this.iconifyButton.setOpaque(true);
        this.iconifyButton.addMouseListener(handler);
        this.toggleButton = this.createTitleButton();
        this.toggleButton.setAction(this.restoreAction);
        this.toggleButton.setBorder(handyEmptyBorder);
        this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
        this.toggleButton.setIcon(this.maximizeIcon);
        this.toggleButton.setOpaque(true);
        this.toggleButton.addMouseListener(handler);
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        if (this.getWindowDecorationStyle() == 1) {
            Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
            this.iconifyButton.putClientProperty("paintActive", activeB);
            this.closeButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, this.minimizeIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.toggleButton.setText(null);
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    public Window getWindow() {
        return this.window;
    }

    public void paintComponent(Graphics g) {
        ColorUIResource buttonColor;
        Color fontColor;
        Color backColor;
        LipstikColorTheme theme = LipstikLookAndFeel.getMyCurrentTheme();
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        if (this.window.isActive()) {
            backColor = UIManager.getColor("InternalFrame.activeTitleBackground");
            fontColor = UIManager.getColor("InternalFrame.activeTitleForeground");
            buttonColor = theme.getInternalButtonBackground();
        } else {
            backColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
            fontColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
            buttonColor = theme.getInternalButtonInactive();
        }
        LipstikGradients.drawGradient(g, backColor, null, 0, 0, this.getWidth(), this.getHeight(), true);
        if (this.toggleButton != null) {
            this.toggleButton.setBackground(buttonColor);
        }
        if (this.iconifyButton != null) {
            this.iconifyButton.setBackground(buttonColor);
        }
        if (this.closeButton != null) {
            this.closeButton.setBackground(buttonColor);
        }
        String title = null;
        if (this.window instanceof Frame) {
            title = ((Frame)this.window).getTitle();
        } else if (this.window instanceof Dialog) {
            title = ((Dialog)this.window).getTitle();
        }
        if (title != null) {
            g.setFont(UIManager.getFont("InternalFrame.font"));
            g.setColor(fontColor);
            FontMetrics fm = g.getFontMetrics();
            int yOffset = (this.getHeight() - fm.getHeight()) / 2 + fm.getAscent() + 1;
            int xOffset = 8;
            if (this.menuBar != null) {
                xOffset += 16;
            }
            g.drawString(title, xOffset, yOffset);
        }
    }

    static int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException nfe) {
                System.err.println(nfe);
            }
        }
        return defaultValue;
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", LipstikTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            LipstikTitlePane.this.close();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", LipstikTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            LipstikTitlePane.this.iconify();
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", LipstikTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            LipstikTitlePane.this.maximize();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = LipstikTitlePane.this.getFrame();
                if (frame != null) {
                    LipstikTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    LipstikTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                LipstikTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                LipstikTitlePane.this.revalidate();
                LipstikTitlePane.this.repaint();
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", LipstikTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            LipstikTitlePane.this.restore();
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        public void paint(Graphics g) {
            Image image;
            Frame frame = LipstikTitlePane.this.getFrame();
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (image != null) {
                g.drawImage(image, 0, 0, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, 0);
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(16, size.width), Math.max(size.height, 16));
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight(c);
            return new Dimension(height, height);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight(Container c) {
            FontMetrics fm = c.getGraphics().getFontMetrics();
            return fm.getHeight() + 5;
        }

        public void layoutContainer(Container c) {
            int buttonWidth;
            int buttonHeight;
            boolean leftToRight = c.getComponentOrientation().isLeftToRight();
            int w = LipstikTitlePane.this.getWidth();
            int spacing = 3;
            if (LipstikTitlePane.this.closeButton != null && LipstikTitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = LipstikTitlePane.this.closeButton.getIcon().getIconHeight() + 5;
                buttonWidth = LipstikTitlePane.this.closeButton.getIcon().getIconWidth() + 5;
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            int x = leftToRight ? spacing : w - buttonWidth - spacing;
            int y = LipstikTitlePane.this.getHeight() / 2 - buttonHeight / 2;
            if (LipstikTitlePane.this.menuBar != null) {
                LipstikTitlePane.this.menuBar.setBounds(x, y, 16, 16);
            }
            int n = x = leftToRight ? w : 0;
            if (LipstikTitlePane.this.closeButton != null) {
                LipstikTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (LipstikTitlePane.this.toggleButton != null && LipstikTitlePane.this.toggleButton.isEnabled()) {
                LipstikTitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (LipstikTitlePane.this.iconifyButton != null) {
                LipstikTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent ev) {
            LipstikTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent ev) {
            LipstikTitlePane.this.setActive(false);
        }
    }
}

