/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.util.LipstikBorderFactory;
import com.lipstikLF.util.LipstikGradients;
import com.lipstikLF.util.LipstikListenerFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class LipstikButtonUI
extends BasicButtonUI {
    private static final LipstikButtonUI _buttonUI = new LipstikButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return _buttonUI;
    }

    public void installUI(JComponent c) {
        if (c.getParent() instanceof JToolBar) {
            c.addMouseListener(LipstikListenerFactory.getButtonRolloverMouseListener());
        }
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (c.getParent() instanceof JToolBar) {
            c.removeMouseListener(LipstikListenerFactory.getButtonRolloverMouseListener());
        }
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b;
        if (c.isOpaque() && (b = (AbstractButton)c).isContentAreaFilled()) {
            ButtonModel model = b.getModel();
            if (this.is3D(b) && !model.isSelected()) {
                if (b.isRolloverEnabled() && !model.isRollover()) {
                    g.setColor(b.getParent().getBackground());
                    g.fillRect(0, 0, c.getWidth(), c.getHeight());
                } else {
                    LipstikGradients.drawGradient(g, b.getBackground(), null, 1, 1, c.getWidth() - 2, c.getHeight() - 2, true);
                }
            } else {
                Color bg = b.getBackground();
                if (model.isSelected() || model.isPressed()) {
                    bg = new Color(Math.max(bg.getRed() - 10, 0), Math.max(bg.getGreen() - 10, 0), Math.max(bg.getBlue() - 10, 0));
                }
                g.setColor(bg);
                g.fillRect(1, 1, c.getWidth() - 2, c.getHeight() - 2);
            }
        }
        super.paint(g, c);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!(b.getParent() instanceof JToolBar) && !b.isRolloverEnabled()) {
            LipstikBorderFactory.paintFocusBorder(g, 2, 2, b.getWidth() - 4, b.getHeight() - 4);
        }
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        ButtonModel model = b.getModel();
        if (model.isPressed() && model.isArmed() && b instanceof JButton) {
            ++textRect.x;
            ++textRect.y;
        }
        super.paintText(g, b, textRect, text);
    }

    private boolean is3D(AbstractButton b) {
        ButtonModel model = b.getModel();
        return b.isBorderPainted() && (!model.isPressed() || !model.isArmed()) && !(b.getBorder() instanceof EmptyBorder);
    }
}

