# Guayadeque Music Player

Guayadeque is a lightweight and easy-to-use music player and music collection organizer
that can easily manage large music collections and supports smart playlists.
In the technical side, it's written in C++, uses the wxWidgets toolkit and the
GStreamer media framework.

Tiago T Barrionuevo [<thothix@protonmail.com>](mailto:thothix@protonmail.com)  
see [LICENSE](LICENSE)

- [Github](https://github.com/thothix/guayadeque)
- [Latest release](https://github.com/thothix/guayadeque/releases/latest)

# NOTICE

### Guayadeque development is back

The announcement by @anonbeat that Guayadeque project has reached the end of its development and
was no longer actively maintained let us very sad because you know, we Guayadeque users love it so much!

That said, I want to say I am following @anonbeat track and continuing the Guayadeque development.
The main focus right now is keeping it running in the most recent Linux releases and fixing issues.

**We want to thank @anonbeat** for his amazing work to bring us the incredible music player that
Guayadeque is and thank him for his support throughout the years. **We also want to thank @openmonk**
for his invaluable contributions to Guayadeque development.

# General

For installation instructions please read [INSTALL.md](INSTALL.md).

For documentation (work in progress) please read the [wiki](https://github.com/thothix/guayadeque/wiki).

For Radios information and advices please read [RADIOS.md](RADIOS.md).

For bugs, feature requests or suggestions please check [Github Issues](https://github.com/thothix/guayadeque/issues) and open one if needed.  

For translations please send an email to [<thothix@protonmail.com>](mailto:thothix@protonmail.com?subject=Guayadeque%20Translations).

[Discussions](https://github.com/thothix/guayadeque/discussions) - Guayadeque GitHub discussions that are not feature requests or bugs.

Special Thanks to Mrmotinjo (Stefan Bogdanovic http://evilsun.carbonmade.com)  
for the icon and splash designed for guayadeque.

# Features

Main features include:

- Play MP3, Ogg, Opus, FLAC, WAV, WMA, MP4, AAC, AIFF, ASF, WV (WavPack), MPC (Musepack Audio), APE (Monkey's Audio), TrueAudio.
- Multiple collections support. You can get separated sets of tracks (Library) with its configuration, layouts, playlists and so on.
- Read and write tags in all supported formats.
- Tracks tag editor with automatically fetching of tags information for easily completion.
- Smart play mode that add tracks that fit your music taste using the tracks currently in the playlist.
- Allow to catalogue your music using labels. Any track, artist or album can have as many labels you want.
- Allow fast access to any music file by genre, artist, album.
- Audio equalizer.
- Configurable cross fader engine.
- Configurable silence detector to avoid listening to silence between tracks.
- Dynamic and static playlists management.
- Play and rip audio CDs.
- CUE sheet support.
- Ability to download covers automatically or manually.
- Lyrics downloads from different lyrics providers.
- Rate tracks from 0 to 5 stars.
- Record from internet radios.
- Desktop notifications.
- MPRIS D-Bus interface support so it can be easily controlled from music applets for example.
- Allow to resume play status and position when closed and reopened.
- Allow to subscribe to podcasts and download all new episodes automatically or manually.
- Play and record shoutcast radios.
- Allow searching for an artist or a track in shoutcast radios.
- Suggest music using last.fm service.
- Last.fm audioscrobbling support.
- Easily expandable contextual links support. Find information about a track, an artist or
  an album on your favourite site.
- Easily expandable contextual commands support. Set of preconfigured commands like an option to record the album in a burning application.
 Create custom commands easily.
- Option to copy the selection you want to a directory or device like USB players and IPod
  using a configurable pattern you added.
- Partial GNOME session support to detect when GNOME session is about to close and save the play list so it can continue next time with the same tracks.
- ... and many more.

# Copyright

Copyright (C) 2008-2023 J.Rios <anonbeat@gmail.com>\
Copyright (C) 2024-2026 Tiago T Barrionuevo <thothix@protonmail.com>

Guayadeque is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Guayadeque is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Guayadeque. If not, see https://www.gnu.org/licenses/.
