/*
 * Decompiled with CFR 0.152.
 */
package bdvm.vm;

import bdvm.vm.common;
import bdvm.vm.conv_tab_subtables;
import java.io.File;
import java.io.FileOutputStream;

public class conv_tab_main {
    public int subtableCount = 0;
    private static final int maxSubtables = 255;
    private conv_tab_subtables[] subtables = new conv_tab_subtables[255];

    public void setConversionTable(byte[] conversionTable) {
        byte[] BA_subtableCount = new byte[4];
        int address = 0;
        System.arraycopy(conversionTable, address, BA_subtableCount, 2, 2);
        int newSubtableCount = common.byteArrayToInt(BA_subtableCount, 0);
        address += 2;
        System.err.format("[I] TRAP_GetConversionTable: Received new subtables: ", new Object[0]);
        for (int i = 0; i < newSubtableCount; ++i) {
            int subtableID = common.byteArrayToInt(conversionTable, address);
            if (this.subtables[subtableID] == null) {
                this.subtables[subtableID] = new conv_tab_subtables(conversionTable, address);
                ++this.subtableCount;
            }
            address += this.subtables[subtableID].length();
        }
        System.err.format("\n", new Object[0]);
    }

    public int length() {
        int length = 2;
        for (int i = 0; i < 255; ++i) {
            if (this.subtables[i] == null) continue;
            length += this.subtables[i].length();
        }
        return length;
    }

    public boolean getNextSegmentID(int[] segmentID) {
        for (int i = 0; i < 255; ++i) {
            if (this.subtables[i] == null || this.subtables[i].getFirstEncryptedNonemptySegmentNumber() == -1) continue;
            segmentID[0] = this.subtables[i].subtable_id;
            segmentID[1] = this.subtables[i].getFirstEncryptedNonemptySegmentNumber();
            return true;
        }
        return false;
    }

    private int getSubtableIndex(int tableID) {
        for (int i = 0; i < 255; ++i) {
            if (this.subtables[i] == null || this.subtables[i].subtable_id != tableID) continue;
            return i;
        }
        return -1;
    }

    public boolean decryptSegment(int tableID, int segmentNumber, byte[] segmentKey) {
        return this.subtables[this.getSubtableIndex(tableID)].decryptSegment(segmentNumber, segmentKey);
    }

    public void checkSegment(int tableID, int segmentNumber, byte[] segmentMask) {
        this.subtables[this.getSubtableIndex(tableID)].checkSegment(segmentNumber, segmentMask);
    }

    public byte[] toByteArray() {
        int conversionTableLength = this.length();
        byte[] BA_conversionTable = new byte[conversionTableLength];
        BA_conversionTable[1] = (byte)this.subtableCount;
        BA_conversionTable[0] = (byte)(this.subtableCount >>> 8);
        int writeAddressSubtable = 2;
        for (int i = 0; i < 255; ++i) {
            if (this.subtables[i] == null) continue;
            byte[] BA_subtable = this.subtables[i].toByteArray(writeAddressSubtable);
            System.arraycopy(BA_subtable, 0, BA_conversionTable, writeAddressSubtable, BA_subtable.length);
            writeAddressSubtable += BA_subtable.length;
        }
        return BA_conversionTable;
    }

    public void dumpConversionTable() {
        try {
            File convf = new File("conv_tab.bin");
            FileOutputStream conv = new FileOutputStream(convf);
            conv.write(this.toByteArray());
            conv.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

