/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.SupTools;

import deadbeef.SupTools.Bitmap;
import deadbeef.SupTools.Core;
import deadbeef.SupTools.CoreException;
import deadbeef.SupTools.Palette;
import deadbeef.SupTools.SubPicture;
import deadbeef.SupTools.SubPictureHD;
import deadbeef.SupTools.Substream;
import deadbeef.Tools.BitStream;
import deadbeef.Tools.FileBuffer;
import deadbeef.Tools.FileBufferException;
import deadbeef.Tools.ToolBox;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

class SupHD
implements Substream {
    private final ArrayList<SubPictureHD> subPictures;
    private Palette palette;
    private Bitmap bitmap;
    private final FileBuffer buffer;
    private int primaryColorIndex;

    SupHD(String fname) throws CoreException {
        int index = 0;
        try {
            this.buffer = new FileBuffer(fname);
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
        int bufsize = (int)this.buffer.getSize();
        SubPictureHD pic = null;
        this.subPictures = new ArrayList();
        try {
            while (index < bufsize) {
                if (Core.isCancelled()) {
                    throw new CoreException("Cancelled by user!");
                }
                Core.setProgress(index);
                if (this.buffer.getWord(index) != 21328) {
                    throw new CoreException("ID 'SP' missing at index " + ToolBox.hex(index, 8) + "\n");
                }
                int masterIndex = index + 10;
                pic = new SubPictureHD();
                pic.width = 1920;
                pic.height = 1080;
                Core.printX("#" + (this.subPictures.size() + 1) + "\n");
                pic.startTime = this.buffer.getDWordLE(index += 2);
                int packetSize = this.buffer.getDWord(index += 10);
                int ofsCmd = this.buffer.getDWord(index += 4) + masterIndex;
                pic.imageBufferSize = ofsCmd - (index + 4);
                index = ofsCmd;
                int dcsq = this.buffer.getWord(index);
                pic.startTime += (long)(dcsq * 1024);
                Core.printX("DCSQ start    ofs: " + ToolBox.hex(index, 8) + "  (" + ToolBox.ptsToTimeStr(pic.startTime) + ")\n");
                int nextIndex = this.buffer.getDWord(index += 2) + masterIndex;
                index += 5;
                int cmd = 0;
                boolean stopDisplay = false;
                boolean stopCommand = false;
                int alphaSum = 0;
                int minAlphaSum = 65536;
                while (!stopDisplay) {
                    cmd = this.buffer.getByte(index++);
                    switch (cmd) {
                        case 1: {
                            Core.printX("DCSQ start    ofs: " + ToolBox.hex(index, 8) + "  (" + ToolBox.ptsToTimeStr(pic.startTime + (long)(dcsq * 1024)) + ")\n");
                            Core.printWarn("DCSQ start ignored due to missing DCSQ stop\n");
                            break;
                        }
                        case 2: {
                            stopDisplay = true;
                            pic.endTime = pic.startTime + (long)(dcsq * 1024);
                            Core.printX("DCSQ stop     ofs: " + ToolBox.hex(index, 8) + "  (" + ToolBox.ptsToTimeStr(pic.endTime) + ")\n");
                            break;
                        }
                        case 131: {
                            Core.print("Palette info  ofs: " + ToolBox.hex(index, 8) + "\n");
                            pic.paletteOfs = index;
                            index += 768;
                            break;
                        }
                        case 132: {
                            Core.print("Alpha info    ofs: " + ToolBox.hex(index, 8) + "\n");
                            alphaSum = 0;
                            int i = index;
                            while (i < index + 256) {
                                alphaSum += this.buffer.getByte(i);
                                ++i;
                            }
                            if (alphaSum < minAlphaSum) {
                                pic.alphaOfs = index;
                                minAlphaSum = alphaSum;
                            } else {
                                Core.printWarn("Found faded alpha buffer -> alpha buffer skipped\n");
                            }
                            index += 256;
                            break;
                        }
                        case 133: {
                            pic.setOfsX(this.buffer.getByte(index) << 4 | this.buffer.getByte(index + 1) >> 4);
                            pic.setImageWidth(((this.buffer.getByte(index + 1) & 0xF) << 8 | this.buffer.getByte(index + 2)) - pic.getOfsX() + 1);
                            pic.setOfsY(this.buffer.getByte(index + 3) << 4 | this.buffer.getByte(index + 4) >> 4);
                            pic.setImageHeight(((this.buffer.getByte(index + 4) & 0xF) << 8 | this.buffer.getByte(index + 5)) - pic.getOfsY() + 1);
                            Core.print("Area info     ofs: " + ToolBox.hex(index, 8) + "  (" + pic.getOfsX() + ", " + pic.getOfsY() + ") - (" + (pic.getOfsX() + pic.getImageWidth()) + ", " + (pic.getOfsY() + pic.getImageHeight()) + ")\n");
                            index += 6;
                            break;
                        }
                        case 134: {
                            pic.imageBufferOfsEven = this.buffer.getDWord(index) + masterIndex;
                            pic.imageBufferOfsOdd = this.buffer.getDWord(index + 4) + masterIndex;
                            Core.print("RLE buffers   ofs: " + ToolBox.hex(index, 8) + "  (even: " + ToolBox.hex(pic.imageBufferOfsEven, 8) + ", odd: " + ToolBox.hex(pic.imageBufferOfsOdd, 8) + "\n");
                            index += 8;
                            break;
                        }
                        case 255: {
                            int d;
                            if (stopCommand) {
                                Core.printWarn("DCSQ stop missing.\n");
                                ++index;
                                while (index < bufsize) {
                                    if (this.buffer.getByte(index++) != 255) {
                                        --index;
                                        break;
                                    }
                                    ++index;
                                }
                                stopDisplay = true;
                                break;
                            }
                            index = nextIndex;
                            dcsq = d = this.buffer.getWord(index);
                            nextIndex = this.buffer.getDWord(index + 2) + masterIndex;
                            stopCommand = index == nextIndex;
                            Core.print("DCSQ          ofs: " + ToolBox.hex(index, 8) + "  (" + d * 1024 / 90 + "ms),    next DCSQ at ofs: " + ToolBox.hex(nextIndex, 8) + "\n");
                            index += 6;
                            break;
                        }
                        default: {
                            throw new CoreException("Unexpected command " + cmd + " at index " + ToolBox.hex(index, 8));
                        }
                    }
                }
                index = masterIndex + packetSize;
                this.subPictures.add(pic);
            }
        }
        catch (CoreException ex) {
            if (this.subPictures.size() == 0) {
                throw ex;
            }
            Core.printErr(String.valueOf(ex.getMessage()) + "\n");
            Core.print("Probably not all caption imported due to error.\n");
        }
        catch (FileBufferException ex) {
            if (this.subPictures.size() == 0) {
                throw new CoreException(ex.getMessage());
            }
            Core.printErr(String.valueOf(ex.getMessage()) + "\n");
            Core.print("Probably not all caption imported due to error.\n");
        }
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }

    private static void decodeLine(byte[] trg, int trgOfs, int width, int maxPixels, BitStream src) {
        int x = 0;
        int pixelsLeft = 0;
        int sumPixels = 0;
        boolean lf = false;
        while (src.bitsLeft() > 0 && sumPixels < maxPixels) {
            int numPixels;
            int rleType = src.readBits(1);
            int colorType = src.readBits(1);
            int color = colorType == 1 ? src.readBits(8) : src.readBits(2);
            if (rleType == 1) {
                int rleSize = src.readBits(1);
                if (rleSize == 1) {
                    numPixels = src.readBits(7) + 9;
                    if (numPixels == 9) {
                        numPixels = width - x;
                    }
                } else {
                    numPixels = src.readBits(3) + 2;
                }
            } else {
                numPixels = 1;
            }
            if (x + numPixels == width) {
                src.syncToByte();
                lf = true;
            }
            sumPixels += numPixels;
            if (x + numPixels > width) {
                pixelsLeft = x + numPixels - width;
                numPixels = width - x;
                lf = true;
            } else {
                pixelsLeft = 0;
            }
            int i = 0;
            while (i < numPixels) {
                trg[trgOfs + x + i] = (byte)color;
                ++i;
            }
            if (lf) {
                trgOfs += x + numPixels + width;
                x = pixelsLeft;
                lf = false;
            } else {
                x += numPixels;
            }
            i = 0;
            while (i < pixelsLeft) {
                trg[trgOfs + i] = (byte)color;
                ++i;
            }
        }
    }

    private Bitmap decodeImage(SubPictureHD pic, int transIdx) throws CoreException {
        int w = pic.getImageWidth();
        int h = pic.getImageHeight();
        int warnings = 0;
        if (w > pic.width || h > pic.height) {
            throw new CoreException("Subpicture too large: " + w + "x" + h + " at offset " + ToolBox.hex(pic.imageBufferOfsEven, 8));
        }
        Bitmap bm = new Bitmap(w, h, transIdx);
        int sizeEven = pic.imageBufferOfsOdd - pic.imageBufferOfsEven;
        int sizeOdd = pic.imageBufferSize + pic.imageBufferOfsEven - pic.imageBufferOfsOdd;
        if (sizeEven <= 0 || sizeOdd <= 0) {
            throw new CoreException("Corrupt buffer offset information");
        }
        byte[] evenBuf = new byte[sizeEven];
        byte[] oddBuf = new byte[sizeOdd];
        try {
            try {
                int i = 0;
                while (i < evenBuf.length) {
                    evenBuf[i] = (byte)this.buffer.getByte(pic.imageBufferOfsEven + i);
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            try {
                int i = 0;
                while (i < oddBuf.length) {
                    oddBuf[i] = (byte)this.buffer.getByte(pic.imageBufferOfsOdd + i);
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            try {
                BitStream even = new BitStream(evenBuf);
                SupHD.decodeLine(bm.getImg(), 0, w, w * (h / 2 + (h & 1)), even);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            try {
                BitStream odd = new BitStream(oddBuf);
                SupHD.decodeLine(bm.getImg(), w, w, h / 2 * w, odd);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ++warnings;
            }
            if (warnings > 0) {
                Core.printWarn("problems during RLE decoding of picture at offset " + ToolBox.hex(pic.imageBufferOfsEven, 8) + "\n");
            }
            return bm;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private Palette decodePalette(SubPictureHD pic) throws CoreException {
        int ofs = pic.paletteOfs;
        int alphaOfs = pic.alphaOfs;
        Palette palette = new Palette(256);
        try {
            int i = 0;
            while (i < palette.getSize()) {
                int cr;
                int cb;
                int y = this.buffer.getByte(ofs++);
                if (Core.getSwapCrCb()) {
                    cb = this.buffer.getByte(ofs++);
                    cr = this.buffer.getByte(ofs++);
                } else {
                    cr = this.buffer.getByte(ofs++);
                    cb = this.buffer.getByte(ofs++);
                }
                int alpha = 255 - this.buffer.getByte(alphaOfs++);
                if (alpha < Core.getAlphaCrop()) {
                    palette.setRGB(i, 0, 0, 0);
                } else {
                    palette.setYCbCr(i, y, cb, cr);
                }
                palette.setAlpha(i, alpha);
                ++i;
            }
            return palette;
        }
        catch (FileBufferException ex) {
            throw new CoreException(ex.getMessage());
        }
    }

    private void decode(SubPictureHD pic) throws CoreException {
        this.palette = this.decodePalette(pic);
        this.bitmap = this.decodeImage(pic, this.palette.getTransparentIndex());
        this.primaryColorIndex = this.bitmap.getPrimaryColorIndex(this.palette, Core.getAlphaThr());
    }

    @Override
    public void decode(int index) throws CoreException {
        if (index >= this.subPictures.size()) {
            throw new CoreException("Index " + index + " out of bounds\n");
        }
        this.decode(this.subPictures.get(index));
    }

    @Override
    public Palette getPalette() {
        return this.palette;
    }

    @Override
    public Bitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public BufferedImage getImage() {
        return this.bitmap.getImage(this.palette);
    }

    @Override
    public BufferedImage getImage(Bitmap bm) {
        return bm.getImage(this.palette);
    }

    @Override
    public int getPrimaryColorIndex() {
        return this.primaryColorIndex;
    }

    @Override
    public SubPicture getSubPicture(int index) {
        return this.subPictures.get(index);
    }

    @Override
    public int getNumFrames() {
        return this.subPictures.size();
    }

    @Override
    public int getNumForcedFrames() {
        return 0;
    }

    @Override
    public boolean isForced(int index) {
        return false;
    }

    @Override
    public long getEndTime(int index) {
        return this.subPictures.get((int)index).endTime;
    }

    @Override
    public long getStartTime(int index) {
        return this.subPictures.get((int)index).startTime;
    }

    @Override
    public long getStartOffset(int index) {
        return this.subPictures.get((int)index).imageBufferOfsEven;
    }
}

