/*
 * Decompiled with CFR 0.152.
 */
package deadbeef.GUI;

import deadbeef.GUI.EditPane;
import deadbeef.SupTools.Core;
import deadbeef.SupTools.CoreException;
import deadbeef.SupTools.SubPicture;
import deadbeef.Tools.ToolBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MoveDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanelUp = null;
    private JPanel jPanelLayout = null;
    private JPanel jPanelOffsets = null;
    private JPanel jPanelMove = null;
    private JPanel jPanelButtons = null;
    private JLabel jLabelInfo = null;
    private JButton jButtonPrev = null;
    private JButton jButtonNext = null;
    private EditPane jPanelPreview = null;
    private JLabel jLabelRatio = null;
    private JLabel jLabelOffsetY = null;
    private JButton jButtonCancel = null;
    private JButton jButtonOk = null;
    private JTextField jTextFieldRatio = null;
    private JTextField jTextFieldOffsetY = null;
    private JButton jButton21_9 = null;
    private JLabel jLabelRatio1 = null;
    private JButton jButton240_1 = null;
    private JButton jButton235_1 = null;
    private JRadioButton jRadioButtonKeepY = null;
    private JRadioButton jRadioButtonInside = null;
    private JRadioButton jRadioButtonOutside = null;
    private ButtonGroup radioButtonsY = null;
    private ButtonGroup radioButtonsX = null;
    private JPanel jPanelCrop = null;
    private JLabel jLabelCropOfsY = null;
    private JTextField jTextFieldCropOfsY = null;
    private JButton jButtonCropBars = null;
    private JRadioButton jRadioButtonKeepX = null;
    private JRadioButton jRadioButtonLeft = null;
    private JRadioButton jRadioButtonRight = null;
    private JLabel jLabelOffsetX = null;
    private JTextField jTextFieldOffsetX = null;
    private JRadioButton jRadioButtonCenter = null;
    private static final int miniWidth = 384;
    private static final int miniHeight = 216;
    private static double screenRatioTrg = 2.3333333333333335;
    private static final double screenRatio = 1.7777777777777777;
    private final Color errBgnd = new Color(-1987412);
    private final Color okBgnd = UIManager.getColor("TextField.background");
    private BufferedImage image = null;
    private Core.MoveModeY moveModeY = Core.MoveModeY.KEEP;
    private Core.MoveModeX moveModeX = Core.MoveModeX.KEEP;
    private int originalX;
    private int originalY;
    private int index;
    private SubPicture subPic;
    private int offsetY;
    private int offsetX;
    private double cineBarFactor = 0.11904761904761904;
    private int cropOfsY = Core.getCropOfsY();
    private volatile boolean isReady = false;
    private static final Dimension dimLabel = new Dimension(70, 14);
    private static final Dimension dimText = new Dimension(40, 20);

    public MoveDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize();
        Point p = owner.getLocation();
        this.setLocation(p.x + owner.getWidth() / 2 - this.getWidth() / 2, p.y + owner.getHeight() / 2 - this.getHeight() / 2);
        this.setResizable(false);
        this.offsetX = Core.getMoveOffsetX();
        this.offsetY = Core.getMoveOffsetY();
        this.moveModeX = Core.getMoveModeX();
        this.moveModeY = Core.getMoveModeY();
        switch (this.moveModeY) {
            case KEEP: {
                this.jRadioButtonKeepY.setSelected(true);
                break;
            }
            case INSIDE: {
                this.jRadioButtonInside.setSelected(true);
                break;
            }
            case OUTSIDE: {
                this.jRadioButtonOutside.setSelected(true);
            }
        }
        switch (this.moveModeX) {
            case KEEP: {
                this.jRadioButtonKeepX.setSelected(true);
                break;
            }
            case LEFT: {
                this.jRadioButtonLeft.setSelected(true);
                break;
            }
            case RIGHT: {
                this.jRadioButtonRight.setSelected(true);
                break;
            }
            case CENTER: {
                this.jRadioButtonCenter.setSelected(true);
            }
        }
        this.radioButtonsY = new ButtonGroup();
        this.radioButtonsY.add(this.jRadioButtonKeepY);
        this.radioButtonsY.add(this.jRadioButtonInside);
        this.radioButtonsY.add(this.jRadioButtonOutside);
        this.radioButtonsX = new ButtonGroup();
        this.radioButtonsX.add(this.jRadioButtonKeepX);
        this.radioButtonsX.add(this.jRadioButtonLeft);
        this.radioButtonsX.add(this.jRadioButtonRight);
        this.radioButtonsX.add(this.jRadioButtonCenter);
        this.jTextFieldRatio.setText(ToolBox.formatDouble(screenRatioTrg));
        this.jTextFieldOffsetY.setText("" + this.offsetY);
        this.jTextFieldOffsetX.setText("" + this.offsetX);
        this.jTextFieldCropOfsY.setText(ToolBox.formatDouble(screenRatioTrg));
        this.jTextFieldCropOfsY.setText("" + this.cropOfsY);
    }

    private void initialize() {
        this.setSize(392, 546);
        this.setTitle("Move all captions");
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MoveDialog.this.dispose();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagPanelCrop = new GridBagConstraints();
            gridBagPanelCrop.gridx = 0;
            gridBagPanelCrop.weightx = 1.0;
            gridBagPanelCrop.weighty = 1.0;
            gridBagPanelCrop.anchor = 18;
            gridBagPanelCrop.fill = 2;
            gridBagPanelCrop.gridy = 4;
            GridBagConstraints gridBagPanelButtons = new GridBagConstraints();
            gridBagPanelButtons.gridx = 0;
            gridBagPanelButtons.anchor = 18;
            gridBagPanelButtons.weightx = 1.0;
            gridBagPanelButtons.weighty = 0.0;
            gridBagPanelButtons.fill = 2;
            gridBagPanelButtons.gridy = 5;
            GridBagConstraints gridBagPanelRadio = new GridBagConstraints();
            gridBagPanelRadio.gridx = 0;
            gridBagPanelRadio.anchor = 18;
            gridBagPanelRadio.weightx = 1.0;
            gridBagPanelRadio.weighty = 1.0;
            gridBagPanelRadio.fill = 2;
            gridBagPanelRadio.gridy = 2;
            GridBagConstraints gridBagPanelOffsets = new GridBagConstraints();
            gridBagPanelOffsets.gridx = 0;
            gridBagPanelOffsets.anchor = 18;
            gridBagPanelOffsets.weightx = 1.0;
            gridBagPanelOffsets.weighty = 1.0;
            gridBagPanelOffsets.fill = 2;
            gridBagPanelOffsets.gridy = 3;
            GridBagConstraints gridBagPanelLayout = new GridBagConstraints();
            gridBagPanelLayout.gridx = 0;
            gridBagPanelLayout.anchor = 18;
            gridBagPanelLayout.weightx = 1.0;
            gridBagPanelLayout.weighty = 1.0;
            gridBagPanelLayout.fill = 2;
            gridBagPanelLayout.gridy = 1;
            GridBagConstraints gridBagPanelUp = new GridBagConstraints();
            gridBagPanelUp.gridx = 0;
            gridBagPanelUp.anchor = 18;
            gridBagPanelUp.weightx = 1.0;
            gridBagPanelUp.weighty = 1.0;
            gridBagPanelUp.fill = 2;
            gridBagPanelUp.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJPanelUp(), gridBagPanelUp);
            this.jContentPane.add((Component)this.getJPanelLayout(), gridBagPanelLayout);
            this.jContentPane.add((Component)this.getJPanelOffsets(), gridBagPanelOffsets);
            this.jContentPane.add((Component)this.getJPanelMove(), gridBagPanelRadio);
            this.jContentPane.add((Component)this.getJPanelButtons(), gridBagPanelButtons);
            this.jContentPane.add((Component)this.getJPanelCrop(), gridBagPanelCrop);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelUp() {
        if (this.jPanelUp == null) {
            GridBagConstraints gridBagButtonNext = new GridBagConstraints();
            gridBagButtonNext.gridx = 2;
            gridBagButtonNext.anchor = 18;
            gridBagButtonNext.insets = new Insets(2, 4, 2, 9);
            gridBagButtonNext.gridy = 0;
            GridBagConstraints gridBagButtonPrev = new GridBagConstraints();
            gridBagButtonPrev.gridx = 1;
            gridBagButtonPrev.anchor = 18;
            gridBagButtonPrev.insets = new Insets(2, 4, 2, 4);
            gridBagButtonPrev.gridy = 0;
            GridBagConstraints gridBagInfo = new GridBagConstraints();
            gridBagInfo.weightx = 1.0;
            gridBagInfo.anchor = 17;
            gridBagInfo.insets = new Insets(4, 6, 0, 4);
            gridBagInfo.weighty = 1.0;
            this.jLabelInfo = new JLabel();
            this.jLabelInfo.setText("Info");
            this.jPanelUp = new JPanel();
            this.jPanelUp.setPreferredSize(new Dimension(200, 20));
            this.jPanelUp.setLayout(new GridBagLayout());
            this.jPanelUp.add((Component)this.jLabelInfo, gridBagInfo);
            this.jPanelUp.add((Component)this.getJButtonPrev(), gridBagButtonPrev);
            this.jPanelUp.add((Component)this.getJButtonNext(), gridBagButtonNext);
        }
        return this.jPanelUp;
    }

    private JPanel getJPanelLayout() {
        if (this.jPanelLayout == null) {
            GridBagConstraints gridBagPanelPreview = new GridBagConstraints();
            gridBagPanelPreview.gridx = 0;
            gridBagPanelPreview.anchor = 18;
            gridBagPanelPreview.weighty = 0.0;
            gridBagPanelPreview.gridy = 0;
            gridBagPanelPreview.insets = new Insets(0, 4, 0, 0);
            this.jPanelLayout = new JPanel();
            this.jPanelLayout.setLayout(new GridBagLayout());
            this.jPanelLayout.add((Component)this.getJPanelPreview(), gridBagPanelPreview);
        }
        return this.jPanelLayout;
    }

    private JPanel getJPanelOffsets() {
        if (this.jPanelOffsets == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 4;
            GridBagConstraints gridBagBtn235_1 = new GridBagConstraints();
            gridBagBtn235_1.gridx = 5;
            gridBagBtn235_1.insets = new Insets(0, 0, 0, 6);
            gridBagBtn235_1.anchor = 13;
            gridBagBtn235_1.gridy = 1;
            GridBagConstraints gridBagBtn240_1 = new GridBagConstraints();
            gridBagBtn240_1.gridx = 6;
            gridBagBtn240_1.insets = new Insets(0, 0, 0, 0);
            gridBagBtn240_1.anchor = 13;
            gridBagBtn240_1.gridy = 1;
            GridBagConstraints gridBagLabelRatio1 = new GridBagConstraints();
            gridBagLabelRatio1.gridx = 2;
            gridBagLabelRatio1.weightx = 20.0;
            gridBagLabelRatio1.anchor = 17;
            gridBagLabelRatio1.insets = new Insets(0, 6, 0, 0);
            gridBagLabelRatio1.gridy = 1;
            this.jLabelRatio1 = new JLabel();
            this.jLabelRatio1.setText(" : 1");
            this.jLabelRatio1.setHorizontalAlignment(2);
            this.jLabelRatio1.setHorizontalTextPosition(2);
            GridBagConstraints gridBagButtonBtn21_9 = new GridBagConstraints();
            gridBagButtonBtn21_9.gridx = 4;
            gridBagButtonBtn21_9.anchor = 13;
            gridBagButtonBtn21_9.insets = new Insets(0, 0, 0, 6);
            gridBagButtonBtn21_9.weightx = 0.0;
            gridBagButtonBtn21_9.gridy = 1;
            GridBagConstraints gridBagTextRatio = new GridBagConstraints();
            gridBagTextRatio.fill = 0;
            gridBagTextRatio.gridy = 1;
            gridBagTextRatio.weightx = 2.0;
            gridBagTextRatio.anchor = 17;
            gridBagTextRatio.insets = new Insets(0, 0, 0, 0);
            gridBagTextRatio.weighty = 0.0;
            gridBagTextRatio.gridx = 1;
            this.jLabelOffsetY = new JLabel();
            this.jLabelOffsetY.setText("Offset Y");
            this.jLabelOffsetY.setPreferredSize(dimLabel);
            this.jLabelOffsetY.setSize(dimLabel);
            this.jLabelOffsetY.setMinimumSize(dimLabel);
            this.jLabelOffsetY.setMaximumSize(dimLabel);
            GridBagConstraints gridBagLabelRatio = new GridBagConstraints();
            gridBagLabelRatio.gridx = 0;
            gridBagLabelRatio.anchor = 17;
            gridBagLabelRatio.weightx = 0.0;
            gridBagLabelRatio.weighty = 0.0;
            gridBagLabelRatio.insets = new Insets(0, 6, 0, 4);
            gridBagLabelRatio.gridy = 1;
            this.jLabelRatio = new JLabel();
            this.jLabelRatio.setText("Aspect ratio");
            this.jLabelRatio.setPreferredSize(dimLabel);
            this.jLabelRatio.setSize(dimLabel);
            this.jLabelRatio.setMinimumSize(dimLabel);
            this.jLabelRatio.setMaximumSize(dimLabel);
            this.jPanelOffsets = new JPanel();
            this.jPanelOffsets.setLayout(new GridBagLayout());
            this.jPanelOffsets.setBorder(BorderFactory.createTitledBorder(null, "Screen Ratio", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelOffsets.add((Component)this.jLabelRatio, gridBagLabelRatio);
            this.jPanelOffsets.add((Component)this.getJTextFieldRatio(), gridBagTextRatio);
            this.jPanelOffsets.add((Component)this.getJButton21_9(), gridBagButtonBtn21_9);
            this.jPanelOffsets.add((Component)this.jLabelRatio1, gridBagLabelRatio1);
            this.jPanelOffsets.add((Component)this.getJButton240_1(), gridBagBtn240_1);
            this.jPanelOffsets.add((Component)this.getJButton235_1(), gridBagBtn235_1);
        }
        return this.jPanelOffsets;
    }

    private JPanel getJPanelMove() {
        if (this.jPanelMove == null) {
            GridBagConstraints gridBagRadioCenter = new GridBagConstraints();
            gridBagRadioCenter.gridx = 0;
            gridBagRadioCenter.gridwidth = 2;
            gridBagRadioCenter.anchor = 17;
            gridBagRadioCenter.insets = new Insets(0, 4, 0, 0);
            gridBagRadioCenter.weightx = 1.0;
            gridBagRadioCenter.gridy = 3;
            GridBagConstraints gridBagTextOfsX = new GridBagConstraints();
            gridBagTextOfsX.gridy = 4;
            gridBagTextOfsX.weightx = 10.0;
            gridBagTextOfsX.insets = new Insets(0, 0, 0, 0);
            gridBagTextOfsX.anchor = 17;
            gridBagTextOfsX.gridx = 1;
            GridBagConstraints gridBagLabelOfsX = new GridBagConstraints();
            gridBagLabelOfsX.gridx = 0;
            gridBagLabelOfsX.insets = new Insets(0, 6, 0, 4);
            gridBagLabelOfsX.anchor = 17;
            gridBagLabelOfsX.weightx = 0.0;
            gridBagLabelOfsX.gridy = 4;
            this.jLabelOffsetX = new JLabel();
            this.jLabelOffsetX.setText("Offset X");
            this.jLabelOffsetX.setPreferredSize(dimLabel);
            this.jLabelOffsetX.setSize(dimLabel);
            this.jLabelOffsetX.setMinimumSize(dimLabel);
            this.jLabelOffsetX.setMaximumSize(dimLabel);
            GridBagConstraints gridBagTextOfsY = new GridBagConstraints();
            gridBagTextOfsY.anchor = 17;
            gridBagTextOfsY.insets = new Insets(0, 0, 0, 0);
            gridBagTextOfsY.gridwidth = 1;
            gridBagTextOfsY.gridx = 3;
            gridBagTextOfsY.gridy = 4;
            gridBagTextOfsY.weightx = 10.0;
            GridBagConstraints gridBagLabelOfsY = new GridBagConstraints();
            gridBagLabelOfsY.anchor = 17;
            gridBagLabelOfsY.gridx = 2;
            gridBagLabelOfsY.gridy = 4;
            gridBagLabelOfsY.weightx = 0.0;
            gridBagLabelOfsY.insets = new Insets(0, 6, 0, 4);
            GridBagConstraints gridBagRadioRight = new GridBagConstraints();
            gridBagRadioRight.gridx = 0;
            gridBagRadioRight.insets = new Insets(0, 4, 0, 0);
            gridBagRadioRight.anchor = 17;
            gridBagRadioRight.gridwidth = 2;
            gridBagRadioRight.weightx = 1.0;
            gridBagRadioRight.gridy = 2;
            GridBagConstraints gridBagRadioLeft = new GridBagConstraints();
            gridBagRadioLeft.gridx = 0;
            gridBagRadioLeft.anchor = 17;
            gridBagRadioLeft.insets = new Insets(0, 4, 0, 0);
            gridBagRadioLeft.gridwidth = 2;
            gridBagRadioLeft.weightx = 1.0;
            gridBagRadioLeft.gridy = 1;
            GridBagConstraints gridBagRadioKeepX = new GridBagConstraints();
            gridBagRadioKeepX.gridx = 0;
            gridBagRadioKeepX.insets = new Insets(0, 4, 0, 0);
            gridBagRadioKeepX.anchor = 17;
            gridBagRadioKeepX.gridwidth = 2;
            gridBagRadioKeepX.weightx = 1.0;
            gridBagRadioKeepX.gridy = 0;
            GridBagConstraints gridBagRadioKeepY = new GridBagConstraints();
            gridBagRadioKeepY.gridx = 2;
            gridBagRadioKeepY.anchor = 17;
            gridBagRadioKeepY.insets = new Insets(0, 4, 0, 0);
            gridBagRadioKeepY.gridwidth = 2;
            gridBagRadioKeepY.weightx = 1.0;
            gridBagRadioKeepY.gridy = 0;
            GridBagConstraints gridBagRadioOutside = new GridBagConstraints();
            gridBagRadioOutside.gridx = 2;
            gridBagRadioOutside.weightx = 1.0;
            gridBagRadioOutside.anchor = 17;
            gridBagRadioOutside.insets = new Insets(0, 4, 0, 0);
            gridBagRadioOutside.gridwidth = 2;
            gridBagRadioOutside.gridy = 2;
            GridBagConstraints gridBagRadioInside = new GridBagConstraints();
            gridBagRadioInside.anchor = 17;
            gridBagRadioInside.insets = new Insets(0, 4, 0, 0);
            gridBagRadioInside.gridy = 1;
            gridBagRadioInside.gridx = 2;
            gridBagRadioInside.gridwidth = 2;
            gridBagRadioInside.weightx = 1.0;
            this.jPanelMove = new JPanel();
            this.jPanelMove.setLayout(new GridBagLayout());
            this.jPanelMove.setBorder(BorderFactory.createTitledBorder(null, "Move", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelMove.add((Component)this.getJRadioButtonInside(), gridBagRadioInside);
            this.jPanelMove.add((Component)this.getJRadioButtonOutside(), gridBagRadioOutside);
            this.jPanelMove.add((Component)this.getJRadioButtonKeepY(), gridBagRadioKeepY);
            this.jPanelMove.add((Component)this.getJRadioButtonKeepX(), gridBagRadioKeepX);
            this.jPanelMove.add((Component)this.getJRadioButtonLeft(), gridBagRadioLeft);
            this.jPanelMove.add((Component)this.getJRadioButtonRight(), gridBagRadioRight);
            this.jPanelMove.add((Component)this.jLabelOffsetY, gridBagLabelOfsY);
            this.jPanelMove.add((Component)this.getJTextFieldOffsetY(), gridBagTextOfsY);
            this.jPanelMove.add((Component)this.jLabelOffsetX, gridBagLabelOfsX);
            this.jPanelMove.add((Component)this.getJTextFieldOffsetX(), gridBagTextOfsX);
            this.jPanelMove.add((Component)this.getJRadioButtonCenter(), gridBagRadioCenter);
        }
        return this.jPanelMove;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            GridBagConstraints gridBagButtonOk = new GridBagConstraints();
            gridBagButtonOk.insets = new Insets(0, 0, 2, 9);
            gridBagButtonOk.anchor = 13;
            gridBagButtonOk.gridx = 2;
            GridBagConstraints gridBagButtonCancel = new GridBagConstraints();
            gridBagButtonCancel.anchor = 17;
            gridBagButtonCancel.insets = new Insets(0, 6, 2, 0);
            gridBagButtonCancel.weightx = 1.0;
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setLayout(new GridBagLayout());
            this.jPanelButtons.add((Component)this.getJButtonCancel(), gridBagButtonCancel);
            this.jPanelButtons.add((Component)this.getJButtonOk(), gridBagButtonOk);
        }
        return this.jPanelButtons;
    }

    private JButton getJButtonPrev() {
        if (this.jButtonPrev == null) {
            this.jButtonPrev = new JButton();
            this.jButtonPrev.setText("  <  ");
            this.jButtonPrev.setMnemonic(37);
            this.jButtonPrev.setToolTipText("Lose changes and skip to previous frame");
            this.jButtonPrev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MoveDialog.this.index > 0) {
                        MoveDialog.this.setIndex(MoveDialog.this.index - 1);
                    }
                }
            });
        }
        return this.jButtonPrev;
    }

    private JButton getJButtonNext() {
        if (this.jButtonNext == null) {
            this.jButtonNext = new JButton();
            this.jButtonNext.setText("  >  ");
            this.jButtonNext.setMnemonic(39);
            this.jButtonNext.setToolTipText("Lose changes and skip to next frame");
            this.jButtonNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MoveDialog.this.index < Core.getNumFrames() - 1) {
                        MoveDialog.this.setIndex(MoveDialog.this.index + 1);
                    }
                }
            });
        }
        return this.jButtonNext;
    }

    private EditPane getJPanelPreview() {
        if (this.jPanelPreview == null) {
            this.jPanelPreview = new EditPane();
            this.jPanelPreview.setLayout(new GridBagLayout());
            Dimension dim = new Dimension(384, 216);
            this.jPanelPreview.setPreferredSize(dim);
            this.jPanelPreview.setSize(dim);
            this.jPanelPreview.setMinimumSize(dim);
            this.jPanelPreview.setMaximumSize(dim);
        }
        return this.jPanelPreview;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setMnemonic('c');
            this.jButtonCancel.setToolTipText("Lose changes and return");
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MoveDialog.this.dispose();
                }
            });
        }
        return this.jButtonCancel;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setText("Move all");
            this.jButtonOk.setMnemonic('m');
            this.jButtonOk.setPreferredSize(new Dimension(79, 23));
            this.jButtonOk.setToolTipText("Save changes and return");
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Core.setCropOfsY(MoveDialog.this.cropOfsY);
                    Core.setMoveModeX(MoveDialog.this.moveModeX);
                    Core.setMoveModeY(MoveDialog.this.moveModeY);
                    Core.setMoveOffsetX(MoveDialog.this.offsetX);
                    Core.setMoveOffsetY(MoveDialog.this.offsetY);
                    Core.setCineBarFactor(MoveDialog.this.cineBarFactor);
                    MoveDialog.this.dispose();
                }
            });
        }
        return this.jButtonOk;
    }

    private JTextField getJTextFieldRatio() {
        if (this.jTextFieldRatio == null) {
            this.jTextFieldRatio = new JTextField();
            this.jTextFieldRatio.setPreferredSize(dimText);
            this.jTextFieldRatio.setSize(dimText);
            this.jTextFieldRatio.setMinimumSize(dimText);
            this.jTextFieldRatio.setMaximumSize(dimText);
            this.jTextFieldRatio.setToolTipText("Set inner frame ratio");
            this.jTextFieldRatio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MoveDialog.this.isReady) {
                        double r = ToolBox.getDouble(MoveDialog.this.jTextFieldRatio.getText());
                        if (r == -1.0) {
                            r = screenRatioTrg;
                        } else if (r > 4.0) {
                            r = 4.0;
                        } else if (r < 1.7777777777777777) {
                            r = 1.7777777777777777;
                        }
                        if (r != screenRatioTrg) {
                            screenRatioTrg = r;
                            MoveDialog.this.setRatio(screenRatioTrg);
                        }
                        MoveDialog.this.jTextFieldRatio.setText(ToolBox.formatDouble(screenRatioTrg));
                    }
                }
            });
            this.jTextFieldRatio.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (MoveDialog.this.isReady) {
                        double r = ToolBox.getDouble(MoveDialog.this.jTextFieldRatio.getText());
                        if (r < 1.7777777777777777 || r > 4.0) {
                            MoveDialog.this.jTextFieldRatio.setBackground(MoveDialog.this.errBgnd);
                        } else {
                            if (!ToolBox.formatDouble(r).equalsIgnoreCase(ToolBox.formatDouble(screenRatioTrg))) {
                                screenRatioTrg = r;
                                MoveDialog.this.setRatio(screenRatioTrg);
                            }
                            MoveDialog.this.jTextFieldRatio.setBackground(MoveDialog.this.okBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldRatio;
    }

    private JTextField getJTextFieldOffsetY() {
        if (this.jTextFieldOffsetY == null) {
            this.jTextFieldOffsetY = new JTextField();
            this.jTextFieldOffsetY.setPreferredSize(dimText);
            this.jTextFieldOffsetY.setSize(dimText);
            this.jTextFieldOffsetY.setMinimumSize(dimText);
            this.jTextFieldOffsetY.setMaximumSize(dimText);
            this.jTextFieldOffsetY.setToolTipText("Set offset from lower/upper border in pixels");
            this.jTextFieldOffsetY.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MoveDialog.this.isReady) {
                        int y = ToolBox.getInt(MoveDialog.this.jTextFieldOffsetY.getText());
                        if (y == -1) {
                            y = MoveDialog.this.offsetY;
                        } else if (y < 0) {
                            y = 0;
                        } else if (y > ((MoveDialog)MoveDialog.this).subPic.height / 3) {
                            y = ((MoveDialog)MoveDialog.this).subPic.height / 3;
                        }
                        if (y != MoveDialog.this.offsetY) {
                            MoveDialog.this.offsetY = y;
                            MoveDialog.this.setRatio(screenRatioTrg);
                        }
                        MoveDialog.this.jTextFieldOffsetY.setText("" + MoveDialog.this.offsetY);
                    }
                }
            });
            this.jTextFieldOffsetY.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (MoveDialog.this.isReady) {
                        int y = ToolBox.getInt(MoveDialog.this.jTextFieldOffsetY.getText());
                        if (y < 0 || y > ((MoveDialog)MoveDialog.this).subPic.height / 3) {
                            MoveDialog.this.jTextFieldOffsetY.setBackground(MoveDialog.this.errBgnd);
                        } else {
                            if (y != MoveDialog.this.offsetY) {
                                MoveDialog.this.offsetY = y;
                                MoveDialog.this.setRatio(screenRatioTrg);
                            }
                            MoveDialog.this.jTextFieldOffsetY.setBackground(MoveDialog.this.okBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldOffsetY;
    }

    public void error(String s) {
        Core.printErr(s);
        JOptionPane.showMessageDialog(this, s, "Error!", 2);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.isReady = false;
        this.index = idx;
        try {
            Core.convertSup(idx, idx + 1, Core.getNumFrames());
            this.subPic = Core.getSubPictureTrg(idx).clone();
            this.image = Core.getTrgImagePatched(this.subPic);
            this.originalX = this.subPic.getOfsX();
            this.originalY = this.subPic.getOfsY();
            this.jLabelInfo.setText("Frame " + (idx + 1) + " of " + Core.getNumFrames());
            this.move();
            this.jPanelPreview.setOffsets(this.subPic.getOfsX(), this.subPic.getOfsY());
            this.jPanelPreview.setDim(this.subPic.width, this.subPic.height);
            this.jPanelPreview.setImage(this.image, this.subPic.getImageWidth(), this.subPic.getImageHeight());
            this.jPanelPreview.setScreenRatio(screenRatioTrg);
            this.jPanelPreview.setCropOfsY(this.cropOfsY);
            this.jPanelPreview.setExcluded(this.subPic.exclude);
            this.jPanelPreview.repaint();
            this.isReady = true;
        }
        catch (CoreException ex) {
            this.error(ex.getMessage());
        }
        catch (Exception ex) {
            ToolBox.showException(ex);
            Core.exit();
            System.exit(4);
        }
    }

    private JButton getJButton21_9() {
        if (this.jButton21_9 == null) {
            this.jButton21_9 = new JButton();
            this.jButton21_9.setText("21:9");
            this.jButton21_9.setToolTipText("Set inner frame ratio to 21:9");
            this.jButton21_9.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MoveDialog.this.setRatio(2.3333333333333335);
                }
            });
        }
        return this.jButton21_9;
    }

    private JButton getJButton240_1() {
        if (this.jButton240_1 == null) {
            this.jButton240_1 = new JButton();
            this.jButton240_1.setText("2.40:1");
            this.jButton240_1.setToolTipText("Set inner frame ratio to 2.40:1");
            this.jButton240_1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MoveDialog.this.setRatio(2.4);
                }
            });
        }
        return this.jButton240_1;
    }

    private JButton getJButton235_1() {
        if (this.jButton235_1 == null) {
            this.jButton235_1 = new JButton();
            this.jButton235_1.setText("2.35:1");
            this.jButton235_1.setToolTipText("Set inner frame ratio to 2.35:1");
            this.jButton235_1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MoveDialog.this.setRatio(2.35);
                }
            });
        }
        return this.jButton235_1;
    }

    private JRadioButton getJRadioButtonInside() {
        if (this.jRadioButtonInside == null) {
            this.jRadioButtonInside = new JRadioButton();
            this.jRadioButtonInside.setText("move inside bounds");
            this.jRadioButtonInside.setToolTipText("Move the subtitles inside the inner frame");
            this.jRadioButtonInside.setMnemonic('i');
            this.jRadioButtonInside.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MoveDialog.this.moveModeY = Core.MoveModeY.INSIDE;
                    MoveDialog.this.setRatio(screenRatioTrg);
                }
            });
        }
        return this.jRadioButtonInside;
    }

    private JRadioButton getJRadioButtonOutside() {
        if (this.jRadioButtonOutside == null) {
            this.jRadioButtonOutside = new JRadioButton();
            this.jRadioButtonOutside.setText("move outside bounds");
            this.jRadioButtonOutside.setToolTipText("Move the subtitles outside the inner frame as much as possible");
            this.jRadioButtonOutside.setMnemonic('o');
            this.jRadioButtonOutside.setDisplayedMnemonicIndex(5);
            this.jRadioButtonOutside.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MoveDialog.this.moveModeY = Core.MoveModeY.OUTSIDE;
                    MoveDialog.this.setRatio(screenRatioTrg);
                }
            });
        }
        return this.jRadioButtonOutside;
    }

    private JRadioButton getJRadioButtonKeepY() {
        if (this.jRadioButtonKeepY == null) {
            this.jRadioButtonKeepY = new JRadioButton();
            this.jRadioButtonKeepY.setText("keep Y position");
            this.jRadioButtonKeepY.setToolTipText("Don't alter current Y position");
            this.jRadioButtonKeepY.setMnemonic('y');
            this.jRadioButtonKeepY.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MoveDialog.this.moveModeY = Core.MoveModeY.KEEP;
                    MoveDialog.this.subPic.setOfsY(MoveDialog.this.originalY);
                    MoveDialog.this.setRatio(screenRatioTrg);
                }
            });
        }
        return this.jRadioButtonKeepY;
    }

    private void setRatio(double ratio) {
        if (!ToolBox.formatDouble(screenRatioTrg).equalsIgnoreCase(ToolBox.formatDouble(ratio))) {
            this.jTextFieldRatio.setText(ToolBox.formatDouble(ratio));
        }
        screenRatioTrg = ratio;
        this.cineBarFactor = (1.0 - 1.7777777777777777 / screenRatioTrg) / 2.0;
        this.move();
        this.jPanelPreview.setScreenRatio(screenRatioTrg);
        this.jPanelPreview.setOffsets(this.subPic.getOfsX(), this.subPic.getOfsY());
        this.jPanelPreview.repaint();
    }

    private void move() {
        Core.moveToBounds(this.subPic, this.index + 1, this.cineBarFactor, this.offsetX, this.offsetY, this.moveModeX, this.moveModeY, this.cropOfsY);
    }

    private JPanel getJPanelCrop() {
        if (this.jPanelCrop == null) {
            GridBagConstraints gridBagBtnCrop = new GridBagConstraints();
            gridBagBtnCrop.anchor = 13;
            gridBagBtnCrop.insets = new Insets(0, 0, 0, 0);
            gridBagBtnCrop.weightx = 10.0;
            GridBagConstraints gridBagLabelCropY = new GridBagConstraints();
            gridBagLabelCropY.anchor = 17;
            gridBagLabelCropY.insets = new Insets(0, 6, 0, 4);
            gridBagLabelCropY.weightx = 0.0;
            GridBagConstraints gridBagTextCropY = new GridBagConstraints();
            gridBagTextCropY.fill = 0;
            gridBagTextCropY.insets = new Insets(0, 0, 0, 0);
            gridBagTextCropY.anchor = 17;
            gridBagTextCropY.weightx = 2.0;
            this.jLabelCropOfsY = new JLabel();
            this.jLabelCropOfsY.setPreferredSize(dimLabel);
            this.jLabelCropOfsY.setSize(dimLabel);
            this.jLabelCropOfsY.setMinimumSize(dimLabel);
            this.jLabelCropOfsY.setMaximumSize(dimLabel);
            this.jLabelCropOfsY.setText("Crop Offset Y");
            this.jPanelCrop = new JPanel();
            this.jPanelCrop.setLayout(new GridBagLayout());
            this.jPanelCrop.setBorder(BorderFactory.createTitledBorder(null, "Crop", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
            this.jPanelCrop.add((Component)this.jLabelCropOfsY, gridBagLabelCropY);
            this.jPanelCrop.add((Component)this.getJTextFieldCropOfsY(), gridBagTextCropY);
            this.jPanelCrop.add((Component)this.getJButtonCropBars(), gridBagBtnCrop);
        }
        return this.jPanelCrop;
    }

    private JTextField getJTextFieldCropOfsY() {
        if (this.jTextFieldCropOfsY == null) {
            this.jTextFieldCropOfsY = new JTextField();
            this.jTextFieldCropOfsY.setPreferredSize(dimText);
            this.jTextFieldCropOfsY.setSize(dimText);
            this.jTextFieldCropOfsY.setMinimumSize(dimText);
            this.jTextFieldCropOfsY.setMaximumSize(dimText);
            this.jTextFieldCropOfsY.setToolTipText("Set number of lines to be cropped from upper and lower border");
            this.jTextFieldCropOfsY.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MoveDialog.this.isReady) {
                        int y = ToolBox.getInt(MoveDialog.this.jTextFieldCropOfsY.getText());
                        if (y == -1) {
                            y = MoveDialog.this.cropOfsY;
                        } else if (y < 0) {
                            y = 0;
                        } else if (y > ((MoveDialog)MoveDialog.this).subPic.height / 3) {
                            y = ((MoveDialog)MoveDialog.this).subPic.height / 3;
                        }
                        if (y != MoveDialog.this.cropOfsY) {
                            MoveDialog.this.cropOfsY = y;
                            MoveDialog.this.jPanelPreview.setCropOfsY(MoveDialog.this.cropOfsY);
                            MoveDialog.this.setRatio(screenRatioTrg);
                        }
                        MoveDialog.this.jTextFieldCropOfsY.setText("" + MoveDialog.this.cropOfsY);
                    }
                }
            });
            this.jTextFieldCropOfsY.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (MoveDialog.this.isReady) {
                        int y = ToolBox.getInt(MoveDialog.this.jTextFieldCropOfsY.getText());
                        if (y < 0 || y > ((MoveDialog)MoveDialog.this).subPic.height / 3) {
                            MoveDialog.this.jTextFieldCropOfsY.setBackground(MoveDialog.this.errBgnd);
                        } else {
                            if (y != MoveDialog.this.cropOfsY) {
                                MoveDialog.this.cropOfsY = y;
                                MoveDialog.this.jPanelPreview.setCropOfsY(MoveDialog.this.cropOfsY);
                                MoveDialog.this.setRatio(screenRatioTrg);
                            }
                            MoveDialog.this.jTextFieldCropOfsY.setBackground(MoveDialog.this.okBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldCropOfsY;
    }

    private JButton getJButtonCropBars() {
        if (this.jButtonCropBars == null) {
            this.jButtonCropBars = new JButton();
            this.jButtonCropBars.setToolTipText("Set crop offsets to cinemascope bars");
            this.jButtonCropBars.setText("Crop Bars");
            this.jButtonCropBars.setPreferredSize(new Dimension(79, 23));
            this.jButtonCropBars.setMnemonic('c');
            this.jButtonCropBars.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MoveDialog.this.cropOfsY = (int)((double)((MoveDialog)MoveDialog.this).subPic.height * MoveDialog.this.cineBarFactor + 0.5);
                    MoveDialog.this.jPanelPreview.setCropOfsY(MoveDialog.this.cropOfsY);
                    MoveDialog.this.setRatio(screenRatioTrg);
                    MoveDialog.this.jTextFieldCropOfsY.setText("" + MoveDialog.this.cropOfsY);
                }
            });
        }
        return this.jButtonCropBars;
    }

    public double getTrgRatio() {
        return screenRatioTrg;
    }

    private JRadioButton getJRadioButtonKeepX() {
        if (this.jRadioButtonKeepX == null) {
            this.jRadioButtonKeepX = new JRadioButton();
            this.jRadioButtonKeepX.setText("keep X position");
            this.jRadioButtonKeepX.setToolTipText("Don't alter current X position");
            this.jRadioButtonKeepX.setMnemonic('x');
            this.jRadioButtonKeepX.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MoveDialog.this.moveModeX = Core.MoveModeX.KEEP;
                    MoveDialog.this.subPic.setOfsX(MoveDialog.this.originalX);
                    MoveDialog.this.setRatio(screenRatioTrg);
                }
            });
        }
        return this.jRadioButtonKeepX;
    }

    private JRadioButton getJRadioButtonLeft() {
        if (this.jRadioButtonLeft == null) {
            this.jRadioButtonLeft = new JRadioButton();
            this.jRadioButtonLeft.setText("move left");
            this.jRadioButtonLeft.setToolTipText("Move to the left");
            this.jRadioButtonLeft.setMnemonic('l');
            this.jRadioButtonLeft.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MoveDialog.this.moveModeX = Core.MoveModeX.LEFT;
                    MoveDialog.this.setRatio(screenRatioTrg);
                }
            });
        }
        return this.jRadioButtonLeft;
    }

    private JRadioButton getJRadioButtonRight() {
        if (this.jRadioButtonRight == null) {
            this.jRadioButtonRight = new JRadioButton();
            this.jRadioButtonRight.setText("move right");
            this.jRadioButtonRight.setToolTipText("Move to the right");
            this.jRadioButtonRight.setMnemonic('r');
            this.jRadioButtonRight.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MoveDialog.this.moveModeX = Core.MoveModeX.RIGHT;
                    MoveDialog.this.setRatio(screenRatioTrg);
                }
            });
        }
        return this.jRadioButtonRight;
    }

    private JRadioButton getJRadioButtonCenter() {
        if (this.jRadioButtonCenter == null) {
            this.jRadioButtonCenter = new JRadioButton();
            this.jRadioButtonCenter.setText("move to center");
            this.jRadioButtonCenter.setToolTipText("Move to center");
            this.jRadioButtonCenter.setMnemonic('c');
            this.jRadioButtonCenter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MoveDialog.this.moveModeX = Core.MoveModeX.CENTER;
                    MoveDialog.this.setRatio(screenRatioTrg);
                }
            });
        }
        return this.jRadioButtonCenter;
    }

    private JTextField getJTextFieldOffsetX() {
        if (this.jTextFieldOffsetX == null) {
            this.jTextFieldOffsetX = new JTextField();
            this.jTextFieldOffsetX.setPreferredSize(dimText);
            this.jTextFieldOffsetX.setSize(dimText);
            this.jTextFieldOffsetX.setMinimumSize(dimText);
            this.jTextFieldOffsetX.setMaximumSize(dimText);
            this.jTextFieldOffsetX.setToolTipText("Set offset from left/right border in pixels");
            this.jTextFieldOffsetX.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MoveDialog.this.isReady) {
                        int x = ToolBox.getInt(MoveDialog.this.jTextFieldOffsetX.getText());
                        if (x == -1) {
                            x = MoveDialog.this.offsetX;
                        } else if (x < 0) {
                            x = 0;
                        } else if (x > ((MoveDialog)MoveDialog.this).subPic.width / 3) {
                            x = ((MoveDialog)MoveDialog.this).subPic.width / 3;
                        }
                        if (x != MoveDialog.this.offsetX) {
                            MoveDialog.this.offsetX = x;
                            MoveDialog.this.setRatio(screenRatioTrg);
                        }
                        MoveDialog.this.jTextFieldOffsetX.setText("" + MoveDialog.this.offsetX);
                    }
                }
            });
            this.jTextFieldOffsetX.getDocument().addDocumentListener(new DocumentListener(){

                private void check(DocumentEvent e) {
                    if (MoveDialog.this.isReady) {
                        int x = ToolBox.getInt(MoveDialog.this.jTextFieldOffsetX.getText());
                        if (x < 0 || x > ((MoveDialog)MoveDialog.this).subPic.width / 3) {
                            MoveDialog.this.jTextFieldOffsetX.setBackground(MoveDialog.this.errBgnd);
                        } else {
                            if (x != MoveDialog.this.offsetX) {
                                MoveDialog.this.offsetX = x;
                                MoveDialog.this.setRatio(screenRatioTrg);
                            }
                            MoveDialog.this.jTextFieldOffsetX.setBackground(MoveDialog.this.okBgnd);
                        }
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check(e);
                }
            });
        }
        return this.jTextFieldOffsetX;
    }
}

